/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.leveling.client;

import com.gametechbc.traveloptics.entity.mobs.nightwarden_boss.NightwardenBossEntity;
import com.minecraftserverzone.mobhealthbar.configs.ConfigHolder;
import daripher.autoleveling.event.MobsLevelingEvents;
import dev.muon.otherworld.leveling.LevelingUtils;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otherworld", value={Dist.CLIENT})
public class LevelDisplayRenderer {
    private static final float TEXT_SCALE = -0.02f;
    private static final Map<UUID, Integer> playerLevels = new HashMap<UUID, Integer>();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderNameTag(RenderNameTagEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (!LevelDisplayRenderer.shouldRender(entity2)) {
            return;
        }
        int entityLevel = LevelDisplayRenderer.getEntityLevel(entity2);
        if (entityLevel <= 0) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        Component baseNameComponent = event.getContent();
        String baseNameString = baseNameComponent.getString();
        if (baseNameString.trim().isEmpty() && !(entity2 instanceof Player)) {
            baseNameComponent = entity2.m_7755_();
        }
        MutableComponent levelTextComponent = Component.m_237113_((String)(" Level " + entityLevel)).m_130938_(arg_0 -> LevelDisplayRenderer.lambda$onRenderNameTag$0((Player)player, entity2, arg_0));
        MutableComponent newContent = baseNameComponent.m_6881_().m_7220_((Component)levelTextComponent);
        event.setContent((Component)newContent);
        event.setResult(Event.Result.ALLOW);
    }

    private static int getEntityLevel(LivingEntity entity) {
        if (entity instanceof Player) {
            return playerLevels.getOrDefault(entity.m_20148_(), 0);
        }
        return LevelingUtils.getEntityLevel(entity);
    }

    public static void updatePlayerLevel(UUID playerId, int level) {
        playerLevels.put(playerId, level);
    }

    private static boolean shouldRender(LivingEntity entity) {
        if (!MobsLevelingEvents.shouldShowLevel((Entity)entity)) {
            return false;
        }
        if (entity instanceof NightwardenBossEntity) {
            return true;
        }
        if (entity instanceof TargetDummyEntity || entity instanceof AntiMagicSusceptible && !(entity instanceof MagicSummon)) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return false;
        }
        double distanceSq = player.m_20280_((Entity)entity);
        double renderDistance = ((Integer)ConfigHolder.COMMON.HP_BAR_TYPE[3].get()).intValue();
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 reachVec = eyePos.m_82520_(lookVec.f_82479_ * renderDistance, lookVec.f_82480_ * renderDistance, lookVec.f_82481_ * renderDistance);
        AABB boundingBox = entity.m_20191_().m_82400_(0.5);
        EntityHitResult result = boundingBox.m_82371_(eyePos, reachVec).map(hit -> new EntityHitResult((Entity)entity, hit)).orElse(null);
        return result != null && result.m_82443_() == entity && distanceSq <= renderDistance;
    }

    private static int getLevelColor(Player player, LivingEntity entity) {
        int playerLevel = LevelDisplayRenderer.getEntityLevel((LivingEntity)player);
        int entityLevel = LevelDisplayRenderer.getEntityLevel(entity);
        if (playerLevel > 0) {
            int levelDifference = entityLevel - playerLevel;
            if (levelDifference > 10) {
                return 0xFF0000;
            }
            if (levelDifference > -5) {
                return 0xFFFF00;
            }
            return 65280;
        }
        if (entityLevel < 8) {
            return 65280;
        }
        if (entityLevel <= 19) {
            return 0xFFFF00;
        }
        return 0xFF0000;
    }

    private static /* synthetic */ Style lambda$onRenderNameTag$0(Player player, LivingEntity entity, Style style) {
        return style.m_178520_(LevelDisplayRenderer.getLevelColor(player, entity));
    }
}

