/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.leveling;

import dev.muon.otherworld.leveling.LevelingUtils;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;

public class StoryProgressionRestriction {
    private static final int CHAPTER_1_THRESHOLD = 6;
    private static final int CHAPTER_2_THRESHOLD = 9;
    private static final int CHAPTER_3_THRESHOLD = 12;
    private static final int CHAPTER_4_THRESHOLD = 15;
    private static final int CHAPTER_5_THRESHOLD = 18;
    private static final String CHAPTER_1_STAGE = "chapter_1";
    private static final String CHAPTER_2_STAGE = "chapter_2";
    private static final String CHAPTER_3_STAGE = "chapter_3";
    private static final String CHAPTER_4_STAGE = "chapter_4";
    private static final String CHAPTER_5_STAGE = "chapter_5";

    public static boolean canLevelUp(Player player, int currentGlobalLevel) {
        if (player.m_7500_()) {
            return true;
        }
        if (!ModList.get().isLoaded("gamestages")) {
            return true;
        }
        int currentLevel = LevelingUtils.getPlayerLevel(player);
        if (currentLevel >= 18) {
            return StoryProgressionRestriction.hasGameStage(player, CHAPTER_5_STAGE);
        }
        if (currentLevel >= 15) {
            return StoryProgressionRestriction.hasGameStage(player, CHAPTER_4_STAGE);
        }
        if (currentLevel >= 12) {
            return StoryProgressionRestriction.hasGameStage(player, CHAPTER_3_STAGE);
        }
        if (currentLevel >= 9) {
            return StoryProgressionRestriction.hasGameStage(player, CHAPTER_2_STAGE);
        }
        if (currentLevel >= 6) {
            return StoryProgressionRestriction.hasGameStage(player, CHAPTER_1_STAGE);
        }
        return true;
    }

    @Nullable
    public static Component getRestrictionTooltip(Player player, int currentGlobalLevel) {
        if (!ModList.get().isLoaded("gamestages")) {
            return null;
        }
        int currentLevel = LevelingUtils.getPlayerLevel(player);
        String requiredStage = null;
        if (currentLevel >= 18) {
            requiredStage = CHAPTER_5_STAGE;
        } else if (currentLevel >= 15) {
            requiredStage = CHAPTER_4_STAGE;
        } else if (currentLevel >= 12) {
            requiredStage = CHAPTER_3_STAGE;
        } else if (currentLevel >= 9) {
            requiredStage = CHAPTER_2_STAGE;
        } else if (currentLevel >= 6) {
            requiredStage = CHAPTER_1_STAGE;
        }
        if (requiredStage == null) {
            return null;
        }
        if (StoryProgressionRestriction.hasGameStage(player, requiredStage)) {
            return null;
        }
        String chapterName = StoryProgressionRestriction.getChapterDisplayName(requiredStage);
        return Component.m_237110_((String)"tooltip.otherworld.aptitude.story_restriction", (Object[])new Object[]{chapterName}).m_130940_(ChatFormatting.RED);
    }

    private static String getChapterDisplayName(String stage) {
        switch (stage) {
            case "chapter_1": {
                return "Chapter 1: Ghosts of Ages Past";
            }
            case "chapter_2": {
                return "Chapter 2: Whispers On The Wind";
            }
            case "chapter_3": {
                return "Chapter 3: Core of the World";
            }
            case "chapter_4": {
                return "Chapter 4: Buried Secrets";
            }
            case "chapter_5": {
                return "Chapter 5: Dragons & Deities";
            }
        }
        return "Unknown Chapter";
    }

    private static boolean hasGameStage(Player player, String stage) {
        try {
            Class<?> gameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
            Method hasStageMethod = gameStageHelper.getMethod("hasStage", Player.class, String.class);
            return (Boolean)hasStageMethod.invoke(null, player, stage);
        }
        catch (Exception e) {
            return true;
        }
    }
}

