/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.leveling;

import dev.muon.otherworld.leveling.LevelingUtils;
import dev.muon.otherworld.leveling.client.LevelDisplayRenderer;
import dev.muon.otherworld.leveling.event.AptitudeChangedEvent;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="otherworld")
public class LevelSyncHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("otherworld", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> INSTANCE.registerMessage(0, SyncPlayerLevelPacket.class, SyncPlayerLevelPacket::encode, SyncPlayerLevelPacket::decode, SyncPlayerLevelPacket::handle));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            int level = LevelingUtils.getPlayerLevel(event.getEntity());
            INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncPlayerLevelPacket(event.getEntity().m_20148_(), level));
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            int level = LevelingUtils.getPlayerLevel(event.getEntity());
            INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncPlayerLevelPacket(event.getEntity().m_20148_(), level));
        }
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            int level = LevelingUtils.getPlayerLevel(event.getEntity());
            INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncPlayerLevelPacket(event.getEntity().m_20148_(), level));
        }
    }

    @SubscribeEvent
    public static void onAptitudeChanged(AptitudeChangedEvent event) {
        if (!event.getPlayer().m_9236_().f_46443_) {
            int newLevel = LevelingUtils.getPlayerLevel(event.getPlayer());
            INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncPlayerLevelPacket(event.getPlayer().m_20148_(), newLevel));
        }
    }

    public static class SyncPlayerLevelPacket {
        public final UUID playerId;
        public final int level;

        public SyncPlayerLevelPacket(UUID playerId, int level) {
            this.playerId = playerId;
            this.level = level;
        }

        public static void encode(SyncPlayerLevelPacket packet, FriendlyByteBuf buffer) {
            buffer.m_130077_(packet.playerId);
            buffer.writeInt(packet.level);
        }

        public static SyncPlayerLevelPacket decode(FriendlyByteBuf buffer) {
            return new SyncPlayerLevelPacket(buffer.m_130259_(), buffer.readInt());
        }

        public static void handle(SyncPlayerLevelPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> LevelDisplayRenderer.updatePlayerLevel(packet.playerId, packet.level));
            ctx.get().setPacketHandled(true);
        }
    }
}

