/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.item;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class VoidCompassItem
extends CompassItem
implements Vanishable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_TARGET_POS = "VoidCompassTargetPos";
    public static final String TAG_TARGET_DIMENSION = "VoidCompassDimension";
    public static final String TAG_LAST_SEARCH_TIME = "VoidLastSearchTime";
    private static final long SEARCH_COOLDOWN_TICKS = 200L;
    private static final int SEARCH_RADIUS_CHUNKS = 100;
    private static final ResourceKey<Structure> TARGET_STRUCTURE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("integrated_stronghold", "stronghold"));

    public VoidCompassItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"item.otherworld.void_compass.tooltip").m_130940_(ChatFormatting.DARK_PURPLE));
        if (pStack.m_41782_() && pStack.m_41783_().m_128441_(TAG_TARGET_POS)) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.otherworld.void_compass.locked").m_130940_(ChatFormatting.GREEN));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.otherworld.void_compass.searching").m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.m_21120_(pUsedHand);
        CompoundTag tag = itemstack.m_41784_();
        if (!pLevel.f_46443_) {
            long lastSearchTime;
            ServerLevel serverLevel = (ServerLevel)pLevel;
            long currentTime = serverLevel.m_46467_();
            if (currentTime - (lastSearchTime = tag.m_128454_(TAG_LAST_SEARCH_TIME)) >= 200L) {
                tag.m_128356_(TAG_LAST_SEARCH_TIME, currentTime);
                this.findAndSetNearestStronghold(serverLevel, pPlayer.m_20183_(), itemstack);
            } else {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"item.otherworld.void_compass.cooldown"), true);
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
    }

    private void findAndSetNearestStronghold(ServerLevel pLevel, BlockPos pPos, ItemStack pStack) {
        pLevel.m_7654_().execute(() -> {
            Optional targetStructureHolderOpt = pLevel.m_9598_().m_175515_(Registries.f_256944_).m_203636_(TARGET_STRUCTURE_KEY);
            if (targetStructureHolderOpt.isEmpty()) {
                LOGGER.error("Target structure {} not found in registry!", (Object)TARGET_STRUCTURE_KEY.m_135782_());
                return;
            }
            Holder.Reference targetStructureHolder = (Holder.Reference)targetStructureHolderOpt.get();
            HolderSet.Direct targetStructureSet = HolderSet.m_205809_((Holder[])new Holder[]{targetStructureHolder});
            Pair result = pLevel.m_7726_().m_8481_().m_223037_(pLevel, (HolderSet)targetStructureSet, pPos, 100, false);
            CompoundTag tag = pStack.m_41784_();
            if (result != null) {
                BlockPos targetPos = (BlockPos)result.getFirst();
                tag.m_128365_(TAG_TARGET_POS, (Tag)NbtUtils.m_129224_((BlockPos)targetPos));
                tag.m_128359_(TAG_TARGET_DIMENSION, pLevel.m_46472_().m_135782_().toString());
                LOGGER.info("Void Compass found stronghold at {}", (Object)targetPos);
                pLevel.m_5594_(null, pPos, SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                tag.m_128473_(TAG_TARGET_POS);
                tag.m_128473_(TAG_TARGET_DIMENSION);
                LOGGER.info("Void Compass could not find stronghold within {} chunks of {}", (Object)100, (Object)pPos);
                pLevel.m_5594_(null, pPos, SoundEvents.f_12107_, SoundSource.PLAYERS, 0.8f, 1.5f);
            }
        });
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pItemSlot, boolean pIsSelected) {
        if (!pLevel.f_46443_ && pStack.m_41782_()) {
            CompoundTag tag = pStack.m_41783_();
            boolean updated = false;
            if (tag.m_128441_(TAG_TARGET_POS) && !tag.m_128441_("LodestonePos")) {
                tag.m_128365_("LodestonePos", tag.m_128423_(TAG_TARGET_POS).m_6426_());
                updated = true;
            }
            if (tag.m_128441_(TAG_TARGET_DIMENSION) && !tag.m_128441_("LodestoneDimension")) {
                tag.m_128359_("LodestoneDimension", tag.m_128461_(TAG_TARGET_DIMENSION));
                updated = true;
            }
        }
        super.m_6883_(pStack, pLevel, pEntity, pItemSlot, pIsSelected);
    }

    @Nullable
    public static GlobalPos getTargetPosition(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag != null) {
            boolean flag = compoundtag.m_128441_(TAG_TARGET_POS);
            boolean flag1 = compoundtag.m_128441_(TAG_TARGET_DIMENSION);
            if (flag && flag1) {
                try {
                    Optional optional = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundtag.m_128423_(TAG_TARGET_DIMENSION)).result();
                    if (optional.isPresent()) {
                        BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)compoundtag.m_128469_(TAG_TARGET_POS));
                        return GlobalPos.m_122643_((ResourceKey)((ResourceKey)optional.get()), (BlockPos)blockpos);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing Void Compass target NBT", (Throwable)e);
                }
            }
        }
        return null;
    }

    public boolean m_41475_() {
        return true;
    }
}

