/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.item;

import dev.muon.otherworld.config.OtherworldConfig;
import dev.muon.otherworld.structure.StructureRegenerator;
import dev.muon.otherworld.world.saved_data.StructureRegenerationState;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class ChallengeOrbItem
extends Item {
    private static final int SEARCH_COOLDOWN = 25;
    private static final int COOLDOWN_TICKS = 600;
    private static final int SEARCH_TIMEOUT_TICKS = 100;

    public ChallengeOrbItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"item.otherworld.challenge_orb.tooltip").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.otherworld.challenge_orb.tooltip_bypass").m_130940_(ChatFormatting.DARK_GRAY));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        long searchTime;
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack itemStack = player.m_21120_(hand);
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_("FoundStructure")) {
            this.findStructure(serverLevel, player, itemStack);
            player.m_36335_().m_41524_((Item)this, 25);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        long currentTime = serverLevel.m_46467_();
        if (currentTime - (searchTime = tag.m_128454_("SearchTime")) > 100L) {
            tag.m_128473_("FoundStructure");
            tag.m_128473_("SearchTime");
            this.findStructure(serverLevel, player, itemStack);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        this.confirmAndRegenerate(serverLevel, player, itemStack);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    private void findStructure(ServerLevel level, Player player, ItemStack itemStack) {
        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
        for (Structure structure : structureRegistry) {
            ResourceLocation structureId = structureRegistry.m_7981_((Object)structure);
            if (!StructureRegenerator.isValidStructure(structureId)) continue;
            player.m_5661_((Component)Component.m_237115_((String)"item.otherworld.challenge_orb.searching").m_130940_(ChatFormatting.YELLOW), true);
            if (StructureRegenerator.findNearestStructure(level, player.m_20183_(), structureId) == null) continue;
            CompoundTag tag = itemStack.m_41784_();
            tag.m_128359_("FoundStructure", structureId.toString());
            tag.m_128356_("SearchTime", level.m_46467_());
            player.m_5661_((Component)Component.m_237110_((String)"item.otherworld.challenge_orb.found", (Object[])new Object[]{structureId}).m_130940_(ChatFormatting.GREEN), true);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12376_, SoundSource.PLAYERS, 1.0f, 2.0f);
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)"item.otherworld.challenge_orb.not_found").m_130940_(ChatFormatting.RED), true);
    }

    private void confirmAndRegenerate(ServerLevel level, Player player, ItemStack itemStack) {
        StructureRegenerationState.StructureInteraction interaction;
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null || !tag.m_128441_("FoundStructure")) {
            return;
        }
        ResourceLocation structureId = new ResourceLocation(tag.m_128461_("FoundStructure"));
        long currentTime = level.m_46467_();
        StructureStart start = StructureRegenerator.findNearestStructure(level, player.m_20183_(), structureId);
        if (start == null || !start.m_73603_()) {
            player.m_5661_((Component)Component.m_237115_((String)"item.otherworld.challenge_orb.not_found").m_130940_(ChatFormatting.RED), true);
            tag.m_128473_("FoundStructure");
            return;
        }
        if (StructureRegenerator.isAnyClaimed(level, start.m_73601_()) != null) {
            player.m_5661_((Component)Component.m_237110_((String)"item.otherworld.challenge_orb.claimed", (Object[])new Object[]{structureId}).m_130940_(ChatFormatting.RED), true);
            tag.m_128473_("FoundStructure");
            return;
        }
        StructureRegenerationState data = StructureRegenerationState.get(level);
        if (data.hasRecentInteraction(structureId, currentTime, OtherworldConfig.get().structureInactivityTimeoutSeconds) && (interaction = data.getLastInteraction(structureId)) != null) {
            long timeSince = (currentTime - interaction.timestamp) / 20L;
            player.m_5661_((Component)Component.m_237110_((String)"item.otherworld.challenge_orb.recent_activity", (Object[])new Object[]{structureId, interaction.type.name().toLowerCase(), timeSince}).m_130940_(ChatFormatting.YELLOW), false);
            player.m_5661_((Component)Component.m_237115_((String)"item.otherworld.challenge_orb.confirm_override").m_130940_(ChatFormatting.GOLD), false);
            tag.m_128379_("OverrideActivity", true);
            tag.m_128356_("OverrideTime", currentTime);
            return;
        }
        boolean overrideActivity = tag.m_128471_("OverrideActivity");
        long overrideTime = tag.m_128454_("OverrideTime");
        if (!overrideActivity || currentTime - overrideTime > 100L) {
            tag.m_128473_("OverrideActivity");
            tag.m_128473_("OverrideTime");
        }
        if (!overrideActivity && this.hasOtherPlayersInStructure(level, player, start.m_73601_())) {
            player.m_5661_((Component)Component.m_237110_((String)"item.otherworld.challenge_orb.players_present", (Object[])new Object[]{structureId}).m_130940_(ChatFormatting.YELLOW), false);
            player.m_5661_((Component)Component.m_237115_((String)"item.otherworld.challenge_orb.confirm_override").m_130940_(ChatFormatting.GOLD), false);
            tag.m_128379_("OverrideActivity", true);
            tag.m_128356_("OverrideTime", currentTime);
            return;
        }
        player.m_5661_((Component)Component.m_237110_((String)"item.otherworld.challenge_orb.regenerating", (Object[])new Object[]{structureId}).m_130940_(ChatFormatting.YELLOW), true);
        StructureRegenerator.RegenerationResult result = StructureRegenerator.regenerateStructure(level, player.m_20183_(), structureId);
        if (result.success) {
            data.clearStructureInteraction(structureId);
            player.m_5661_((Component)Component.m_237110_((String)"item.otherworld.challenge_orb.success", (Object[])new Object[]{result.message}).m_130940_(ChatFormatting.GREEN), true);
            player.m_36335_().m_41524_((Item)this, 600);
            itemStack.m_41774_(1);
        } else {
            player.m_5661_((Component)Component.m_237110_((String)"item.otherworld.challenge_orb.fail", (Object[])new Object[]{result.message}).m_130940_(ChatFormatting.RED), true);
        }
        tag.m_128473_("FoundStructure");
        tag.m_128473_("OverrideActivity");
        tag.m_128473_("OverrideTime");
    }

    private boolean hasOtherPlayersInStructure(ServerLevel level, Player excludePlayer, BoundingBox boundingBox) {
        AABB aabb = new AABB((double)boundingBox.m_162395_(), (double)boundingBox.m_162396_(), (double)boundingBox.m_162398_(), (double)(boundingBox.m_162399_() + 1), (double)(boundingBox.m_162400_() + 1), (double)(boundingBox.m_162401_() + 1));
        List playersInStructure = level.m_45976_(Player.class, aabb);
        return playersInStructure.stream().anyMatch(p -> p != excludePlayer && p instanceof ServerPlayer);
    }
}

