/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.event;

import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.config.OtherworldConfig;
import dev.muon.otherworld.world.saved_data.StructureRegenerationState;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otherworld")
public class StructureInteractionEvents {
    @SubscribeEvent
    public static void onContainerOpen(PlayerInteractEvent.RightClickBlock event) {
        ResourceLocation structureId;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos pos = event.getPos();
        BlockEntity blockEntity = level2.m_7702_(pos);
        if (blockEntity instanceof RandomizableContainerBlockEntity && (structureId = StructureInteractionEvents.findStructureAt(level2, pos)) != null && OtherworldConfig.get().isStructureWhitelisted(structureId)) {
            StructureRegenerationState data = StructureRegenerationState.get(level2);
            data.recordStructureInteraction(structureId, player2.m_20148_(), level2.m_46467_(), StructureRegenerationState.InteractionType.CHEST_OPENED);
            Otherworld.LOGGER.debug("Recorded chest interaction at {} in structure {}", (Object)pos, (Object)structureId);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Entity target = event.getTarget();
        BlockPos pos = target.m_20183_();
        ResourceLocation structureId = StructureInteractionEvents.findStructureAt(level2, pos);
        if (structureId != null && OtherworldConfig.get().isStructureWhitelisted(structureId)) {
            StructureRegenerationState data = StructureRegenerationState.get(level2);
            data.recordStructureInteraction(structureId, player2.m_20148_(), level2.m_46467_(), StructureRegenerationState.InteractionType.ENTITY_INTERACTED);
            Otherworld.LOGGER.debug("Recorded entity interaction at {} in structure {}", (Object)pos, (Object)structureId);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (event.getSource() == null) {
            return;
        }
        Entity entity2 = event.getSource().m_7639_();
        if (!(entity2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity2;
        BlockPos pos = entity.m_20183_();
        ResourceLocation structureId = StructureInteractionEvents.findStructureAt(level2, pos);
        if (structureId != null && OtherworldConfig.get().isStructureWhitelisted(structureId)) {
            StructureRegenerationState data = StructureRegenerationState.get(level2);
            data.recordStructureInteraction(structureId, player.m_20148_(), level2.m_46467_(), StructureRegenerationState.InteractionType.ENTITY_DAMAGED);
            Otherworld.LOGGER.debug("Recorded entity damage at {} in structure {}", (Object)pos, (Object)structureId);
        }
    }

    private static ResourceLocation findStructureAt(ServerLevel level, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Map structuresInChunk = level.m_215010_().m_220522_(chunkPos.m_45615_());
        for (Map.Entry entry : structuresInChunk.entrySet()) {
            BoundingBox boundingBox;
            StructureStart start;
            ResourceLocation structureId = level.m_9598_().m_175515_(Registries.f_256944_).m_7981_((Object)((Structure)entry.getKey()));
            if (structureId == null || (start = level.m_215010_().m_220512_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)0), (Structure)entry.getKey(), (StructureAccess)level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_))) == null || !start.m_73603_() || !StructureInteractionEvents.isPositionInStructure(pos, boundingBox = start.m_73601_())) continue;
            return structureId;
        }
        return null;
    }

    private static boolean isPositionInStructure(BlockPos pos, BoundingBox boundingBox) {
        return pos.m_123341_() >= boundingBox.m_162395_() && pos.m_123341_() <= boundingBox.m_162399_() && pos.m_123342_() >= boundingBox.m_162396_() && pos.m_123342_() <= boundingBox.m_162400_() && pos.m_123343_() >= boundingBox.m_162398_() && pos.m_123343_() <= boundingBox.m_162401_();
    }
}

