/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.event;

import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.google.common.collect.ImmutableMap;
import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.item.ItemRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="otherworld")
public class StoryItemInjectEvents {
    private static final ResourceLocation FIRST_ZOMBIE_KILL_ADVANCEMENT = new ResourceLocation("otherworld", "story/first_zombie_kill");
    private static final ResourceLocation NIGHTWARDEN_FREED_ADVANCEMENT = new ResourceLocation("otherworld", "story/nightwarden_freed");
    private static final Map<UUID, Integer> playerZombieKillCounts = new HashMap<UUID, Integer>();
    private static final ResourceLocation NIGHTWARDEN_ID = new ResourceLocation("traveloptics", "the_nightwarden");
    private static final ResourceLocation POSSESSED_PALADIN_ID = new ResourceLocation("legendary_monsters", "posessed_paladin");
    private static final ResourceLocation CAPTAIN_CORNELIA_ID = new ResourceLocation("aquamirae", "captain_cornelia");
    private static final ResourceLocation FRENZIED_SHADE_ID = new ResourceLocation("soulsweapons", "night_shade");
    private static final ResourceLocation DAY_STALKER_ID = new ResourceLocation("soulsweapons", "day_stalker");
    private static final ResourceLocation NIGHT_PROWLER_ID = new ResourceLocation("soulsweapons", "night_prowler");
    private static final ResourceLocation CHAOS_MONARCH_ID = new ResourceLocation("soulsweapons", "chaos_monarch");
    private static final ResourceLocation DARK_DOPPELGANGER_ID = new ResourceLocation("darkdoppelganger", "dark_doppelganger");
    private static final ResourceLocation NIGHT_LICH_ID = new ResourceLocation("bosses_of_mass_destruction", "lich");
    private static final ResourceLocation DEAD_KING_ID = new ResourceLocation("irons_spellbooks", "dead_king");
    private static final ResourceLocation VALKYRIE_QUEEN_ID = new ResourceLocation("aether", "valkyrie_queen");
    private static final ResourceLocation SUN_SPIRIT_ID = new ResourceLocation("aether", "sun_spirit");
    private static final ResourceLocation AERWHALE_KING_ID = new ResourceLocation("lost_aether_content", "aerwhale_king");
    private static final ResourceLocation MUTATED_AECHOR_PLANT_ID = new ResourceLocation("ancient_aether", "mutated_aechor_plant");
    private static final ResourceLocation CORPSE_WARLOCK_ID = new ResourceLocation("eeeabsmobs", "corpse_warlock");
    private static final ResourceLocation FERROUS_WROUGHTNAUT_ID = new ResourceLocation("mowziesmobs", "ferrous_wroughtnaut");
    private static final ResourceLocation NAMELESS_GUARDIAN_ID = new ResourceLocation("eeeabsmobs", "nameless_guardian");
    private static final ResourceLocation PYROMANCER_ID = new ResourceLocation("irons_spellbooks", "pyromancer");
    private static final ResourceLocation CRYOMANCER_ID = new ResourceLocation("irons_spellbooks", "cryomancer");
    private static final ResourceLocation ARCHEVOKER_ID = new ResourceLocation("irons_spellbooks", "archevoker");
    private static final ResourceLocation ENDER_KING_ID = new ResourceLocation("animatedmobsmod", "ender_king");
    private static final ResourceLocation UMVUTHI_ID = new ResourceLocation("mowziesmobs", "umvuthi");
    private static final ResourceLocation AATROX_ID = new ResourceLocation("soulsweapons", "accursed_lord_boss");
    private static final Map<ResourceLocation, BossDropConsumer> BOSS_DROP_MAP = ImmutableMap.builder().put((Object)POSSESSED_PALADIN_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createKaelenJournal())).put((Object)CAPTAIN_CORNELIA_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createCorneliaLog())).put((Object)NIGHT_LICH_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createLichJournal())).put((Object)FRENZIED_SHADE_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createLichJournal())).put((Object)DEAD_KING_ID, StoryItemInjectEvents::createNecklaceAndLament).put((Object)VALKYRIE_QUEEN_ID, StoryItemInjectEvents::createValkyrieItems).put((Object)SUN_SPIRIT_ID, StoryItemInjectEvents::createSunSpiritItems).put((Object)AERWHALE_KING_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createCelestialEssence())).put((Object)MUTATED_AECHOR_PLANT_ID, StoryItemInjectEvents::createAechorItems).put((Object)CORPSE_WARLOCK_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createApexProjectBook())).put((Object)FERROUS_WROUGHTNAUT_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createWroughtnautInstructions())).put((Object)NAMELESS_GUARDIAN_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createGuardianMandate())).put((Object)PYROMANCER_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createFireStoneLoreBook())).put((Object)CRYOMANCER_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createIceStoneLoreBook())).put((Object)ARCHEVOKER_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createLightningStoneLoreBook())).put((Object)ENDER_KING_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createEnderKingDecree())).put((Object)UMVUTHI_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createUmvuthiProphecy())).put((Object)AATROX_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, new ItemStack((ItemLike)ItemRegistry.DECREPIT_SIGNET.get()))).put((Object)DAY_STALKER_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, new ItemStack((ItemLike)ItemRegistry.DAWN_SPLINTER.get()))).put((Object)NIGHT_PROWLER_ID, (entity, level) -> StoryItemInjectEvents.spawnItemNearEntity(level, entity, new ItemStack((ItemLike)ItemRegistry.TWILIGHT_SHARD.get()))).put((Object)DARK_DOPPELGANGER_ID, (entity, level) -> {
        StoryItemInjectEvents.spawnItemNearEntity(level, entity, new ItemStack((ItemLike)TravelopticsItems.EXCRUCIS.get()));
        StoryItemInjectEvents.spawnItemNearEntity(level, entity, StoryItemInjectEvents.createDoppelgangerReflection(entity));
    }).build();

    @SubscribeEvent
    public static void onAdvancementEarned(AdvancementEvent.AdvancementEarnEvent event) {
        if (event.getAdvancement().m_138327_().equals((Object)FIRST_ZOMBIE_KILL_ADVANCEMENT)) {
            playerZombieKillCounts.remove(event.getEntity().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        BossDropConsumer dropConsumer;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        LivingEntity killedEntity = event.getEntity();
        Level level = killedEntity.m_9236_();
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)killedEntity.m_6095_());
        if (entityId == null) {
            return;
        }
        if (killedEntity instanceof Zombie) {
            StoryItemInjectEvents.handleZombieKillIntermittent(player, serverLevel, killedEntity);
        }
        if (entityId.equals((Object)NIGHTWARDEN_ID)) {
            StoryItemInjectEvents.handleNightwardenFirstKill(player, serverLevel, killedEntity);
        }
        if ((dropConsumer = BOSS_DROP_MAP.get(entityId)) != null) {
            dropConsumer.accept(killedEntity, serverLevel);
        }
    }

    public static List<ItemStack> createIgnisLoot() {
        return List.of(StoryItemInjectEvents.createScorchedCore(), StoryItemInjectEvents.createIgnisPhilosophy());
    }

    public static List<ItemStack> createAncientRemnantLoot() {
        return List.of(StoryItemInjectEvents.createNexusBook());
    }

    public static List<ItemStack> createLeviathanLoot() {
        return List.of(StoryItemInjectEvents.createVoidResonator());
    }

    public static List<ItemStack> createMonstrosityLoot() {
        return List.of(StoryItemInjectEvents.createMonstrosityCore());
    }

    public static List<ItemStack> createGuardianLoot() {
        return List.of(StoryItemInjectEvents.createGuardianMandate());
    }

    public static List<ItemStack> createScyllaLoot() {
        return List.of(StoryItemInjectEvents.createScyllaLoreBook());
    }

    public static List<ItemStack> createHarbingerLoot() {
        return List.of(StoryItemInjectEvents.createHarbingerMessage());
    }

    public static List<ItemStack> createGauntletLoot() {
        return List.of(StoryItemInjectEvents.createGauntletsBrand());
    }

    public static List<ItemStack> createNightwardenLoot() {
        return List.of(StoryItemInjectEvents.createNightwardenMessage());
    }

    private static void handleZombieKillIntermittent(ServerPlayer player, ServerLevel serverLevel, LivingEntity zombie) {
        Advancement advancement = serverLevel.m_7654_().m_129889_().m_136041_(FIRST_ZOMBIE_KILL_ADVANCEMENT);
        if (advancement == null) {
            Otherworld.LOGGER.warn("Could not find advancement: {}", (Object)FIRST_ZOMBIE_KILL_ADVANCEMENT);
            return;
        }
        if (player.m_8960_().m_135996_(advancement).m_8193_()) {
            return;
        }
        UUID playerId = player.m_20148_();
        int killCount = playerZombieKillCounts.getOrDefault(playerId, 0) + 1;
        playerZombieKillCounts.put(playerId, killCount);
        if (killCount == 1 || killCount > 1 && (killCount - 1) % 5 == 0) {
            ItemStack missive = StoryItemInjectEvents.createLichMissive();
            StoryItemInjectEvents.spawnItemNearEntity(serverLevel, zombie, missive);
        }
    }

    private static void handleNightwardenFirstKill(ServerPlayer player, ServerLevel serverLevel, LivingEntity nightwarden) {
        Advancement advancement = serverLevel.m_7654_().m_129889_().m_136041_(NIGHTWARDEN_FREED_ADVANCEMENT);
        if (advancement == null) {
            Otherworld.LOGGER.warn("Could not find advancement: {}", (Object)NIGHTWARDEN_FREED_ADVANCEMENT);
            return;
        }
        if (player.m_8960_().m_135996_(advancement).m_8193_()) {
            return;
        }
        for (ItemStack stack : StoryItemInjectEvents.createNightwardenLoot()) {
            StoryItemInjectEvents.spawnItemNearEntity(serverLevel, nightwarden, stack);
        }
    }

    private static void spawnItemNearEntity(ServerLevel level, LivingEntity entity, ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        ItemEntity itemEntity = new ItemEntity((Level)level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
        itemEntity.m_32060_();
        level.m_7967_((Entity)itemEntity);
    }

    private static void createNecklaceAndLament(LivingEntity killedEntity, ServerLevel serverLevel) {
        StoryItemInjectEvents.spawnItemNearEntity(serverLevel, killedEntity, StoryItemInjectEvents.createNecklaceOfSorrow());
        StoryItemInjectEvents.spawnItemNearEntity(serverLevel, killedEntity, StoryItemInjectEvents.createDeadKingLament());
    }

    private static void createValkyrieItems(LivingEntity killedEntity, ServerLevel serverLevel) {
        StoryItemInjectEvents.spawnItemNearEntity(serverLevel, killedEntity, StoryItemInjectEvents.createValkyrieEssence());
    }

    private static void createSunSpiritItems(LivingEntity killedEntity, ServerLevel serverLevel) {
        StoryItemInjectEvents.spawnItemNearEntity(serverLevel, killedEntity, StoryItemInjectEvents.createSolarEssence());
    }

    private static void createAechorItems(LivingEntity killedEntity, ServerLevel serverLevel) {
        StoryItemInjectEvents.spawnItemNearEntity(serverLevel, killedEntity, StoryItemInjectEvents.createBlightedEssence());
    }

    private static void createIgnisItems(LivingEntity killedEntity, ServerLevel serverLevel) {
        StoryItemInjectEvents.spawnItemNearEntity(serverLevel, killedEntity, StoryItemInjectEvents.createScorchedCore());
        StoryItemInjectEvents.spawnItemNearEntity(serverLevel, killedEntity, StoryItemInjectEvents.createIgnisPhilosophy());
    }

    private static ItemStack createNecklaceOfSorrow() {
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.NECKLACE_OF_SORROW.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("otherworld:is_quest_item", true);
        stack.m_41751_(nbt);
        return stack;
    }

    private static ItemStack createMonstrosityCore() {
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.MONSTROSITY_CORE.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("otherworld:is_quest_item", true);
        stack.m_41751_(nbt);
        return stack;
    }

    private static ItemStack createGauntletsBrand() {
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.GAUNTLETS_BRAND.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("otherworld:is_quest_item", true);
        stack.m_41751_(nbt);
        return stack;
    }

    public static ItemStack createValkyrieEssence() {
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.VALKYRIE_ESSENCE.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("otherworld:is_quest_item", true);
        stack.m_41751_(nbt);
        return stack;
    }

    public static ItemStack createSolarEssence() {
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.SOLAR_ESSENCE.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("otherworld:is_quest_item", true);
        stack.m_41751_(nbt);
        return stack;
    }

    public static ItemStack createCelestialEssence() {
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.CELESTIAL_ESSENCE.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("otherworld:is_quest_item", true);
        stack.m_41751_(nbt);
        return stack;
    }

    public static ItemStack createBlightedEssence() {
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.BLIGHTED_ESSENCE.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("otherworld:is_quest_item", true);
        stack.m_41751_(nbt);
        return stack;
    }

    public static ItemStack createScorchedCore() {
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.SCORCHED_NETHER_CORE.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("otherworld:is_quest_item", true);
        stack.m_41751_(nbt);
        return stack;
    }

    public static ItemStack createVoidResonator() {
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.VOID_RESONATOR.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("otherworld:is_quest_item", true);
        stack.m_41751_(nbt);
        return stack;
    }

    private static ItemStack createLichMissive() {
        ItemStack missive = new ItemStack((ItemLike)ItemRegistry.LICH_MISSIVE.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Greetings my child;\\\n\\\nI hope you're enjoying your new capabilities.\\\n\\\nContinue to sow chaos however you can. Fear is growing, suffering abounds.\\\n\\\nAll according to plan.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"The Paladin Kaelen is a threat to our cause.\\\n\\\nThe longer he lives, espousing his virtuous nonsense, the bolder the populace becomes.\\\n\\\nHe must be dealt with. The \u00a73Eye of Ghosts\u00a7r is now linked to him - use it to track him down.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Missive");
        nbt.m_128359_("author", "???");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        missive.m_41751_(nbt);
        return missive;
    }

    private static ItemStack createKaelenJournal() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.KAELEN_JOURNAL.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"The whispers promise much. \\\n\\\nI know a trap when I see one; but still, I must respect the power of those who have taken this vow.\\\n\\\nMy presence is a threat to them, I disrupt their control. They need me gone, I can sense it. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I can not spend too much time worrying.\\\n\\\nAs soon as this horde lets up and my injuries heal, I must continue.\\\n\\\nI believe the leader of this scourge to be occasionally employing Pirates. \\\n\\\nLast I heard, \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"A somewhat notorious crew became shipwrecked in a large iceberg, and were reportedly staying there to defend their valuables, waiting for a transport.\\\n\\\nI pray I have the strength to make it there. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I tire quickly lately. The undead are incessant. \\\n\\\nPerhaps some forces can not be bested by one man.\\\n\\\nThis is the nature of power, I suppose: An individual can do everything right, and still lose. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Virtuousness does not grant invulnerability, like the stories I grew up with would have me believe.\\\n\\\nBut, my friend, if you're reading this, there is something else to know.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"An \u00a7oindividual\u00a7r can be defeated by corruption, fall to tyranny.\\\n\\\nBut for as long as we can speak with each other, even over these great distances, there is hope. \\\n\\\nNo - inevitability.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"You see, injustice \u00a7owill\u00a7r crumble. It has no inheritors, no one to care for its legacy when it is sick and dying. \\\n\\\nIt always consumes itself, in time.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"If I am not among those who witness this nightmare's end: \\\n\\\nMay at least one pick up my torch, and have enough life and strength left to see it through.\\\n\\\nThis is all it takes for tyranny to fall.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Journal");
        nbt.m_128359_("author", "Sir Kaelen");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createCorneliaLog() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.CORNELIA_LOG.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"We set sail under fair skies. Cargo well secured. The client, a Lich, was still insistent on placing his own wards, the likes of which I've never seen. Unsettling symbols...\\\n\\\nHe said it was vital, that the goods were 'fragile.' I don't like dealing with sorcerers. Something was off.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I've overheard him with his minions planning visits to the grave of some 'Old Champion', and using a Moonstone Compass to get there. \\\n\\\nI also know his laboratory is a lone spire in a vast icy field, and can be found using something called a Soul Star.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Either one of these should be a good place to look into. In time.\\\n\\\nSomething tremendously powerful is at the center of this. I need to be patient.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Waterlogged Logbook");
        nbt.m_128359_("author", "Captain Cornelia");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createLichJournal() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.LICH_JOURNAL.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"...And yet, the nature of mind is inscrutable.\\\n\\\nFools believe it requires the continuity of life.\\\n\\\nThere is more to the story.\\\n\\\nThere is much more than life. I am proof...\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"The Altar beneath grows in resonance.\\\n\\\nIts whispers have become screams. It demands to be fed.\\\n\\\nIt demands suffering.\\\n\\\nMy work must continue.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7oSubject Designation: 'Champion'\u00a7r\\\n\\\nThe old warrior was indeed a powerful soul. He succumbed to the false prophecy nicely.\\\n\\\nUnfortunately, he is still too... honorable.\\\n\\\nHe does not cling strongly enough. He will not do.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7oSubject Designation: 'King'\u00a7r\\\n\\\nA millennia old subject. He has always clung fiercely his kingdom.\\\n\\\nHis son was a powerful emotional anchor. A prime candidate for pure suffering.\\\n\\\nThis may be the perfect opportunity.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"-----\\\nI recently visited the King, using another Wayward Compass. He clings more tightly to his necklace every time I approach him.\\\n\\\nIt must have absorbed insurmountable grief.\\\n\\\nIt should be ready for the Altar, soon. \"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Lich's Notes");
        nbt.m_128359_("author", "???");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createDeadKingLament() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.DEAD_KING_LAMENT.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"The sorcerer visits more frequently lately.\\\n\\\nHe stares strangely at my necklace. He wants something I do not understand. \\\n\\\nBut this amulet is the last memory of my family. I would die to protect it.\\\nIf only I were allowed to die.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"All I can think of is Ulfric.\\\n\\\nMy son, if you can hear me somehow: Know I did it for the kingdom. Our legacy. He promised eternity, unlimited power. \\\n\\\nCan you imagine, Ulfric? No more famine, no more war, no more loss.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Please. If you can find it in your heart, forgive what I had to do.\\\n\\\nI swore it must be worth anything.\\\n\\\nBut this cold, this emptiness, this hunger. \\\n\\\n\u00a7oEndless\u00a7r hunger...\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Ages since I took the bargain. \\\n\\\nI was tricked, of course. If only I could have known earlier.\\\n\\\nWhat's here, Ulfric?\\\n\\\nWhat's left?\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I sought to preserve my kingdom forever. \\\n\\\nI should have cherished what was in front of me while it was all still alive.\\\n\\\nTo grasp for any more was truly foolish.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "King's Journal");
        nbt.m_128359_("author", "???");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createUmvuthiProphecy() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.UMVUTHI_PROPHECY.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I have seen signs sent from the heavens.\\\n\\\nA great adventurer comes to challenge me.\\\n\\\nThe sun tells me I must fight to the bitter end.\\\n\\\nThrough sacrifice may I deem them worthy.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Sol Invictus,\\\nMay thy light illuminate that which hides in the shadows. Let the time of judgment begin.\\\n\\\nYou who has come: Open the gateway to heaven, a portal of glowstone and water.\\\n\\\nProve thy worth; face the gods of the sky above, four:\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"1. In a stronghold of silver, best the winged savior of the warriors of Valhalla.\\\n\\\n\\\nMay a feather from her wing prove your divine right.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"2. In a scorched prison of gold, douse the embodiment of eternal daylight.\\\n\\\n\\\nMay the core of his fiery soul prove your raw strength.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"3. In a watchtower of shining platinum, defeat the king of the skies.\\\n\\\n\\\nMay the distillation of his celestial being prove your wisdom.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"4. In an abandoned laboratory, cut down the failed mutation born of man's hubris.\\\n\\\n\\\nMay its essence of rot prove your courage to shoulder the mistakes of the past.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Combine these essences four into one offering, to be given unto the forgotten eternal.\\\n\\\nIn a massive haven city upon the clouds, beneath where the blade of the holy radiates light unto stone, an Altar, a junction unto eldritch eyes, lies in wait.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Present the offering here and receive thy blessing.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "A Prophecy");
        nbt.m_128359_("author", "Umvuthi");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    public static ItemStack createWarlockChallenge() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.WARLOCK_CHALLENGE.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"You who meddles with the forces of life,\\\n\\\nYou toy with that which you cannot comprehend.\\\n\\\nYou know nothing of the Stone you have just found.\\\n\\\nIt belongs in worthy hands.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Find me in the Core of the World, where hellfire permeates the air.\\\n\\\nThere, the Bloody Eye will lead to me.\\\n\\\n\\\nI shall be waiting.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Challenge");
        nbt.m_128359_("author", "???");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createApexProjectBook() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.APEX_PROJECT_BOOK.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Tell me: what do you make of Necromancy?\\\n\\\nDoes it fill you with fear? Righteousness?\\\n\\\nI should warn you, reader: Only fools scorn magic they can not possibly understand.\\\n\\\n\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Yet, I confess:\\\n\\\nMy stitched abominations up to this point have been but a mockery of true power. \\\n\\\nYou see, that is precisely what has brought me here. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Here, in the core of the world, where war drums and radiating heat waves vibrate together in harmony, lie the breeding grounds for a perfect warrior.\\\n\\\nThose with raw power come to this place, to test their mettle. I have found several worthy of study.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"A demonic warrior warped and possessed by his corrupt blade, once an honored defender of a great desert kingdom. Known to some as the Decaying King.\\\n\\\nHis throne can be located with a Moonstone Compass.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"In a scorched blackstone arena, lies the trial of a living Gauntlet. \\\n\\\nThis huge cube on the lava floor can only be stumbled upon, but is hard to miss.\\\n\\\nBegin the challenge by breaking the obelisk at its center.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"A golem of living magma and fused netherite, standing eternal guard over an ancient, derelict factory. A warden of primordial creation.\\\n\\\nFind it with the Eye of Monstrous.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"There exists, too, a fiery demigod looming in this hellfire. A truly terrifying force. He is rumored to guard a stone from the core of the world.\\\n\\\nHe tests only the worthy. An Eye of Flame will lead to his domain, which requires proof of besting the other warriors. \"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "The Apex Project");
        nbt.m_128359_("author", "???");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    public static ItemStack createIgnisPhilosophy() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.IGNIS_PHILOSOPHY.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Fools attempt to avoid suffering. \\\n\\\nWeaklings speak of balance, of tempered force. \\\n\\\nCowards, all.\\\n\\\n\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Ultimate power is available to those who can withstand infinite pressure.\\\n\\\nTo truly ascend, one must be willing to sacrifice their entire being.\\\n\\\nFace fully the crushing weight of the world, and resist it with all your might.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Find that within you which can equal its tremendous gravity.\\\n\\\nLet the rest of you succumb. It is not worthy.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"The Scorched Core is the embodiment of such resistance.\\\n\\\nSoon, it can tolerate the ritual.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"If you have bested me in combat, worthy one, the Core is ready. \\\n\\\nBeneath my arena, buried in lava, lies a mysterious Altar.\\\n\\\nPlace it there, and let it be infused with the weight of one thousand suns. \"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Pledge");
        nbt.m_128359_("author", "Ignis");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    public static ItemStack createScyllaLoreBook() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.SCYLLA_LORE_BOOK.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"One would be forgiven for wondering: What could I, the Empress of the Storms, possibly want in a place so firey, so unholy? \n\nI will tell you. \n\nIt is not a story that most should be privy to. Treat the following words with caution.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Long ago on my adventures through the world, I heard rumors of a golden era when energies flowed freely throughout all realms. \n\nCreatures of all types sang together, their hums resonating in a beautiful harmony which echoed throughout the realm. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Every being lived well within their means, and cooperated with all of their neighbors. \n\nYes, even the humans, took only what they needed, giving freely. \n\nIt was some time between then and now that the world became to be infected with an idea. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"It spread spontaneously and voraciously, as ideas often do. \n\nNo retelling of the legend seems to articulate where it came from. \n\nBut one learns quickly that this is irrelevant. Ideas have their own autonomy. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"It is from this idea that the first conflicts arose. \n\nSomething began to sow within the creatures that their interests no longer aligned. \n\nThe worlds they lived were somehow separate. Paradise had fractured.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"To those of our day, this is a strange tale to imagine. It is hard to fathom any other alternative. \n\nI am not you;\n\nHow is my bliss connected at all to yours, beside however much helping you gratifies me? \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Indeed, it seems this is quite hard to argue against. \n\nIt is after the time of this great separation of interests, that the world itself began to separate. \n\nThe great and powerful leaders of each realm sealed off their entryways. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Only those willing to delve into the forbidden art of portal magic could bridge the gap.\n\nTo do so was treacherous, and scorned. \n\nIn time, too, knowledge of this magic was lost. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"The world existed in this state for millennia, possibly magnitudes longer. The scale of this time is difficult to estimate.\n\nWhat is known is that some time near the end of this knowledge becoming dust in the wind, it was recorded, once. Then it was sealed. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"An ancient civilization who worshipped knowledge and ritualized prescience, came upon a series of revelations. \n\nThey recorded these revelations in a book, in some language which at its time was completely incromprehensible. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"They said it was to be read far in the future. \nThey said that only one person would be both wise, virtuous, and powerful enough to handle its contents responsibly. \n\nThey sealed this knowledge away.\n\nAnd they vanished.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I have known this story for quite some time. \n\nBut in recent decades, I have heard a stirring.\n\nOne has been disturbing the rifts between the realms. \n\nThey know not what they tamper with. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"You. \n\nYou are the fool who has begun preemptively tearing down walls for worlds which are not ready to meet. \n\nYou act merely out of curiosity - and perhaps worse, some hidden thirst for power or achievement.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"You are not the worthy one of which the ancients spoke. \n\nYou are possessed by your own ideals. \n\nI have come here to stop you. \n\n\nIf I have failed at that task, I have one final plea: \n\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Stop now. \n\nThere are forces at play which you cannot even begin to understand. \n\n\n\n\n\n\nStill, there is something else. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I must concede the possibility that you know something I do not. \n\nAnd that I have crucial knowledge which it may be my duty to impart. \n\nIf you've bested me, perhaps it is for you to know: \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Follow the Eye of \nWrought. \n\nThe guardian there will lead you further. \n\nIt has a pierce in its armor which my companion once left. This is its only weak point. \n\nBe careful.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Buried Secrets");
        nbt.m_128359_("author", "Scylla");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createNightwardenMessage() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.NIGHTWARDEN_FAREWELL.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"If you're reading this, I am no more.\\\n\\\nAt last, I can be free.\\\n\\\nBut all this suffering I have wrought.\\\n\\\n For what?\\\n\\\nWhat purpose did it serve?\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I spent more lives than I deserved seeking meaning in her death.\\\n\\\nWho imagined this world where she was taken?\\\n\\\nAnd how cruel, that I would become possessed by the very magic which ripped her apart?\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I could easily claim there was no grand design. Only grief, and what I made of it. \\\n\\\nBut I refused to fall for the fool's panacea, the resigned acceptance that there is no reason to reality.\\\n\\\n\\\nI had to know.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"And now, as the end is finally near, it is clear:\\\n\\\n\\\nI am the old world's dying breath.\\\n\\\nThe age of magic is coming to an end.\\\n\\\nFrom its ashes rises the age of man.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"May its inhabitants not forget the magic which bore them. \\\n\\\nMay they still cherish its beauty, as we once did.\\\n\\\n\\\nThe world, for all its cruelty, all its pain, redeems itself in one swift moment:\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"The moment when it is finally witnessed by one soul.\\\n\\\nJust one moment is enough to justify it for eternity.\\\n\\\n\\\n\\\nI wonder, will it ever be truly seen?\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\\\n\\\nSmall wisps of magic will linger in the air for some time. \\\n\\\n\\\n\\\n\\\nI hope you will look for them.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Farewell");
        nbt.m_128359_("author", "???");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createWroughtnautInstructions() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.WROUGHTNAUT_INSTRUCTIONS.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Guardian Eternal.\\\n\\\nThe path must remain sealed. The knowledge within is poison.\\\n\\\nThe sleeping gods must not wake.\\\n\\\nMy watch endures.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I guard for the Nameless, in the treasure room far beneath. It pulls at the Eye of Guling.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Runic Power Core Instructions");
        nbt.m_128359_("author", "Ancient Script");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createGuardianMandate() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.GUARDIAN_MANDATE_ITEM.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Guardian Eternal.\\\n\\\nThe path must remain sealed. The knowledge within is poison.\\\n\\\nThe sleeping gods must not wake.\\\n\\\nMy watch endures.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I guard the Witherite Machine, in a factory lost to time. It pulls at the Eye of Mech.\\\n\\\nIt rests until it holds a Wither Star. \"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "WARNING");
        nbt.m_128359_("author", "???");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createHarbingerMessage() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.HARBINGER_MESSAGE.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Guardian Eternal.\\\n\\\nThe path must remain sealed. The knowledge within is poison.\\\n\\\nThe sleeping gods must not wake.\\\n\\\nMy watch endures.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"I guard the Dinosaur King, in a pyramid long sealed. It pulls at the Eye of Desert.\\\n\\\nIt rests until reunited with its Amulet.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "WARNING");
        nbt.m_128359_("author", "???");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    public static ItemStack createNexusBook() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.NEXUS_BOOK.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7kLet any who gaze upon this book witness and understand its contents, despite all culture, language, or creed\u00a7r\\\n\\\n\u00a7kWhispers of the Nexus\u00a7r\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7lThe First Revelation:\\\n\u00a7lOf Stones and Sovereignty\u00a7r\\\nIn the time before the Sundering, when the cosmos drew its first breath and the void between stars sang with possibility, six essences crystallized from the primordial chaos.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7lDeath\u00a7r, the Silent Sovereign, keeper of endings and beginnings anew. Three shall claim it first among the six, for in understanding cessation comes the wisdom to proceed.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7lLife\u00a7r, the Verdant Pulse, from which all growth and renewal springs eternal. Three shall bind it second, drawn by the promise of restoration.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7lEarth\u00a7r, the Foundation Unbroken, upon which all existence finds its footing. Three shall seize it third, for they who command the ground beneath command destiny itself.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7lFire\u00a7r, the Consuming Ambition, shall call to those who seek to forge reality anew.\\\n\\\nBy now, the pyromancers probe the boundaries of creation, sensing the heat that lies beyond mortal flame.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7lIce\u00a7r, the Crystalline Stasis, beckons those who would preserve and suspend the flow of time itself. \\\n\\\nThe frost-weavers of distant realms already feel its pull, their experiments growing bolder with each passing season.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7lLightning\u00a7r, the Savage Illumination, chooses only those swift enough to grasp enlightenment in its briefest flash. \\\n\\\nStorm-callers gather in their towers, sensing the true tempest that awaits beyond mere weather.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7lThe Second Revelation:\u00a7r\\\n\u00a7lThe Hidden Stronghold\u00a7r\\\nWhen the world is abound in turmoil, when chaos threatens to unmake all that is and was and shall be, then shall an even more ancient Stronghold reveal itself. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Deep beneath the world it slumbers, where sunlight has never dared tread\\\n\\\nBut know this: It welcomes not the unprepared. Its passages shift like living things, its guardians remember the first darkness, its very air rejects those who lack the right. \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7lThe Third Revelation: \\\n\u00a7lThe Compass of Seeking\u00a7r\\\nThe way to this Stronghold cannot be found by any traditional means. \\\n\\\nOnly through the Void-Attuned Compass may one pierce the veils that hide it.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Yet the creation of such an instrument requires a component most rare: \\\n\\\nSeek ye the Sunken City, where spires of madness pierce the abyssal depths. \\\n\\\nThere dwells That Which Should Not Be - \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"A creature of such magnitude that continents shift in its slumber. \\\n\\\nFrom its essence comes the Resonator, a fragment of otherness that bridges the gap between what is real and what merely might be.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"The beast's many eyes see through dimensions, its tentacles taste the fabric of reality itself.\\\n\\\nTo face it is to court madness. But it remains the only path. It hums with the frequencies emitted by the Nexus. Frequencies mortal ears can not perceive.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7lTh\u00a7ke\u00a7r \u00a7lFinal Whisp\u00a7k\u00a7r\u00a7lr\\\n\\\nWhen six becom\u00a7ke\u00a7r one in the chamber bel\u00a7ko\u00a7rw, When chaos-spawn gather \u00a7ka\u00a7rnd real\u00a7ki\u00a7rty bends,\\\n\\\nWhen the Void-touched rise and the anci\u00a7ke\u00a7rnt ones stir, Then shall the Nexus rem\u00a7ke\u00a7rmber its purpose.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"The Stones are not prizes to b\u00a7ke\u00a7r hoarded, seek\u00a7ke\u00a7rr. \\\n\\\nThey are respons\u00a7ki\u00a7rbilities. Burdens that grow h\u00a7ke\u00a7ravier with each passing eon. \\\n\\\nThose who would claim them must ask: \"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"When th\u00a7ke\u00a7r final hour arrives, \\\n\\\nWhen all paths converge, \\\n\\\nWill you be ready to face what\u00a7ke\u00a7rver is on the oth\u00a7ke\u00a7rr side?\\\n\\\nThe choice, as always, remains y\u00a7kou\u00a7rrs.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Yet know that we who came before, \\\n\\\nW\u00a7ke\u00a7r who carved these words into the bones of eternity itself, \\\n\\\nWe too faced th\u00a7ki\u00a7rs choice.\\\n\\\nAnd we are no more.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Whispers of the Nexus");
        nbt.m_128359_("author", "The Lost Chronicler");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createFireStoneLoreBook() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.FIRE_STONE_LORE_BOOK.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Entry 1:\\\n\\\nThe heart resists common flame - even lava only tempers it.\\\n\\\nThe legends spoke of primordial fire, born of ancient range. Not just any flame will suffice.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Entry 2: I screamed in fury at my lack of progress, and the heart resonated in kind.\\\n\\\nPerhaps a chaotic enough spell could awaken it. I would need to gather my strength.\\\n\\\nOr, somehow... the pure breath of the original pyromancers? How would I capture one?\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Fire Research Notes");
        nbt.m_128359_("author", "The Pyromancer");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createIceStoneLoreBook() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.ICE_STONE_LORE_BOOK.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Experiment Log: Altitude readings stable above 192. Subject: Frozen Heart.\\\n\\\nHypothesis: Requires extreme, natural cold. Initial tests on packed ice failed.\\\n\\\nTrying Blue Ice substrate... the resonance is stronger.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Night cycle seems critical. The heart remains inert during the day.\\\n\\\nPlacing it on the Blue Ice spire tonight... there's a faint hum now. The air grows colder.\\\n\\\nSomething seemed to happen, but a passerby triggered\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"my area ward, and the experiment had to be aborted. \\\n\\\nIt needs more time, undisturbed, under the stars. \\\n\\\nGetting a frost dragon to breathe on it directly might also work. Far too dangerous.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Ice Research Notes");
        nbt.m_128359_("author", "The Cryomancer");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createLightningStoneLoreBook() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.LIGHTNING_STONE_LORE_BOOK.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Initial Thoughts:\\\n\\nThe heart obtained from the beast seems to hum during thunderstorms, as if something within it craves to be reunited with the sky's fury.\\\n\\\n\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Entry Two:\\\n\\\nI attempted to strike the heart with lightning magics, but nothing I could produce seemed to have any effect. \\\n\\\nIt's likely no human's production lightning could have any effect; it requires a more powerful source.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Entry Three:\\\n\\\nAttempting to harness the power of a lightning drake seems far too risky. \\\n\\\nI have begun to construct the apparatus to direct lightning directly onto the stone. Now, to await a fierce enough storm.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Lightning Research Notes");
        nbt.m_128359_("author", "The Archevoker");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createEnderKingDecree() {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.ENDER_KING_DECREE.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"[Translated]: The Dragon is Lord of the Sky. I am Lord of the Land and its People.\\\n\\\nIntruders disrupt the pattern. They gaze too long. They take what is not theirs.\\\n\\\nMaintain the silence. Preserve the void.\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "End Stone Tablet");
        nbt.m_128359_("author", "Ender King Scribe");
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    private static ItemStack createDoppelgangerReflection(LivingEntity entity) {
        ItemStack book = new ItemStack((ItemLike)ItemRegistry.DOPPELGANGER_REFLECTION.get());
        CompoundTag nbt = new CompoundTag();
        ListTag pages = new ListTag();
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Anger is your truest friend.\\\n\\\nIt stops you from being complacent.\\\n\\\nIt shows you where there is failure or injustice.\\\n\\\nIt protects you when you need it most.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Those who linger for too long,\\\nTheir anger eventually grows into hate.\\\nHate can consume everything you are.\\\n\\\nBut anger is freeing. Anger is redemptive.\\\nExpress anger, and you manifest motion.\\\n\\\nAnger can save you.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Anger in the past was not a mistake.\\\n\\\nIt was not a weakness; not a failure.\\\n\\\nNor was it melodramatic.\"}"));
        pages.add((Object)StringTag.m_129297_((String)"{\"text\":\"Do not forget your anger.\\\n\\\nThere were moments of you that needed it.\\\nDo they not deserve respect?\\\n\\\nHow would they feel, seeing you now?\"}"));
        nbt.m_128365_("pages", (Tag)pages);
        nbt.m_128359_("title", "Letter to Self");
        Component customName = entity.m_7770_();
        String authorName = customName != null ? customName.getString() : "Unknown";
        nbt.m_128359_("author", authorName);
        nbt.m_128379_("resolved", false);
        nbt.m_128379_("otherworld:is_quest_item", true);
        book.m_41751_(nbt);
        return book;
    }

    @FunctionalInterface
    private static interface BossDropConsumer {
        public void accept(LivingEntity var1, ServerLevel var2);
    }
}

