/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.event;

import dev.muon.otherworld.Otherworld;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="otherworld")
public class QuestItemTaggingEvents {
    private static final String QUEST_ITEM_TAG = "otherworld:is_quest_item";
    private static final ResourceLocation FIRE_HEART_ID = new ResourceLocation("iceandfire", "fire_dragon_heart");
    private static final ResourceLocation ICE_HEART_ID = new ResourceLocation("iceandfire", "ice_dragon_heart");
    private static final ResourceLocation LIGHTNING_HEART_ID = new ResourceLocation("iceandfire", "lightning_dragon_heart");
    private static final ResourceLocation FIRE_DRAGON_ID = new ResourceLocation("iceandfire", "fire_dragon");
    private static final ResourceLocation ICE_DRAGON_ID = new ResourceLocation("iceandfire", "ice_dragon");
    private static final ResourceLocation LIGHTNING_DRAGON_ID = new ResourceLocation("iceandfire", "lightning_dragon");

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity killedEntity = event.getEntity();
        ResourceLocation killedEntityType = ForgeRegistries.ENTITY_TYPES.getKey((Object)killedEntity.m_6095_());
        if (killedEntityType == null) {
            return;
        }
        ResourceLocation targetHeartId = null;
        if (killedEntityType.equals((Object)FIRE_DRAGON_ID)) {
            targetHeartId = FIRE_HEART_ID;
        } else if (killedEntityType.equals((Object)ICE_DRAGON_ID)) {
            targetHeartId = ICE_HEART_ID;
        } else if (killedEntityType.equals((Object)LIGHTNING_DRAGON_ID)) {
            targetHeartId = LIGHTNING_HEART_ID;
        }
        if (targetHeartId != null) {
            QuestItemTaggingEvents.tagQuestItemInDrops(event.getDrops(), targetHeartId);
        }
    }

    private static void tagQuestItemInDrops(Collection<ItemEntity> drops, ResourceLocation itemToTag) {
        for (ItemEntity itemEntity : drops) {
            ItemStack stack = itemEntity.m_32055_();
            if (stack.m_41619_() || !ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).equals((Object)itemToTag)) continue;
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128379_(QUEST_ITEM_TAG, true);
            stack.m_41751_(nbt);
            Otherworld.LOGGER.debug("Tagged item {} as quest item.", (Object)itemToTag);
            break;
        }
    }
}

