/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.event;

import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.item.ElementalStoneItem;
import dev.muon.otherworld.item.NecklaceOfSorrowItem;
import dev.muon.otherworld.item.ObsidianMirrorItem;
import dev.muon.otherworld.item.QuestComponentItem;
import dev.muon.otherworld.item.QuestJournalItem;
import dev.muon.otherworld.item.VoidCompassItem;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otherworld")
public class QuestItemEvents {
    private static final String QUEST_ITEM_TAG = "otherworld:is_quest_item";

    public static boolean isQuestItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof ElementalStoneItem || item instanceof ObsidianMirrorItem || item instanceof NecklaceOfSorrowItem || item instanceof QuestJournalItem || item instanceof QuestComponentItem || item instanceof VoidCompassItem) {
            return true;
        }
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag != null && tag.m_128471_(QUEST_ITEM_TAG);
        }
        return false;
    }

    @SubscribeEvent
    public static void addItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (QuestItemEvents.isQuestItem(stack)) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.otherworld.quest_item").m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Inventory originalInventory = event.getOriginal().m_150109_();
        Inventory newInventory = event.getEntity().m_150109_();
        for (int i = 0; i < originalInventory.m_6643_(); ++i) {
            ItemStack stack = originalInventory.m_8020_(i);
            if (!QuestItemEvents.isQuestItem(stack)) continue;
            if (newInventory.m_36054_(stack.m_41777_())) {
                originalInventory.m_6836_(i, ItemStack.f_41583_);
                continue;
            }
            Otherworld.LOGGER.warn("Could not restore quest item '{}' for player {} after death due to full inventory.", (Object)stack.m_41611_().getString(), (Object)event.getEntity().m_7755_().getString());
        }
    }
}

