/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.event;

import com.github.alexthe666.iceandfire.api.event.DragonFireDamageWorldEvent;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import dev.muon.otherworld.block.BlockRegistry;
import dev.muon.otherworld.item.ItemRegistry;
import dev.muon.otherworld.network.HeartTransformPacketHandler;
import dev.muon.otherworld.sound.SoundRegistry;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.events.SpellOnCastEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="otherworld")
public class HeartTransformEvents {
    private static final ResourceLocation FIRE_DRAGON_HEART_ID = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"fire_dragon_heart");
    private static final ResourceLocation ICE_DRAGON_HEART_ID = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"ice_dragon_heart");
    private static final ResourceLocation LIGHTNING_DRAGON_HEART_ID = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"lightning_dragon_heart");
    private static final double DRAGON_BREATH_RADIUS = 5.0;
    private static final double CONE_RANGE = 10.0;
    private static final double CONE_ANGLE_COS = Math.cos(Math.toRadians(30.0));
    private static final String TRANSFORM_TAG = "otherworld:transforming";
    private static final String TRANSFORM_TYPE_TAG = "otherworld:transform_type";
    private static final String TRANSFORM_TIMER_TAG = "otherworld:transform_timer";
    private static final int TRANSFORM_DURATION = 200;
    private static final Set<UUID> transformingItemIds = Collections.newSetFromMap(new ConcurrentHashMap());

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<UUID> iterator = transformingItemIds.iterator();
        while (iterator.hasNext()) {
            UUID itemId = iterator.next();
            boolean found = false;
            for (ServerLevel level : event.getServer().m_129785_()) {
                Entity entity = level.m_8791_(itemId);
                if (!(entity instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity;
                HeartTransformEvents.tickTransformingItem(itemEntity, level);
                found = true;
                break;
            }
            if (found) continue;
            iterator.remove();
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        block0: for (UUID itemId : transformingItemIds) {
            for (ServerLevel level : event.getServer().m_129785_()) {
                Entity entity = level.m_8791_(itemId);
                if (!(entity instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity;
                HeartTransformEvents.clearTransformState(itemEntity);
                continue block0;
            }
        }
        transformingItemIds.clear();
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        CompoundTag data;
        if (event.getLevel().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && (data = (itemEntity = (ItemEntity)entity).getPersistentData()).m_128471_(TRANSFORM_TAG)) {
            HeartTransformEvents.clearTransformState(itemEntity);
        }
    }

    private static void clearTransformState(ItemEntity itemEntity) {
        CompoundTag data = itemEntity.getPersistentData();
        data.m_128473_(TRANSFORM_TAG);
        data.m_128473_(TRANSFORM_TYPE_TAG);
        data.m_128473_(TRANSFORM_TIMER_TAG);
        itemEntity.m_20242_(false);
        itemEntity.m_32010_(10);
    }

    private static void tickTransformingItem(ItemEntity itemEntity, ServerLevel level) {
        CompoundTag data = itemEntity.getPersistentData();
        int timer = data.m_128451_(TRANSFORM_TIMER_TAG);
        String transformType = data.m_128461_(TRANSFORM_TYPE_TAG);
        BlockPos pos = itemEntity.m_20183_();
        itemEntity.m_32010_(20);
        if (timer == 199) {
            level.m_5594_(null, pos, (SoundEvent)SoundRegistry.INFUSION_START.get(), SoundSource.BLOCKS, 0.3f, 0.9f);
            level.m_5594_(null, pos, (SoundEvent)SoundRegistry.CHANNELED_WAIL.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
        }
        int finalSoundTick = 60;
        float sporadicVolumeMin = 0.15f;
        float sporadicVolumeMax = 0.2f;
        if (timer == 60) {
            level.m_5594_(null, pos, (SoundEvent)SoundRegistry.INFUSION_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (timer > 60 && timer < 200 && level.f_46441_.m_188503_(20) == 0) {
            float randomVolume = 0.15f + level.f_46441_.m_188501_() * 0.049999997f;
            float randomPitch = 0.7f + level.f_46441_.m_188501_() * 0.2f;
            level.m_5594_(null, pos, (SoundEvent)SoundRegistry.INFUSION_START.get(), SoundSource.BLOCKS, randomVolume, randomPitch);
        }
        data.m_128405_(TRANSFORM_TIMER_TAG, --timer);
        if (timer <= 0) {
            HeartTransformEvents.completeTransformation(itemEntity, level, transformType);
        }
    }

    private static void completeTransformation(ItemEntity itemEntity, ServerLevel level, String type) {
        RegistryObject<Item> resultItem;
        ItemStack stack = itemEntity.m_32055_();
        int count = stack.m_41613_();
        double x = itemEntity.m_20185_();
        double y = itemEntity.m_20186_();
        double z = itemEntity.m_20189_();
        int entityId = itemEntity.m_19879_();
        transformingItemIds.remove(itemEntity.m_20148_());
        HeartTransformPacketHandler.sendStopTransform(level, entityId, type, x, y, z);
        switch (type) {
            case "fire": {
                RegistryObject<Item> registryObject = ItemRegistry.FIRE_STONE;
                break;
            }
            case "ice": {
                RegistryObject<Item> registryObject = ItemRegistry.ICE_STONE;
                break;
            }
            case "lightning": {
                RegistryObject<Item> registryObject = ItemRegistry.LIGHTNING_STONE;
                break;
            }
            default: {
                RegistryObject<Item> registryObject = resultItem = null;
            }
        }
        if (resultItem == null) {
            return;
        }
        ItemStack resultStones = new ItemStack((ItemLike)resultItem.get(), count);
        ItemEntity newItem = new ItemEntity((Level)level, x, y, z, resultStones);
        newItem.m_20256_(Vec3.f_82478_);
        newItem.m_32010_(10);
        level.m_7967_((Entity)newItem);
        BlockPos pos = itemEntity.m_20183_();
        level.m_5594_(null, pos, SoundEvents.f_11860_, SoundSource.BLOCKS, 1.2f, 1.0f);
        level.m_5594_(null, pos, SoundEvents.f_11738_, SoundSource.BLOCKS, 0.5f, 1.0f);
        itemEntity.m_146870_();
    }

    private static void startTransformation(ItemEntity itemEntity, String type) {
        CompoundTag data = itemEntity.getPersistentData();
        if (data.m_128471_(TRANSFORM_TAG)) {
            return;
        }
        data.m_128379_(TRANSFORM_TAG, true);
        data.m_128359_(TRANSFORM_TYPE_TAG, type);
        data.m_128405_(TRANSFORM_TIMER_TAG, 200);
        transformingItemIds.add(itemEntity.m_20148_());
        itemEntity.m_32010_(220);
        itemEntity.m_149678_();
        itemEntity.m_20242_(true);
        itemEntity.m_20256_(Vec3.f_82478_);
        Level level = itemEntity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            HeartTransformPacketHandler.sendStartTransform(serverLevel, itemEntity.m_19879_(), type, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_());
        }
    }

    public static void triggerTransformation(ItemEntity itemEntity, String type) {
        ResourceLocation expectedHeartId;
        if (itemEntity.m_9236_().f_46443_) {
            return;
        }
        if (itemEntity.getPersistentData().m_128471_(TRANSFORM_TAG)) {
            return;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)itemEntity.m_32055_().m_41720_());
        switch (type) {
            case "fire": {
                ResourceLocation resourceLocation = FIRE_DRAGON_HEART_ID;
                break;
            }
            case "ice": {
                ResourceLocation resourceLocation = ICE_DRAGON_HEART_ID;
                break;
            }
            case "lightning": {
                ResourceLocation resourceLocation = LIGHTNING_DRAGON_HEART_ID;
                break;
            }
            default: {
                ResourceLocation resourceLocation = expectedHeartId = null;
            }
        }
        if (expectedHeartId == null || !expectedHeartId.equals((Object)itemId)) {
            return;
        }
        HeartTransformEvents.startTransformation(itemEntity, type);
    }

    @SubscribeEvent
    public static void onSpellCast(SpellOnCastEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        SchoolType schoolType = event.getSchoolType();
        if (!Objects.equals(schoolType.getId(), IronsSpellbooks.id((String)"fire"))) {
            return;
        }
        SpellData castingSpell = MagicData.getPlayerMagicData((LivingEntity)player).getCastingSpell();
        SpellRarity spellRarity = castingSpell.getRarity();
        if (spellRarity.compareRarity(SpellRarity.LEGENDARY) < 0) {
            return;
        }
        Level level = player.m_9236_();
        Vec3 eyePos = player.m_146892_();
        Vec3 lookDir = player.m_20154_().m_82541_();
        AABB searchBox = player.m_20191_().m_82400_(10.0);
        List nearbyItems = level.m_45976_(ItemEntity.class, searchBox);
        for (ItemEntity itemEntity : nearbyItems) {
            Vec3 toItemNormalized;
            double dot;
            Vec3 toItem;
            double distance;
            ItemStack stack = itemEntity.m_32055_();
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            if (!FIRE_DRAGON_HEART_ID.equals((Object)itemId) || itemEntity.getPersistentData().m_128471_(TRANSFORM_TAG) || (distance = (toItem = itemEntity.m_20182_().m_82520_(0.0, (double)(itemEntity.m_20206_() / 2.0f), 0.0).m_82546_(eyePos)).m_82553_()) > 10.0 || distance < 0.5 || !((dot = lookDir.m_82526_(toItemNormalized = toItem.m_82541_())) >= CONE_ANGLE_COS)) continue;
            HeartTransformEvents.startTransformation(itemEntity, "fire");
        }
    }

    @SubscribeEvent
    public static void onDragonFireDamageWorld(DragonFireDamageWorldEvent event) {
        String transformType;
        ResourceLocation targetHeartId;
        EntityDragonBase dragon = event.getDragon();
        if (dragon == null) {
            return;
        }
        Level level = dragon.m_9236_();
        if (level.f_46443_) {
            return;
        }
        BlockPos center = BlockPos.m_274561_((double)event.getTargetX(), (double)event.getTargetY(), (double)event.getTargetZ());
        if (dragon.dragonType == DragonType.FIRE) {
            targetHeartId = FIRE_DRAGON_HEART_ID;
            transformType = "fire";
        } else if (dragon.dragonType == DragonType.ICE) {
            targetHeartId = ICE_DRAGON_HEART_ID;
            transformType = "ice";
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            targetHeartId = LIGHTNING_DRAGON_HEART_ID;
            transformType = "lightning";
        } else {
            return;
        }
        AABB searchBox = new AABB(center).m_82400_(5.0);
        List nearbyItems = level.m_45976_(ItemEntity.class, searchBox);
        for (ItemEntity itemEntity : nearbyItems) {
            ItemStack stack = itemEntity.m_32055_();
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            if (!targetHeartId.equals((Object)itemId) || itemEntity.getPersistentData().m_128471_(TRANSFORM_TAG)) continue;
            HeartTransformEvents.startTransformation(itemEntity, transformType);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlockPlaceIceHeart(PlayerInteractEvent.RightClickBlock event) {
        BlockPos placePos;
        Player player = event.getEntity();
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.m_21120_(hand);
        BlockPos pos = event.getPos();
        BlockState clickedState = level.m_8055_(pos);
        if (ForgeRegistries.ITEMS.getKey((Object)heldItem.m_41720_()).equals((Object)ICE_DRAGON_HEART_ID) && clickedState.m_60713_(Blocks.f_50568_) && level.m_46859_(placePos = pos.m_7494_())) {
            if (!level.f_46443_) {
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                level.m_7731_(placePos, ((Block)BlockRegistry.PLACED_ICE_HEART.get()).m_49966_(), 3);
                level.m_5594_(null, placePos, SoundEvents.f_12015_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5594_(null, placePos, SoundEvents.f_11983_, SoundSource.BLOCKS, 0.5f, 1.5f);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlockPlaceLightningHeart(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.m_21120_(hand);
        BlockPos pos = event.getPos();
        BlockState clickedState = level.m_8055_(pos);
        if (ForgeRegistries.ITEMS.getKey((Object)heldItem.m_41720_()).equals((Object)LIGHTNING_DRAGON_HEART_ID) && clickedState.m_60713_(Blocks.f_152587_)) {
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            if (!level.f_46443_) {
                Vec3 spawnPos = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, 0.75, 0.0);
                ItemEntity heartItem = new ItemEntity(level, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(LIGHTNING_DRAGON_HEART_ID)));
                heartItem.m_20256_(Vec3.f_82478_);
                heartItem.m_20242_(false);
                heartItem.f_19794_ = true;
                heartItem.m_32010_(20);
                heartItem.m_149678_();
                level.m_7967_((Entity)heartItem);
            }
            level.m_5594_(null, pos, SoundEvents.f_12015_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5594_(null, pos, SoundEvents.f_11737_, SoundSource.BLOCKS, 0.3f, 1.5f);
            event.setCanceled(true);
        }
    }
}

