/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.event;

import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.dimension.DimensionRegistry;
import dev.muon.otherworld.world.saved_data.NexusHubPlacementState;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandlers {
    private static final Set<UUID> PLAYERS_IN_NARRATION = new HashSet<UUID>();
    private static final UUID NARRATION_THERMAL_RESISTANCE_ID = UUID.fromString("7a8f9d3e-1b2c-4d5e-6f7a-8b9c0d1e2f3a");
    private static final ResourceLocation THERMAL_RESISTANCE_ATTRIBUTE = new ResourceLocation("legendarysurvivaloverhaul", "thermal_resistance");
    private static final ResourceLocation NEXUS_HUB_STRUCTURE_ID = new ResourceLocation("otherworld", "nexus_hub");

    public static void addPlayerToNarration(ServerPlayer player) {
        AttributeInstance attributeInstance;
        UUID playerUUID = player.m_20148_();
        PLAYERS_IN_NARRATION.add(playerUUID);
        Attribute thermalResistance = (Attribute)BuiltInRegistries.f_256951_.m_7745_(THERMAL_RESISTANCE_ATTRIBUTE);
        if (thermalResistance != null && (attributeInstance = player.m_21051_(thermalResistance)) != null) {
            AttributeModifier modifier = new AttributeModifier(NARRATION_THERMAL_RESISTANCE_ID, "Boss narration thermal resistance", 100.0, AttributeModifier.Operation.ADDITION);
            if (attributeInstance.m_22111_(NARRATION_THERMAL_RESISTANCE_ID) != null) {
                attributeInstance.m_22120_(NARRATION_THERMAL_RESISTANCE_ID);
            }
            attributeInstance.m_22118_(modifier);
            Otherworld.LOGGER.debug("Applied thermal resistance to player {} during narration", (Object)player.m_7755_().getString());
        }
    }

    public static void removePlayerFromNarration(UUID playerUUID) {
        PLAYERS_IN_NARRATION.remove(playerUUID);
    }

    public static void removePlayerFromNarration(ServerPlayer player) {
        AttributeInstance attributeInstance;
        UUID playerUUID = player.m_20148_();
        PLAYERS_IN_NARRATION.remove(playerUUID);
        Attribute thermalResistance = (Attribute)BuiltInRegistries.f_256951_.m_7745_(THERMAL_RESISTANCE_ATTRIBUTE);
        if (thermalResistance != null && (attributeInstance = player.m_21051_(thermalResistance)) != null && attributeInstance.m_22111_(NARRATION_THERMAL_RESISTANCE_ID) != null) {
            attributeInstance.m_22120_(NARRATION_THERMAL_RESISTANCE_ID);
            Otherworld.LOGGER.debug("Removed thermal resistance from player {} after narration", (Object)player.m_7755_().getString());
        }
    }

    public static boolean isPlayerInNarration(UUID playerUUID) {
        return PLAYERS_IN_NARRATION.contains(playerUUID);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        ServerPlayer serverPlayer;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && ForgeEventHandlers.isPlayerInNarration((serverPlayer = (ServerPlayer)livingEntity).m_20148_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        ServerLevel nexusLevel = server.m_129880_(DimensionRegistry.ELEMENTAL_NEXUS);
        if (nexusLevel == null) {
            Otherworld.LOGGER.error("Elemental Nexus dimension not found, cannot perform initial setup.");
            return;
        }
        NexusHubPlacementState placementState = NexusHubPlacementState.get(nexusLevel);
        if (placementState.isPlaced()) {
            Otherworld.LOGGER.info("Initial Nexus Hub setup already performed (SavedData flag is set). Skipping.");
            return;
        }
        Otherworld.LOGGER.info("Initial Nexus Hub setup not yet performed. Proceeding with structure and knight placement.");
        BlockPos structurePlacementPos = new BlockPos(0, 64, 0);
        BlockPos knightSpawnPos = new BlockPos(50, 66, 52);
        try {
            StructureTemplate template = (StructureTemplate)nexusLevel.m_215082_().m_230407_(NEXUS_HUB_STRUCTURE_ID).orElseThrow(() -> new IllegalStateException("Could not find structure template: " + String.valueOf(NEXUS_HUB_STRUCTURE_ID)));
            StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_74392_(true);
            Otherworld.LOGGER.info("Placing Nexus Hub structure at {} in dimension {}", (Object)structurePlacementPos, (Object)DimensionRegistry.ELEMENTAL_NEXUS.m_135782_());
            boolean success = template.m_230328_((ServerLevelAccessor)nexusLevel, structurePlacementPos, structurePlacementPos, placeSettings, nexusLevel.f_46441_, 2);
            if (success) {
                Otherworld.LOGGER.info("Successfully placed Nexus Hub structure at {}", (Object)structurePlacementPos);
                Optional knightTypeOpt = EntityType.m_20632_((String)"soulsweapons:returning_knight");
                if (knightTypeOpt.isPresent()) {
                    EntityType knightType = (EntityType)knightTypeOpt.get();
                    knightType.m_262496_(nexusLevel, knightSpawnPos, MobSpawnType.STRUCTURE);
                    Otherworld.LOGGER.info("Successfully spawned Returning Knight at {}", (Object)knightSpawnPos);
                } else {
                    Otherworld.LOGGER.error("EntityType 'soulsweapons:returning_knight' not found! Cannot spawn initial knight.");
                }
                placementState.markAsPlaced();
                Otherworld.LOGGER.info("Initial Nexus Hub setup complete. Marked as placed in SavedData.");
            } else {
                Otherworld.LOGGER.error("Failed to place Nexus Hub structure at {}. Initial setup will be re-attempted on next server start.", (Object)structurePlacementPos);
            }
        }
        catch (Exception e) {
            Otherworld.LOGGER.error("Exception during initial Nexus Hub setup: ", (Throwable)e);
        }
    }
}

