/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.event;

import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.block.BlockRegistry;
import dev.muon.otherworld.block.entity.NexusAltarBlockEntity;
import dev.muon.otherworld.dimension.DimensionRegistry;
import dev.muon.otherworld.sound.SoundPacketHandler;
import dev.muon.otherworld.world.saved_data.ActiveRitualBossTracker;
import dev.muon.otherworld.world.saved_data.PortalFrameState;
import java.util.List;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="otherworld", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BossDeathEvents {
    private static final ResourceLocation MALEDICTUS_ID = new ResourceLocation("legendary_monsters", "ancient_guardian");

    @SubscribeEvent
    public static void onBossDeath(LivingDeathEvent event) {
        Level level;
        LivingEntity deadEntity = event.getEntity();
        if (deadEntity.m_9236_().m_5776_() || !((level = deadEntity.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.m_46472_() != DimensionRegistry.ELEMENTAL_NEXUS) {
            ResourceLocation bossId = ForgeRegistries.ENTITY_TYPES.getKey((Object)deadEntity.m_6095_());
            if (bossId != null && bossId.equals((Object)MALEDICTUS_ID)) {
                BossDeathEvents.handleMaledictusDeath(serverLevel, deadEntity.m_20148_());
            }
            return;
        }
        UUID deadEntityUUID = deadEntity.m_20148_();
        ActiveRitualBossTracker tracker = ActiveRitualBossTracker.get(serverLevel);
        if (tracker.isBossTracked(deadEntityUUID)) {
            Otherworld.LOGGER.debug("Tracked ritual boss {} died in Elemental Nexus.", (Object)deadEntityUUID);
            BlockPos minPortalCorner = new BlockPos(48, 72, 2);
            BlockPos maxPortalCorner = new BlockPos(52, 84, 2);
            Otherworld.LOGGER.debug("Replacing bedrock with Nexus Exit Portals in area {} to {}.", (Object)minPortalCorner, (Object)maxPortalCorner);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPortalCorner, (BlockPos)maxPortalCorner)) {
                if (!serverLevel.m_8055_(pos).m_60713_(Blocks.f_50752_) && !serverLevel.m_8055_(pos).m_60713_(Blocks.f_50016_)) continue;
                serverLevel.m_7731_(pos, ((Block)BlockRegistry.NEXUS_EXIT_PORTAL.get()).m_49966_(), 3);
            }
            ResourceLocation dragonGrowlRL = ForgeRegistries.SOUND_EVENTS.getKey((Object)SoundEvents.f_11894_);
            ResourceLocation portalSpawnRL = ForgeRegistries.SOUND_EVENTS.getKey((Object)SoundEvents.f_11860_);
            ResourceLocation musicRL = null;
            if (SoundEvents.f_12082_.m_203633_()) {
                SoundEvents.f_12082_.m_203334_();
                musicRL = ForgeRegistries.SOUND_EVENTS.getKey((Object)((SoundEvent)SoundEvents.f_12082_.m_203334_()));
            }
            if (dragonGrowlRL != null) {
                SoundPacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SoundPacketHandler.PlayGlobalSoundPacket(dragonGrowlRL, 1.5f, 0.9f));
            }
            if (portalSpawnRL != null) {
                SoundPacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SoundPacketHandler.PlayGlobalSoundPacket(portalSpawnRL, 1.0f, 1.0f));
            }
            ClientboundStopSoundPacket stopMusicPacket = new ClientboundStopSoundPacket(null, SoundSource.MUSIC);
            boolean musicPacketSent = false;
            for (ServerPlayer playerInDimension : serverLevel.m_6907_()) {
                if (playerInDimension.m_9236_().m_46472_() != DimensionRegistry.ELEMENTAL_NEXUS) continue;
                playerInDimension.f_8906_.m_9829_((Packet)stopMusicPacket);
            }
            if (musicRL == null) {
                Otherworld.LOGGER.error("Failed to get ResourceLocation for dimension music (MusicRL is null).");
            }
            ResourceLocation advancementId = new ResourceLocation("otherworld", "story/dragons_and_deities");
            Advancement advancement = serverLevel.m_7654_().m_129889_().m_136041_(advancementId);
            if (advancement != null) {
                for (ServerPlayer playerInDimension : serverLevel.m_6907_()) {
                    if (playerInDimension.m_9236_().m_46472_() != DimensionRegistry.ELEMENTAL_NEXUS || playerInDimension.m_8960_().m_135996_(advancement).m_8193_()) continue;
                    playerInDimension.m_8960_().m_135988_(advancement, "unlocked");
                    Otherworld.LOGGER.debug("Granted advancement '{}' to player {}.", (Object)advancementId, (Object)playerInDimension.m_7755_().getString());
                }
            } else {
                Otherworld.LOGGER.warn("Could not find advancement: {}", (Object)advancementId);
            }
            for (BlockPos altarPos : NexusAltarBlockEntity.PEDESTAL_LOCATIONS.values()) {
                NexusAltarBlockEntity altarEntity;
                BlockEntity be;
                if (!serverLevel.m_46749_(altarPos) || !((be = serverLevel.m_7702_(altarPos)) instanceof NexusAltarBlockEntity) || !deadEntityUUID.equals((altarEntity = (NexusAltarBlockEntity)be).getSpawnedBossUUID())) continue;
                altarEntity.setRitualBossDefeatedAndUnlock();
            }
            tracker.removeTrackedBoss(deadEntityUUID);
        }
    }

    private static void handleMaledictusDeath(ServerLevel level, UUID bossUUID) {
        PortalFrameState state = PortalFrameState.get(level);
        List<PortalFrameState.FrameData> frameDataList = state.getFrameData(bossUUID);
        if (frameDataList != null && !frameDataList.isEmpty()) {
            for (PortalFrameState.FrameData frameData : frameDataList) {
                level.m_7731_(frameData.pos, frameData.blockState, 2);
            }
            BlockPos firstPos = frameDataList.get((int)0).pos;
            BlockPattern.BlockPatternMatch patternMatch = EndPortalFrameBlock.m_53077_().m_61184_((LevelReader)level, firstPos);
            if (patternMatch != null) {
                BlockPos pos;
                int j;
                int i;
                BlockPos portalPos = patternMatch.m_61228_().m_7918_(-3, 0, -3);
                for (i = 0; i < 3; ++i) {
                    for (j = 0; j < 3; ++j) {
                        pos = portalPos.m_7918_(i, 0, j);
                        if (!level.m_8055_(pos).m_60713_(Blocks.f_50752_)) continue;
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                    }
                }
                for (i = 0; i < 3; ++i) {
                    for (j = 0; j < 3; ++j) {
                        pos = portalPos.m_7918_(i, 0, j);
                        level.m_7731_(pos, Blocks.f_50257_.m_49966_(), 2);
                        level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
                    }
                }
                level.m_6798_(1038, portalPos.m_7918_(1, 0, 1), 0);
            }
            state.removePortal(bossUUID);
        }
    }
}

