/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.dimension;

import dev.muon.otherworld.Otherworld;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class EndPortalFinder {
    private static final int SEARCH_RADIUS = 128;
    private static final int VERTICAL_SEARCH_RANGE = 16;

    public static Optional<BlockPos> findOrCreatePortal(ServerLevel level, BlockPos searchPos) {
        Optional<BlockPos> existingPortal = EndPortalFinder.findExistingPortal(level, searchPos);
        if (existingPortal.isPresent()) {
            Otherworld.LOGGER.debug("Found existing End Portal at {}", (Object)existingPortal.get());
            return existingPortal;
        }
        Otherworld.LOGGER.debug("No existing End Portal found near {}, creating new one", (Object)searchPos);
        return EndPortalFinder.createPortal(level, searchPos);
    }

    private static Optional<BlockPos> findExistingPortal(ServerLevel level, BlockPos searchPos) {
        for (int x = -128; x <= 128; x += 4) {
            for (int z = -128; z <= 128; z += 4) {
                for (int y = -16; y <= 16; y += 2) {
                    BlockPos checkPos = searchPos.m_7918_(x, y, z);
                    if (!level.m_8055_(checkPos).m_60713_(Blocks.f_50257_) || !EndPortalFinder.isValidPortalLocation(level, checkPos)) continue;
                    return Optional.of(checkPos);
                }
            }
        }
        return Optional.empty();
    }

    private static boolean isValidPortalLocation(ServerLevel level, BlockPos pos) {
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                BlockPos checkPos = pos.m_7918_(x, 0, z);
                if (!level.m_8055_(checkPos).m_60713_(Blocks.f_50258_)) continue;
                return true;
            }
        }
        return false;
    }

    private static Optional<BlockPos> createPortal(ServerLevel level, BlockPos searchPos) {
        BlockPos surfacePos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, searchPos);
        BlockPos portalPos = surfacePos.m_7494_();
        if (EndPortalFinder.canPlacePortal(level, portalPos)) {
            level.m_7731_(portalPos, Blocks.f_50257_.m_49966_(), 3);
            Otherworld.LOGGER.info("Created new End Portal at {}", (Object)portalPos);
            return Optional.of(portalPos);
        }
        for (int y = 1; y <= 5; ++y) {
            BlockPos tryPos = portalPos.m_6630_(y);
            if (!EndPortalFinder.canPlacePortal(level, tryPos)) continue;
            level.m_7731_(tryPos, Blocks.f_50257_.m_49966_(), 3);
            Otherworld.LOGGER.info("Created new End Portal at {}", (Object)tryPos);
            return Optional.of(tryPos);
        }
        Otherworld.LOGGER.warn("Failed to create End Portal near {}", (Object)searchPos);
        return Optional.empty();
    }

    private static boolean canPlacePortal(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60795_() || state.m_247087_();
    }

    public static Optional<BlockPos> findSafeSpawnNearPortal(ServerLevel level, BlockPos portalPos) {
        int[] offsets;
        for (int offset : offsets = new int[]{2, 3, 4}) {
            BlockPos[] directions;
            for (BlockPos candidatePos : directions = new BlockPos[]{portalPos.m_122013_(offset), portalPos.m_122020_(offset), portalPos.m_122030_(offset), portalPos.m_122025_(offset)}) {
                BlockPos safePos = EndPortalFinder.findSafeYPosition(level, candidatePos);
                if (safePos == null || EndPortalFinder.isPortalBlock(level, safePos)) continue;
                Otherworld.LOGGER.debug("Found safe spawn position at {} near portal {}", (Object)safePos, (Object)portalPos);
                return Optional.of(safePos);
            }
        }
        Otherworld.LOGGER.warn("Could not find safe spawn position near portal at {}, will fall back to respawn/spawn", (Object)portalPos);
        return Optional.empty();
    }

    private static BlockPos findSafeYPosition(ServerLevel level, BlockPos pos) {
        int startY = pos.m_123342_();
        for (int yOffset = -3; yOffset <= 5; ++yOffset) {
            BlockPos checkPos = pos.m_175288_(startY + yOffset);
            BlockState groundState = level.m_8055_(checkPos);
            BlockState airState = level.m_8055_(checkPos.m_7494_());
            if (groundState.m_60795_() || groundState.m_60713_(Blocks.f_50257_) || !airState.m_60795_() || !level.m_8055_(checkPos.m_6630_(2)).m_60795_()) continue;
            return checkPos.m_7494_();
        }
        BlockPos surfacePos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
        BlockState surfaceState = level.m_8055_(surfacePos);
        if (!surfaceState.m_60795_() && !surfaceState.m_60713_(Blocks.f_50257_) && level.m_8055_(surfacePos.m_7494_()).m_60795_()) {
            return surfacePos.m_7494_();
        }
        return null;
    }

    private static boolean isPortalBlock(ServerLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_(Blocks.f_50257_) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50257_);
    }
}

