/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.dimension;

import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.dimension.DimensionRegistry;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class ElementalNexusTeleporter
implements ITeleporter {
    private final BlockPos exitPos;

    public ElementalNexusTeleporter(BlockPos exitPos) {
        this.exitPos = exitPos;
    }

    public Entity placeEntity(Entity entity, ServerLevel sourceLevel, ServerLevel targetLevel, float yaw, Function<Boolean, Entity> repositionEntity) {
        Entity repositionedEntity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Otherworld.LOGGER.info("Teleporting {} to Elemental Nexus dimension at {}", (Object)player.m_7755_().getString(), (Object)this.exitPos);
        }
        if ((repositionedEntity = repositionEntity.apply(false)) != null) {
            repositionedEntity.m_6021_((double)this.exitPos.m_123341_() + 0.5, (double)this.exitPos.m_123342_() + 1.0, (double)this.exitPos.m_123343_() + 0.5);
            repositionedEntity.m_146922_(180.0f);
            repositionedEntity.m_146926_(0.0f);
        }
        return repositionedEntity;
    }

    public PortalInfo getPortalInfo(Entity entity, ServerLevel destLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        return new PortalInfo(new Vec3((double)this.exitPos.m_123341_() + 0.5, (double)this.exitPos.m_123342_() + 1.0, (double)this.exitPos.m_123343_() + 0.5), Vec3.f_82478_, 180.0f, 0.0f);
    }

    public static boolean teleportToElementalNexus(ServerPlayer player, MinecraftServer server, BlockPos exitPosInNexus) {
        ServerLevel targetLevel = server.m_129880_(DimensionRegistry.ELEMENTAL_NEXUS);
        if (targetLevel == null) {
            Otherworld.LOGGER.error("Failed to teleport player to Elemental Nexus: dimension not found");
            return false;
        }
        ElementalNexusTeleporter teleporter = new ElementalNexusTeleporter(exitPosInNexus);
        player.changeDimension(targetLevel, (ITeleporter)teleporter);
        return true;
    }
}

