/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.data;

import dev.muon.otherworld.Otherworld;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;

public class BOMDReplacerPackResources
implements PackResources {
    private static final String PACK_META = "{\n    \"pack\": {\n        \"description\": \"Otherworld BOMD Data Overrides\",\n        \"pack_format\": 15\n    }\n}";

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... elements) {
        if (elements.length == 1 && elements[0].equals("pack.mcmeta")) {
            return () -> IOUtils.toInputStream((String)PACK_META, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        String specificPath = "/data/" + namespace + "/" + path;
        URL url = Otherworld.class.getResource(specificPath);
        if (url == null && path.isEmpty()) {
            url = Otherworld.class.getResource("/data/" + namespace);
        }
        if (url == null) {
            return;
        }
        try {
            Path rootPath = Paths.get(url.toURI());
            if (!Files.exists(rootPath, new LinkOption[0])) {
                return;
            }
            Files.walk(rootPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(filePath -> {
                try {
                    String relativePath = rootPath.relativize((Path)filePath).toString().replace('\\', '/');
                    String fullPath = path.isEmpty() ? relativePath : path + "/" + relativePath;
                    ResourceLocation location = new ResourceLocation(namespace, fullPath.endsWith(".json") ? fullPath.substring(0, fullPath.length() - 5) : fullPath);
                    resourceOutput.accept((Object)location, () -> Files.newInputStream(filePath, new OpenOption[0]));
                }
                catch (Exception e) {
                    Otherworld.LOGGER.error("Error processing file: " + String.valueOf(filePath), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            Otherworld.LOGGER.error("Error listing resources for " + String.valueOf(url), (Throwable)e);
        }
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        if (location.m_135815_().equals("pack.mcmeta")) {
            return () -> IOUtils.toInputStream((String)PACK_META, (Charset)StandardCharsets.UTF_8);
        }
        String path = String.format("/data/%s/%s", location.m_135827_(), location.m_135815_());
        if (Otherworld.class.getResource(path) == null) {
            return null;
        }
        return () -> {
            try {
                return Otherworld.class.getResourceAsStream(path);
            }
            catch (Exception e) {
                Otherworld.LOGGER.error("Failed to get resource: " + String.valueOf(location), (Throwable)e);
                return null;
            }
        };
    }

    public Set<String> m_5698_(PackType type) {
        return Set.of("bosses_of_mass_destruction");
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer.m_7991_().equals("pack")) {
            try (InputStream stream = IOUtils.toInputStream((String)PACK_META, (Charset)StandardCharsets.UTF_8);){
                Object object = AbstractPackResources.m_10214_(deserializer, (InputStream)stream);
                return (T)object;
            }
        }
        return null;
    }

    public String m_5542_() {
        return "otherworld_bomd";
    }

    public boolean m_246538_() {
        return true;
    }

    public void close() {
    }
}

