/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.dimension.DimensionRegistry;
import dev.muon.otherworld.world.saved_data.NexusHubPlacementState;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ResetNexusCommand {
    private static final ResourceLocation NEXUS_HUB_STRUCTURE_ID = new ResourceLocation("otherworld", "nexus_hub");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"otherworld").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset_nexus").requires(source -> source.m_6761_(2))).executes(ResetNexusCommand::executeResetNexus)));
    }

    private static int executeResetNexus(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel nexusLevel = source.m_81377_().m_129880_(DimensionRegistry.ELEMENTAL_NEXUS);
        if (nexusLevel == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Elemental Nexus dimension not found!"));
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)"Attempting to reset and regenerate Nexus Hub..."), true);
        NexusHubPlacementState placementState = NexusHubPlacementState.get(nexusLevel);
        placementState.resetPlacement();
        Otherworld.LOGGER.info("Nexus Hub placement state reset by command.");
        BlockPos structurePlacementPos = new BlockPos(0, 64, 0);
        BlockPos knightSpawnPos = new BlockPos(50, 66, 52);
        try {
            StructureTemplate template = (StructureTemplate)nexusLevel.m_215082_().m_230407_(NEXUS_HUB_STRUCTURE_ID).orElseThrow(() -> new IllegalStateException("Could not find structure template: " + String.valueOf(NEXUS_HUB_STRUCTURE_ID)));
            StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_74392_(true);
            Otherworld.LOGGER.info("Command: Placing Nexus Hub structure at {} in dimension {}", (Object)structurePlacementPos, (Object)DimensionRegistry.ELEMENTAL_NEXUS.m_135782_());
            boolean success = template.m_230328_((ServerLevelAccessor)nexusLevel, structurePlacementPos, structurePlacementPos, placeSettings, nexusLevel.f_46441_, 2);
            if (success) {
                Otherworld.LOGGER.info("Command: Successfully placed Nexus Hub structure at {}", (Object)structurePlacementPos);
                source.m_288197_(() -> Component.m_237113_((String)"Nexus Hub structure regenerated."), true);
                Optional knightTypeOpt = EntityType.m_20632_((String)"soulsweapons:returning_knight");
                if (knightTypeOpt.isPresent()) {
                    EntityType knightType = (EntityType)knightTypeOpt.get();
                    knightType.m_262496_(nexusLevel, knightSpawnPos, MobSpawnType.STRUCTURE);
                    Otherworld.LOGGER.info("Command: Successfully spawned Returning Knight at {}", (Object)knightSpawnPos);
                    source.m_288197_(() -> Component.m_237113_((String)"Returning Knight spawned."), true);
                } else {
                    Otherworld.LOGGER.error("Command: EntityType 'soulsweapons:returning_knight' not found!");
                    source.m_81352_((Component)Component.m_237113_((String)"Failed to spawn Returning Knight: EntityType not found."));
                }
                placementState.markAsPlaced();
                Otherworld.LOGGER.info("Command: Nexus Hub setup complete. Marked as placed in SavedData.");
                return 1;
            }
            Otherworld.LOGGER.error("Command: Failed to place Nexus Hub structure at {}.", (Object)structurePlacementPos);
            source.m_81352_((Component)Component.m_237113_((String)"Failed to regenerate Nexus Hub structure."));
            return 0;
        }
        catch (Exception e) {
            Otherworld.LOGGER.error("Command: Exception during Nexus Hub regeneration: ", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Exception during regeneration: " + e.getMessage())));
            return 0;
        }
    }
}

