/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.muon.otherworld.block.entity.NexusAltarBlockEntity;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class NexusAltarRenderer
implements BlockEntityRenderer<NexusAltarBlockEntity> {
    private final ItemRenderer itemRenderer;
    private final Random random = new Random();
    private static final float MAX_SHAKE_TRANSLATION = 0.08f;
    private static final float MAX_SHAKE_ROTATION_X = 15.0f;
    private static final float MAX_SHAKE_ROTATION_Y_JITTER = 25.0f;
    private static final float MAX_SHAKE_ROTATION_Z = 15.0f;
    private static final float RITUAL_CONTINUOUS_ASCENT_MAX_HEIGHT = 0.5f;

    public NexusAltarRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
    }

    public void render(NexusAltarBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ItemStack itemStack = pBlockEntity.getItemToProcess();
        Level level = pBlockEntity.m_58904_();
        if (level == null || itemStack.m_41619_()) {
            return;
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.5, 1.15, 0.5);
        float cameraYRot = Minecraft.m_91087_().f_91063_.m_109153_().m_90590_();
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - cameraYRot));
        pPoseStack.m_85841_(0.6f, 0.6f, 0.6f);
        boolean isInGrandRitualShake = pBlockEntity.isPreGrandRitualShake();
        boolean isInProcessingRitual = pBlockEntity.isProcessing();
        if (isInGrandRitualShake || isInProcessingRitual) {
            int totalDuration;
            int timer = isInGrandRitualShake ? pBlockEntity.getPreGrandRitualTimer() : pBlockEntity.getProcessingTimer();
            int n = totalDuration = isInGrandRitualShake ? NexusAltarBlockEntity.getPreRitualShakeDuration() : NexusAltarBlockEntity.getTransformationDuration();
            if (totalDuration == 0) {
                totalDuration = 200;
            }
            float overallProgress = 1.0f - ((float)timer - pPartialTick) / (float)totalDuration;
            overallProgress = Mth.m_14036_((float)overallProgress, (float)0.0f, (float)1.0f);
            float easedProgress = overallProgress * overallProgress;
            float currentAscent = overallProgress * 0.5f;
            pPoseStack.m_252880_(0.0f, currentAscent, 0.0f);
            float translationIntensity = easedProgress * 0.08f;
            float rotationIntensity = easedProgress;
            float shakeX = (this.random.nextFloat() - 0.5f) * 2.0f * translationIntensity;
            float shakeY_rand = (this.random.nextFloat() - 0.5f) * 2.0f * translationIntensity * 0.3f;
            float shakeZ = (this.random.nextFloat() - 0.5f) * 2.0f * translationIntensity;
            pPoseStack.m_252880_(shakeX, shakeY_rand, shakeZ);
            float rotX_jitter = (this.random.nextFloat() - 0.5f) * 2.0f * rotationIntensity * 15.0f;
            float rotY_jitter = (this.random.nextFloat() - 0.5f) * 2.0f * rotationIntensity * 25.0f;
            float rotZ_jitter = (this.random.nextFloat() - 0.5f) * 2.0f * rotationIntensity * 15.0f;
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(rotX_jitter));
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(rotY_jitter));
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(rotZ_jitter));
        }
        this.itemRenderer.m_269128_(itemStack, ItemDisplayContext.GROUND, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, (int)pBlockEntity.m_58899_().m_121878_());
        pPoseStack.m_85849_();
    }
}

