/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.network.BossNarrationPacketHandler;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BossNarrationScreen
extends Screen {
    private static final ResourceLocation VIGNETTE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/vignette.png");
    private static final String OBFUSCATE_TOKEN = String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.OBFUSCATED) + String.valueOf(ChatFormatting.GREEN) + String.valueOf(ChatFormatting.AQUA);
    private final Runnable onFinished;
    private float scroll;
    private List<FormattedCharSequence> lines;
    private IntSet centeredLines;
    private int totalScrollLength;
    private boolean speedupActive;
    private final IntSet speedupModifiers = new IntOpenHashSet();
    private float scrollSpeed;
    private final float unmodifiedScrollSpeed = 0.5f;
    private int direction = 1;
    private boolean hasClosedAndSentPacket = false;

    public BossNarrationScreen(Runnable onFinished) {
        super((Component)Component.m_237115_((String)"screen.otherworld.boss_narration"));
        this.onFinished = onFinished;
        this.scrollSpeed = this.unmodifiedScrollSpeed;
    }

    private float calculateScrollSpeed() {
        return this.speedupActive ? this.unmodifiedScrollSpeed * (5.0f + (float)this.speedupModifiers.size() * 15.0f) * (float)this.direction : this.unmodifiedScrollSpeed * (float)this.direction;
    }

    public void m_86600_() {
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91397_().m_120183_();
        this.f_96541_.m_91106_().m_120389_(false);
        float f = this.totalScrollLength + this.f_96544_ + 24;
        if (this.scroll > f) {
            this.sendClosePacket();
            this.onFinished.run();
            this.f_96541_.m_91152_(null);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.scroll >= (float)this.f_96544_) {
                this.sendClosePacket();
                this.onFinished.run();
                this.f_96541_.m_91152_(null);
                return true;
            }
            return true;
        }
        if (keyCode == 265) {
            this.direction = -1;
        } else if (keyCode == 341 || keyCode == 345) {
            this.speedupModifiers.add(keyCode);
        } else if (keyCode == 32) {
            this.speedupActive = true;
        }
        this.scrollSpeed = this.calculateScrollSpeed();
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.direction = 1;
        }
        if (keyCode == 32) {
            this.speedupActive = false;
        } else if (keyCode == 341 || keyCode == 345) {
            this.speedupModifiers.remove(keyCode);
        }
        this.scrollSpeed = this.calculateScrollSpeed();
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        this.sendClosePacket();
        this.onFinished.run();
    }

    private void sendClosePacket() {
        if (!this.hasClosedAndSentPacket) {
            this.hasClosedAndSentPacket = true;
            BossNarrationPacketHandler.INSTANCE.sendToServer((Object)new BossNarrationPacketHandler.CloseBossNarrationScreenPacket());
        }
    }

    protected void m_7856_() {
        if (this.lines == null) {
            this.lines = Lists.newArrayList();
            this.centeredLines = new IntOpenHashSet();
            this.loadNarrationText();
            this.totalScrollLength = this.lines.size() * 12;
        }
    }

    private void loadNarrationText() {
        try (BufferedReader reader = this.f_96541_.m_91098_().m_215597_(Otherworld.loc("texts/boss_narration.txt"));){
            Object s;
            BufferedReader bufferedreader = new BufferedReader(reader);
            RandomSource randomsource = RandomSource.m_216335_((long)8124371L);
            while ((s = bufferedreader.readLine()) != null) {
                int i;
                s = ((String)s).replaceAll("PLAYERNAME", this.f_96541_.m_91094_().m_92546_());
                while ((i = ((String)s).indexOf(OBFUSCATE_TOKEN)) != -1) {
                    String s1 = ((String)s).substring(0, i);
                    String s2 = ((String)s).substring(i + OBFUSCATE_TOKEN.length());
                    s = s1 + String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.OBFUSCATED) + "XXXXXXXX".substring(0, randomsource.m_188503_(4) + 3) + s2;
                }
                if (((String)s).startsWith("###")) {
                    s = ((String)s).substring(3).trim();
                    this.centeredLines.add(this.lines.size());
                    this.lines.add(Component.m_237113_((String)s).m_130940_(ChatFormatting.YELLOW).m_7532_());
                    continue;
                }
                if (((String)s).trim().isEmpty()) {
                    this.addEmptyLine();
                    continue;
                }
                this.addNarrationLine((String)s);
            }
            for (int j = 0; j < 8; ++j) {
                this.addEmptyLine();
            }
        }
        catch (IOException e) {
            Otherworld.LOGGER.error("Couldn't load boss narration text", (Throwable)e);
            this.addNarrationLine("The void calls to you...");
            this.addEmptyLine();
            this.addNarrationLine("Your journey has only just begun.");
        }
    }

    private void addEmptyLine() {
        this.lines.add(FormattedCharSequence.f_13691_);
    }

    private void addNarrationLine(String text) {
        this.lines.addAll(this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237113_((String)text), 256));
    }

    private void renderBg(GuiGraphics guiGraphics) {
        int i = this.f_96543_;
        float f = this.scroll * 0.5f;
        float f3 = (float)(this.totalScrollLength + this.f_96544_ + this.f_96544_ + 24) / this.unmodifiedScrollSpeed;
        float f1 = this.scroll / this.unmodifiedScrollSpeed;
        float f4 = (f3 - 20.0f - f1) * 0.005f;
        float f2 = f1 * 0.02f;
        if (f4 < f2) {
            f2 = f4;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 *= f2;
        f2 = f2 * 96.0f / 255.0f;
        guiGraphics.m_280246_(f2 * 0.4f, f2 * 0.3f, f2 * 0.5f, 1.0f);
        guiGraphics.m_280398_(f_279548_, 0, 0, 0, 0.0f, f, i, this.f_96544_, 64, 64);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.scroll = Math.max(0.0f, this.scroll + partialTick * this.scrollSpeed);
        this.renderBg(guiGraphics);
        int i = this.f_96543_ / 2 - 128;
        int j = this.f_96544_ + 50;
        float f = -this.scroll;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, f, 0.0f);
        MutableComponent title = Component.m_237115_((String)"screen.otherworld.boss_narration.title").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD});
        guiGraphics.m_280653_(this.f_96547_, (Component)title, this.f_96543_ / 2, j, 0xAA00AA);
        int k = j + 50;
        for (int l = 0; l < this.lines.size(); ++l) {
            float f1;
            if (l == this.lines.size() - 1 && (f1 = (float)k + f - (float)(this.f_96544_ / 2 - 6)) < 0.0f) {
                guiGraphics.m_280168_().m_252880_(0.0f, -f1, 0.0f);
            }
            if ((float)k + f + 12.0f + 8.0f > 0.0f && (float)k + f < (float)this.f_96544_) {
                FormattedCharSequence formattedcharsequence = this.lines.get(l);
                if (this.centeredLines.contains(l)) {
                    guiGraphics.m_280364_(this.f_96547_, formattedcharsequence, i + 128, k, 0xFFFFFF);
                } else {
                    guiGraphics.m_280648_(this.f_96547_, formattedcharsequence, i, k, 0xDDDDDD);
                }
            }
            k += 12;
        }
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        guiGraphics.m_280398_(VIGNETTE_LOCATION, 0, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.f_96543_, this.f_96544_);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_7861_() {
        this.sendClosePacket();
        if (this.f_96541_ != null) {
            this.f_96541_.m_91397_().m_120186_();
        }
    }

    public Music m_278176_() {
        ResourceLocation soundLocation = ResourceLocation.fromNamespaceAndPath((String)"betterend", (String)"betterend.record.grasping_at_stars");
        if (BuiltInRegistries.f_256894_.m_7804_(soundLocation)) {
            SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundLocation);
            Holder soundHolder = BuiltInRegistries.f_256894_.m_263177_((Object)soundEvent);
            return new Music(soundHolder, 0, 0, true);
        }
        return Musics.f_11647_;
    }

    public boolean m_7043_() {
        return false;
    }
}

