/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.client;

import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.particle.ShockwaveParticleOptions;
import io.redspace.ironsspellbooks.particle.ZapParticleOption;
import io.redspace.ironsspellbooks.registries.ParticleRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ClientHeartTransformHandler {
    private static final Map<Integer, String> transformingItems = new ConcurrentHashMap<Integer, String>();
    private static final Vector3f FIRE_COLOR = new Vector3f(1.0f, 0.4f, 0.1f);
    private static final Vector3f ICE_COLOR = new Vector3f(0.6f, 0.85f, 1.0f);
    private static final Vector3f LIGHTNING_COLOR = new Vector3f(0.9f, 0.95f, 1.0f);
    private static final float SHOCKWAVE_SCALE = 1.5f;

    public static void startTracking(int entityId, String transformType) {
        transformingItems.put(entityId, transformType);
    }

    public static void stopTracking(int entityId) {
        transformingItems.remove(entityId);
    }

    public static void tick() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            transformingItems.clear();
            return;
        }
        Iterator<Map.Entry<Integer, String>> iterator = transformingItems.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, String> entry = iterator.next();
            int entityId = entry.getKey();
            String type = entry.getValue();
            Entity entity = level.m_6815_(entityId);
            if (entity == null || entity.m_213877_()) {
                iterator.remove();
                continue;
            }
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            ClientHeartTransformHandler.spawnChargingParticles(itemEntity, (Level)level, type);
        }
    }

    private static void spawnChargingParticles(ItemEntity itemEntity, Level level, String type) {
        SimpleParticleType particleType;
        double x = itemEntity.m_20185_();
        double y = itemEntity.m_20186_();
        double z = itemEntity.m_20189_();
        float radius = 0.7f;
        float height = 0.5f;
        float speed = 0.08f;
        double centerY = y + 0.2;
        switch (type) {
            case "fire": {
                SimpleParticleType simpleParticleType = ParticleTypes.f_123744_;
                break;
            }
            case "ice": {
                SimpleParticleType simpleParticleType = ParticleTypes.f_175821_;
                break;
            }
            case "lightning": {
                SimpleParticleType simpleParticleType = (SimpleParticleType)ParticleRegistry.ELECTRICITY_PARTICLE.get();
                break;
            }
            default: {
                SimpleParticleType simpleParticleType = particleType = null;
            }
        }
        if (particleType == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            double angle = (double)level.f_46441_.m_188501_() * 2.0 * Math.PI;
            double xOffset = (double)radius * Math.cos(angle);
            double zOffset = (double)radius * Math.sin(angle);
            double yOffset = level.f_46441_.m_188501_() * height;
            double vx = -zOffset * (double)speed;
            double vz = xOffset * (double)speed;
            double vy = (double)(level.f_46441_.m_188501_() - 0.5f) * 0.02;
            level.m_6485_((ParticleOptions)particleType, true, x + xOffset, centerY + yOffset, z + zOffset, vx, vy, vz);
        }
        if (level.m_46467_() % 2L == 0L) {
            double beamX = level.f_46441_.m_188500_() * 0.4 - 0.2 + x;
            double beamY = centerY + (double)height + 0.3;
            double beamZ = level.f_46441_.m_188500_() * 0.4 - 0.2 + z;
            level.m_6485_((ParticleOptions)ParticleTypes.f_123809_, true, beamX, beamY, beamZ, 0.0, 0.15 + level.f_46441_.m_188500_() * 0.05, 0.0);
        }
        if (type.equals("fire") && level.m_46467_() % 10L == 0L) {
            level.m_6485_((ParticleOptions)ParticleTypes.f_123756_, true, x, y + 0.3, z, 0.0, 0.0, 0.0);
        } else if (type.equals("ice") && level.m_46467_() % 8L == 0L) {
            level.m_6485_((ParticleOptions)ParticleTypes.f_123796_, true, x, y + 0.3, z, 0.0, 0.05, 0.0);
        } else if (type.equals("lightning")) {
            double angle = (double)level.f_46441_.m_188501_() * 2.0 * Math.PI;
            double startRadius = 0.6;
            double startX = x + startRadius * Math.cos(angle);
            double startZ = z + startRadius * Math.sin(angle);
            double startY = y + 0.1;
            double targetY = y + 0.5;
            ZapParticleOption zapOptions = new ZapParticleOption(new Vec3(x, targetY, z));
            level.m_7106_((ParticleOptions)zapOptions, startX, startY, startZ, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnFinalEffects(double x, double y, double z, String type) {
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        double effectY = y + 0.5;
        Vector3f color = switch (type) {
            case "fire" -> FIRE_COLOR;
            case "ice" -> ICE_COLOR;
            case "lightning" -> LIGHTNING_COLOR;
            default -> FIRE_COLOR;
        };
        level.m_6485_((ParticleOptions)new ShockwaveParticleOptions(color, 1.8000001f, false, ""), true, x, effectY, z, 0.0, 0.0, 0.0);
        level.m_6485_((ParticleOptions)new BlastwaveParticleOptions(color, 1.6500001f), true, x, effectY, z, 0.0, 0.0, 0.0);
        level.m_6485_((ParticleOptions)ParticleTypes.f_123747_, true, x, effectY, z, 0.0, 0.0, 0.0);
        for (i = 0; i < 20; ++i) {
            double vx = (level.f_46441_.m_188500_() - 0.5) * 0.3;
            double vy = level.f_46441_.m_188500_() * 0.2;
            double vz = (level.f_46441_.m_188500_() - 0.5) * 0.3;
            SimpleParticleType burst = switch (type) {
                case "fire" -> ParticleTypes.f_123744_;
                case "ice" -> ParticleTypes.f_175821_;
                case "lightning" -> (SimpleParticleType)ParticleRegistry.ELECTRICITY_PARTICLE.get();
                default -> ParticleTypes.f_123744_;
            };
            level.m_6485_((ParticleOptions)burst, true, x, y + 0.25, z, vx, vy, vz);
        }
        if (type.equals("lightning")) {
            for (i = 0; i < 8; ++i) {
                double angle = (double)level.f_46441_.m_188501_() * 2.0 * Math.PI;
                double startRadius = 1.0 + level.f_46441_.m_188500_() * 0.5;
                double startX = x + startRadius * Math.cos(angle);
                double startZ = z + startRadius * Math.sin(angle);
                double startY = y + level.f_46441_.m_188500_() * 0.3;
                ZapParticleOption zapOptions = new ZapParticleOption(new Vec3(x, effectY, z));
                level.m_7106_((ParticleOptions)zapOptions, startX, startY, startZ, 0.0, 0.0, 0.0);
            }
        }
    }
}

