/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.block.entity;

import dev.muon.otherworld.block.entity.BlockEntityRegistry;
import dev.muon.otherworld.item.ItemRegistry;
import dev.muon.otherworld.network.HeartTransformPacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PlacedIceHeartBlockEntity
extends BlockEntity {
    private static final int TRANSFORM_TIME = 600;
    private int timer = 600;
    private static final String TIMER_TAG = "IceHeartTimer";

    public PlacedIceHeartBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.PLACED_ICE_HEART_BE.get(), pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128405_(TIMER_TAG, this.timer);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.timer = pTag.m_128451_(TIMER_TAG);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, PlacedIceHeartBlockEntity pBlockEntity) {
        if (pLevel.m_5776_() || !(pLevel instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)pLevel;
        if (pBlockEntity.timer > 0) {
            --pBlockEntity.timer;
            if (pBlockEntity.timer % 20 == 0) {
                pBlockEntity.m_6596_();
                pLevel.m_7260_(pPos, pState, pState, 3);
            }
        } else if (pBlockEntity.timer == 0) {
            boolean conditionsMet = PlacedIceHeartBlockEntity.checkConditions(pLevel, pPos);
            if (conditionsMet) {
                PlacedIceHeartBlockEntity.transform(serverLevel, pPos);
            } else {
                PlacedIceHeartBlockEntity.failTransformation(serverLevel, pPos);
            }
            pBlockEntity.timer = -1;
            pBlockEntity.m_6596_();
        }
    }

    public static void clientTick(Level pLevel, BlockPos pPos, BlockState pState, PlacedIceHeartBlockEntity pBlockEntity) {
        if (!pLevel.m_5776_()) {
            return;
        }
        if (pBlockEntity.timer > 0) {
            float radius = 0.7f;
            float height = 0.5f;
            float speed = 0.08f;
            double centerX = (double)pPos.m_123341_() + 0.5;
            double centerY = (double)pPos.m_123342_() + 0.3;
            double centerZ = (double)pPos.m_123343_() + 0.5;
            for (int i = 0; i < 3; ++i) {
                double angle = (double)pLevel.f_46441_.m_188501_() * 2.0 * Math.PI;
                double xOffset = (double)radius * Math.cos(angle);
                double zOffset = (double)radius * Math.sin(angle);
                double yOffset = pLevel.f_46441_.m_188501_() * height;
                double vx = -zOffset * (double)speed;
                double vz = xOffset * (double)speed;
                double vy = (double)(pLevel.f_46441_.m_188501_() - 0.5f) * 0.02;
                pLevel.m_6485_((ParticleOptions)ParticleTypes.f_175821_, true, centerX + xOffset, centerY + yOffset, centerZ + zOffset, vx, vy, vz);
            }
            if (pLevel.m_46467_() % 2L == 0L) {
                double beamX = pLevel.f_46441_.m_188500_() * 0.4 - 0.2 + centerX;
                double beamY = centerY + (double)height + 0.3;
                double beamZ = pLevel.f_46441_.m_188500_() * 0.4 - 0.2 + centerZ;
                pLevel.m_6485_((ParticleOptions)ParticleTypes.f_123809_, true, beamX, beamY, beamZ, 0.0, 0.15 + pLevel.f_46441_.m_188500_() * 0.05, 0.0);
            }
            if (pLevel.m_46467_() % 8L == 0L) {
                pLevel.m_6485_((ParticleOptions)ParticleTypes.f_123796_, true, centerX, centerY + 0.3, centerZ, 0.0, 0.05, 0.0);
            }
        }
    }

    private static boolean checkConditions(Level level, BlockPos pos) {
        if (pos.m_123342_() <= 192) {
            return false;
        }
        if (!level.m_46462_()) {
            return false;
        }
        return level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50568_);
    }

    private static void transform(ServerLevel level, BlockPos pos) {
        HeartTransformPacketHandler.sendStopTransform(level, -1, "ice", (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        level.m_7471_(pos, false);
        ItemEntity iceStoneEntity = new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ItemRegistry.ICE_STONE.get()));
        iceStoneEntity.m_149678_();
        level.m_7967_((Entity)iceStoneEntity);
        level.m_5594_(null, pos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 1.5f);
        level.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 0.8f);
        level.m_5594_(null, pos, SoundEvents.f_11860_, SoundSource.BLOCKS, 1.2f, 1.0f);
    }

    private static void failTransformation(ServerLevel level, BlockPos pos) {
        level.m_7471_(pos, false);
        ItemStack heartStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"ice_dragon_heart")));
        if (!heartStack.m_41619_()) {
            ItemEntity heartEntity = new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, heartStack);
            level.m_7967_((Entity)heartEntity);
        }
        level.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 15, 0.3, 0.3, 0.3, 0.05);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

