/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.block.entity;

import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.block.NexusAltarBlock;
import dev.muon.otherworld.block.entity.BlockEntityRegistry;
import dev.muon.otherworld.dimension.DimensionRegistry;
import dev.muon.otherworld.event.StoryItemInjectEvents;
import dev.muon.otherworld.item.ItemRegistry;
import dev.muon.otherworld.sound.SoundRegistry;
import dev.muon.otherworld.world.saved_data.ActiveRitualBossTracker;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.particle.ShockwaveParticleOptions;
import io.redspace.ironsspellbooks.particle.ZapParticleOption;
import io.redspace.ironsspellbooks.registries.ParticleRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import pro.komaru.tridot.client.gfx.particle.options.GenericParticleOptions;

public class NexusAltarBlockEntity
extends BlockEntity {
    private static final String RITUAL_TYPE_TAG = "RitualType";
    private static final String ITEM_STACK_TAG = "ProcessingItem";
    private static final String IS_PROCESSING_TAG = "IsProcessing";
    private static final String PROCESSING_TIMER_TAG = "ProcessingTimer";
    private static final String IS_GRAND_RITUAL_LOCKED_TAG = "IsGrandRitualLocked";
    private static final String PRE_GRAND_RITUAL_SHAKE_TAG = "PreGrandRitualShake";
    private static final String PRE_GRAND_RITUAL_TIMER_TAG = "PreGrandRitualTimer";
    private static final String LINKED_PARTNER_POS_TAG = "LinkedPartnerPos";
    private static final String SPAWNED_BOSS_UUID_TAG = "SpawnedBossUUID";
    public static final String FIRE_PEDESTAL_TYPE = "fire_pedestal";
    public static final String ICE_PEDESTAL_TYPE = "ice_pedestal";
    public static final String LIGHTNING_PEDESTAL_TYPE = "lightning_pedestal";
    public static final String EARTH_PEDESTAL_TYPE = "earth_pedestal";
    public static final String LIFE_PEDESTAL_TYPE = "life_pedestal";
    public static final String DEATH_PEDESTAL_TYPE = "death_pedestal";
    public static final Map<String, String> PEDESTAL_LINKS = Map.of("life_pedestal", "death_pedestal", "death_pedestal", "life_pedestal", "fire_pedestal", "ice_pedestal", "ice_pedestal", "fire_pedestal", "lightning_pedestal", "earth_pedestal", "earth_pedestal", "lightning_pedestal");
    public static final List<String> ALL_PEDESTAL_TYPES = List.of("fire_pedestal", "ice_pedestal", "lightning_pedestal", "earth_pedestal", "life_pedestal", "death_pedestal");
    public static final int PRE_RITUAL_SHAKE_DURATION = 200;
    private static final int TRANSFORMATION_DURATION = 200;
    private static final int ZAP_PARTICLES_PER_TICK = 1;
    private static final double ZAP_START_RADIUS = 0.6;
    private static final double ZAP_TARGET_RADIUS = 0.5;
    private static final double ZAP_START_Y_OFFSET = 0.1;
    private static final double ZAP_TARGET_Y_OFFSET = 0.6;
    private static final int SHOCKWAVE_SPAWN_INTERVAL = 5;
    private static final double SHOCKWAVE_SPAWN_Y_OFFSET = 0.5;
    private static final float SHOCKWAVE_SCALE = 1.2f;
    private static final int BLASTWAVE_SPAWN_INTERVAL = 10;
    private static final float BLASTWAVE_SCALE = 1.3f;
    private static final double BLASTWAVE_SPAWN_Y_OFFSET = 0.3;
    private static final Vector3f EARTH_PARTICLE_COLOR = new Vector3f(0.6f, 0.5f, 0.4f);
    private static final Vector3f WHITE_COLOR = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Map<String, BlockPos> PEDESTAL_LOCATIONS = Map.of("lightning_pedestal", new BlockPos(20, 70, 22), "earth_pedestal", new BlockPos(80, 70, 82), "death_pedestal", new BlockPos(92, 70, 52), "fire_pedestal", new BlockPos(80, 70, 22), "ice_pedestal", new BlockPos(20, 70, 82), "life_pedestal", new BlockPos(8, 70, 52));
    private static final int SILENCE_BEFORE_BOOM_TICKS = 40;
    private String ritualType = "default";
    private ItemStack itemToProcess = ItemStack.f_41583_;
    private boolean isProcessing = false;
    private int processingTimer = 0;
    private boolean isGrandRitualLocked = false;
    private boolean preGrandRitualShake = false;
    private int preGrandRitualTimer = 0;
    private BlockPos linkedPartnerPos = null;
    private UUID spawnedBossUUID = null;

    public NexusAltarBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.NEXUS_ALTAR_BE.get(), pPos, pBlockState);
    }

    public String getRitualType() {
        return this.ritualType;
    }

    public ItemStack getItemToProcess() {
        return this.itemToProcess;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public int getProcessingTimer() {
        return this.processingTimer;
    }

    public boolean isGrandRitualLocked() {
        return this.isGrandRitualLocked;
    }

    public boolean isPreGrandRitualShake() {
        return this.preGrandRitualShake;
    }

    public int getPreGrandRitualTimer() {
        return this.preGrandRitualTimer;
    }

    @Nullable
    public BlockPos getLinkedPartnerPos() {
        return this.linkedPartnerPos;
    }

    public float getProcessingProgress(float partialTicks) {
        if (!this.isProcessing || this.processingTimer <= 0) {
            return 0.0f;
        }
        return 1.0f - ((float)this.processingTimer - partialTicks) / 200.0f;
    }

    public void startTransformationRitual(ItemStack inputStack) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.isProcessing || !this.itemToProcess.m_41619_()) {
            return;
        }
        this.itemToProcess = inputStack.m_41777_();
        this.isProcessing = true;
        this.processingTimer = 200;
        this.m_6596_();
        this.syncData();
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.INFUSION_START.get(), SoundSource.BLOCKS, 0.3f, 0.9f);
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.CHANNELED_WAIL.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    public void setPedestalItem(ItemStack stoneStack) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.itemToProcess = stoneStack.m_41777_();
        this.isProcessing = false;
        this.processingTimer = 0;
        this.m_6596_();
        this.syncData();
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, NexusAltarBlockEntity pBlockEntity) {
        ServerLevel serverLevel;
        NexusAltarBlockEntity.handleClientEffects(pLevel, pPos, pState, pBlockEntity);
        NexusAltarBlockEntity.handleServerProcessing(pLevel, pPos, pState, pBlockEntity);
        if (!pLevel.f_46443_ && pBlockEntity.preGrandRitualShake) {
            --pBlockEntity.preGrandRitualTimer;
            if (pBlockEntity.preGrandRitualTimer == 40 && pLevel instanceof ServerLevel) {
                serverLevel = (ServerLevel)pLevel;
                ClientboundStopSoundPacket stopSoundPacket = new ClientboundStopSoundPacket(null, null);
                for (ServerPlayer playerInDimension : serverLevel.m_6907_()) {
                    if (playerInDimension.m_9236_().m_46472_() != DimensionRegistry.ELEMENTAL_NEXUS) continue;
                    playerInDimension.f_8906_.m_9829_((Packet)stopSoundPacket);
                }
            }
            if (pBlockEntity.preGrandRitualTimer <= 0) {
                pBlockEntity.preGrandRitualShake = false;
                pBlockEntity.executeGrandRitualBoomSequence();
            }
            if (pBlockEntity.preGrandRitualTimer % 5 == 0 || pBlockEntity.preGrandRitualTimer <= 0 || pBlockEntity.preGrandRitualTimer == 40) {
                pBlockEntity.m_6596_();
                pBlockEntity.syncData();
            }
        }
        if (!pLevel.f_46443_ && pBlockEntity.isGrandRitualLocked && pBlockEntity.spawnedBossUUID != null && pLevel instanceof ServerLevel) {
            serverLevel = (ServerLevel)pLevel;
            if (pLevel.m_46467_() % 100L == 0L && serverLevel.m_8791_(pBlockEntity.spawnedBossUUID) == null) {
                Otherworld.LOGGER.warn("Ritual boss {} no longer exists, unlocking all grand ritual altars", (Object)pBlockEntity.spawnedBossUUID);
                NexusAltarBlockEntity.unlockAllGrandRitualAltars(serverLevel, pBlockEntity.spawnedBossUUID);
            }
        }
    }

    private static void handleClientEffects(Level pLevel, BlockPos pPos, BlockState pState, NexusAltarBlockEntity pBlockEntity) {
        if (!pLevel.f_46443_) {
            return;
        }
        if (pBlockEntity.isGrandRitualLocked()) {
            if (pLevel.m_46467_() % 7L == 0L) {
                NexusAltarBlockEntity.spawnGrandRitualLockedParticles(pLevel, pPos);
            }
            NexusAltarBlockEntity.handleAmbientSound(pLevel, pPos);
            return;
        }
        if (!((Boolean)pState.m_61143_((Property)NexusAltarBlock.ACTIVATED)).booleanValue() && !pBlockEntity.isPreGrandRitualShake()) {
            return;
        }
        if (((Boolean)pState.m_61143_((Property)NexusAltarBlock.ACTIVATED)).booleanValue()) {
            NexusAltarBlockEntity.handleAmbientSound(pLevel, pPos);
        }
        if (!pBlockEntity.getItemToProcess().m_41619_()) {
            NexusAltarBlockEntity.handleActiveParticles(pLevel, pPos, pBlockEntity);
        }
    }

    private static void handleAmbientSound(Level pLevel, BlockPos pPos) {
        if (pLevel.m_46467_() % 80L == 0L) {
            pLevel.m_7785_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, SoundEvents.f_11737_, SoundSource.BLOCKS, 0.5f, 1.0f, false);
        }
    }

    private static void handleActiveParticles(Level pLevel, BlockPos pPos, NexusAltarBlockEntity pBlockEntity) {
        ItemStack item = pBlockEntity.getItemToProcess();
        if (item.m_41619_()) {
            return;
        }
        ParticleOptions thematicParticle = NexusAltarBlockEntity.getThematicParticleForItem(item);
        if (thematicParticle == null) {
            return;
        }
        NexusAltarBlockEntity.spawnThematicEffect(pLevel, pPos, thematicParticle);
        NexusAltarBlockEntity.spawnBeamParticles(pLevel, pPos);
        if (item.m_150930_((Item)ItemRegistry.EARTH_STONE.get()) || item.m_150930_((Item)ItemRegistry.SCORCHED_NETHER_CORE.get())) {
            NexusAltarBlockEntity.handleEarthBlastwave(pLevel, pPos);
        }
    }

    private static void spawnThematicEffect(Level pLevel, BlockPos pPos, ParticleOptions thematicParticle) {
        if (thematicParticle == ParticleRegistry.ELECTRICITY_PARTICLE.get()) {
            NexusAltarBlockEntity.spawnZapParticles(pLevel, pPos);
        } else if (thematicParticle instanceof ShockwaveParticleOptions) {
            if (pLevel.m_46467_() % 5L == 0L) {
                pLevel.m_7106_(thematicParticle, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
        } else {
            NexusAltarBlockEntity.spawnFogParticles(pLevel, pPos, thematicParticle);
        }
    }

    private static void handleEarthBlastwave(Level pLevel, BlockPos pPos) {
        if (pLevel.m_46467_() % 10L == 0L) {
            BlastwaveParticleOptions blastOptions = new BlastwaveParticleOptions(WHITE_COLOR, 1.3f);
            pLevel.m_7106_((ParticleOptions)blastOptions, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.3, (double)pPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    private static void handleServerProcessing(Level pLevel, BlockPos pPos, BlockState pState, NexusAltarBlockEntity pBlockEntity) {
        if (pLevel.f_46443_ || !pBlockEntity.isProcessing || pBlockEntity.processingTimer <= 0) {
            return;
        }
        --pBlockEntity.processingTimer;
        int currentTimer = pBlockEntity.processingTimer;
        int finalSoundTick = 60;
        float sporadicVolumeMin = 0.15f;
        float sporadicVolumeMax = 0.2f;
        int SPORADIC_SOUND_TICK_INTERVAL_AVERAGE = 20;
        if (currentTimer == 60) {
            pLevel.m_5594_(null, pPos, (SoundEvent)SoundRegistry.INFUSION_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (currentTimer > 60 && currentTimer < 200 && pLevel.f_46441_.m_188503_(20) == 0) {
            float randomVolume = 0.15f + pLevel.f_46441_.m_188501_() * 0.049999997f;
            float randomPitch = 0.7f + pLevel.f_46441_.m_188501_() * 0.2f;
            pLevel.m_5594_(null, pPos, (SoundEvent)SoundRegistry.INFUSION_START.get(), SoundSource.BLOCKS, randomVolume, randomPitch);
        }
        if (pBlockEntity.processingTimer % 10 == 0) {
            pBlockEntity.syncData();
        }
        if (pBlockEntity.processingTimer <= 0) {
            pBlockEntity.finishTransformationRitual(pState);
        }
        pBlockEntity.m_6596_();
    }

    private void finishTransformationRitual(BlockState pState) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        Item outputItem = null;
        if (this.itemToProcess.m_150930_((Item)ItemRegistry.NECKLACE_OF_SORROW.get())) {
            outputItem = (Item)ItemRegistry.DEATH_STONE.get();
        } else if (this.itemToProcess.m_150930_((Item)ItemRegistry.ALTAR_OFFERING.get())) {
            outputItem = (Item)ItemRegistry.LIFE_STONE.get();
        } else if (this.itemToProcess.m_150930_((Item)ItemRegistry.SCORCHED_NETHER_CORE.get())) {
            outputItem = (Item)ItemRegistry.EARTH_STONE.get();
        }
        this.isProcessing = false;
        this.processingTimer = 0;
        this.itemToProcess = ItemStack.f_41583_;
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)((BlockState)pState.m_61124_((Property)NexusAltarBlock.ACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NexusAltarBlock.HAS_ITEM, (Comparable)Boolean.valueOf(false)), 3);
        if (outputItem != null) {
            ServerLevel serverLevel;
            Level level;
            ItemStack outputStack = new ItemStack((ItemLike)outputItem);
            ItemEntity outputEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.1, (double)this.f_58858_.m_123343_() + 0.5, outputStack);
            outputEntity.m_20256_(Vec3.f_82478_);
            outputEntity.m_32010_(10);
            this.f_58857_.m_7967_((Entity)outputEntity);
            if (outputItem == ItemRegistry.LIFE_STONE.get() && (level = this.f_58857_) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                this.spawnCorpseVillagers(serverLevel, this.f_58858_);
            }
            if (outputItem == ItemRegistry.EARTH_STONE.get() && (level = this.f_58857_) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                this.spawnScylla(serverLevel, this.f_58858_);
            }
        }
        double effectX = (double)this.f_58858_.m_123341_() + 0.5;
        double effectY = (double)this.f_58858_.m_123342_() + 1.0;
        double effectZ = (double)this.f_58858_.m_123343_() + 0.5;
        ShockwaveParticleOptions shockOptions = new ShockwaveParticleOptions(EARTH_PARTICLE_COLOR, 1.44f, false, "");
        BlastwaveParticleOptions blastOptions = new BlastwaveParticleOptions(WHITE_COLOR, 1.43f);
        this.f_58857_.m_7106_((ParticleOptions)shockOptions, effectX, effectY, effectZ, 0.0, 0.0, 0.0);
        this.f_58857_.m_7106_((ParticleOptions)blastOptions, effectX, effectY, effectZ, 0.0, 0.0, 0.0);
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11860_, SoundSource.BLOCKS, 1.2f, 1.0f);
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11738_, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123747_, effectX, effectY, effectZ, 0.0, 0.0, 0.0);
        this.m_6596_();
        this.syncData();
    }

    private void spawnScylla(ServerLevel serverLevel, BlockPos centerPos) {
        Optional entityTypeOptional = EntityType.m_20632_((String)"cataclysm:scylla");
        if (entityTypeOptional.isEmpty()) {
            Otherworld.LOGGER.error("EntityType 'cataclysm:scylla' not found!");
            return;
        }
        EntityType scyllaType = (EntityType)entityTypeOptional.get();
        double x = (double)centerPos.m_123341_() + 0.5;
        double y = centerPos.m_123342_() + 1;
        double z = (double)centerPos.m_123343_() + 0.5;
        Entity scylla = scyllaType.m_20615_((Level)serverLevel);
        if (scylla != null) {
            scylla.m_6034_(x, y, z);
            serverLevel.m_7967_(scylla);
            serverLevel.m_5594_(null, centerPos, SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
            serverLevel.m_5594_(null, centerPos, SoundEvents.f_12090_, SoundSource.WEATHER, 1.0f, 1.0f);
            Otherworld.LOGGER.info("Spawned cataclysm:scylla at ({}, {}, {})", (Object)x, (Object)y, (Object)z);
        } else {
            Otherworld.LOGGER.error("Failed to create cataclysm:scylla entity!");
        }
    }

    private void spawnCorpseVillagers(ServerLevel serverLevel, BlockPos centerPos) {
        Optional entityTypeOptional = EntityType.m_20632_((String)"eeeabsmobs:corpse_villager");
        if (entityTypeOptional.isEmpty()) {
            Otherworld.LOGGER.error("EntityType 'eeeabsmobs:corpse_villager' not found!");
            return;
        }
        EntityType corpseVillagerType = (EntityType)entityTypeOptional.get();
        for (int i = 0; i < 5; ++i) {
            double angle = (double)i * 1.2566370614359172;
            double x = (double)centerPos.m_123341_() + 0.5 + Math.cos(angle) * 3.0;
            double y = centerPos.m_123342_() + 1;
            double z = (double)centerPos.m_123343_() + 0.5 + Math.sin(angle) * 3.0;
            Entity entity = corpseVillagerType.m_20615_((Level)serverLevel);
            if (entity instanceof Mob) {
                Mob villager = (Mob)entity;
                villager.m_6034_(x, y, z);
                villager.m_21553_(true);
                villager.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
                if (i == 1) {
                    ItemStack book = StoryItemInjectEvents.createWarlockChallenge();
                    villager.m_8061_(EquipmentSlot.MAINHAND, book);
                }
                if (i == 2) {
                    Item gulingEyeItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("eeeabsmobs", "bloody_altar_eye"));
                    if (gulingEyeItem != null) {
                        villager.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)gulingEyeItem));
                    } else {
                        Otherworld.LOGGER.warn("Could not find item 'eeeabsmobs:bloody_altar_eye' to give to spawned villager.");
                    }
                }
                serverLevel.m_7967_((Entity)villager);
                continue;
            }
            Otherworld.LOGGER.error("Failed to create eeeabsmobs:corpse_villager entity!");
        }
    }

    @Nullable
    private static ParticleOptions getThematicParticleForItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        Item item = stack.m_41720_();
        if (item == ItemRegistry.NECKLACE_OF_SORROW.get() || item == ItemRegistry.DEATH_STONE.get()) {
            return ParticleTypes.f_123746_;
        }
        if (item == ItemRegistry.ALTAR_OFFERING.get() || item == ItemRegistry.LIFE_STONE.get()) {
            return (ParticleOptions)ParticleRegistry.WISP_PARTICLE.get();
        }
        if (item == ItemRegistry.FIRE_STONE.get()) {
            return ParticleTypes.f_123744_;
        }
        if (item == ItemRegistry.ICE_STONE.get()) {
            return ParticleTypes.f_175821_;
        }
        if (item == ItemRegistry.LIGHTNING_STONE.get()) {
            return (ParticleOptions)ParticleRegistry.ELECTRICITY_PARTICLE.get();
        }
        if (item == ItemRegistry.EARTH_STONE.get() || item == ItemRegistry.SCORCHED_NETHER_CORE.get()) {
            return new ShockwaveParticleOptions(EARTH_PARTICLE_COLOR, 1.2f, false, "");
        }
        return null;
    }

    private static void spawnFogParticles(Level level, BlockPos pos, ParticleOptions particleData) {
        if (particleData instanceof ShockwaveParticleOptions) {
            return;
        }
        int particlesToSpawn = particleData == ParticleRegistry.WISP_PARTICLE.get() ? 5 : 3;
        float radius = 0.7f;
        float height = 0.5f;
        float speed = 0.08f;
        double centerX = (double)pos.m_123341_() + 0.5;
        double centerY = (double)pos.m_123342_() + 0.2;
        double centerZ = (double)pos.m_123343_() + 0.5;
        for (int i = 0; i < particlesToSpawn; ++i) {
            double angle = (double)level.f_46441_.m_188501_() * 2.0 * Math.PI;
            double xOffset = (double)radius * Math.cos(angle);
            double zOffset = (double)radius * Math.sin(angle);
            double yOffset = level.f_46441_.m_188501_() * height;
            double particleX = centerX + xOffset;
            double particleY = centerY + yOffset;
            double particleZ = centerZ + zOffset;
            double vx = -zOffset * (double)speed;
            double vz = xOffset * (double)speed;
            double vy = (double)(level.f_46441_.m_188501_() - 0.5f) * 0.02;
            level.m_7106_(particleData, particleX, particleY, particleZ, vx, vy, vz);
        }
    }

    private static void spawnBeamParticles(Level level, BlockPos pos) {
        double centerX = level.f_46441_.m_188500_() * 0.4 - 0.2 + (double)pos.m_123341_() + 0.5;
        double centerY = (double)pos.m_123342_() + 1.0;
        double centerZ = level.f_46441_.m_188500_() * 0.4 - 0.2 + (double)pos.m_123343_() + 0.5;
        for (int i = 0; i < 1; ++i) {
            double particleX = centerX;
            double particleY = centerY + level.f_46441_.m_188500_() * 0.3;
            double particleZ = centerZ;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, particleX, particleY, particleZ, 0.0, 0.15 + level.f_46441_.m_188500_() * 0.05, 0.0);
        }
    }

    private static void spawnZapParticles(Level level, BlockPos pos) {
        double startY = (double)pos.m_123342_() + 0.1;
        double targetY = (double)pos.m_123342_() + 0.6;
        double centerX = (double)pos.m_123341_() + 0.5;
        double centerZ = (double)pos.m_123343_() + 0.5;
        for (int i = 0; i < 1; ++i) {
            double angle = (double)level.f_46441_.m_188501_() * 2.0 * Math.PI;
            double startXOffset = 0.6 * Math.cos(angle);
            double startZOffset = 0.6 * Math.sin(angle);
            double startX = centerX + startXOffset;
            double startZ = centerZ + startZOffset;
            double targetXOffset = 0.5 * Math.cos(angle);
            double targetZOffset = 0.5 * Math.sin(angle);
            double targetX = centerX + targetXOffset;
            double targetZ = centerZ + targetZOffset;
            ZapParticleOption zapOptions = new ZapParticleOption(new Vec3(targetX, targetY, targetZ));
            level.m_7106_((ParticleOptions)zapOptions, startX, startY, startZ, 0.0, 0.0, 0.0);
        }
    }

    private static void spawnGrandRitualLockedParticles(Level level, BlockPos pos) {
        if (com.idark.valoria.client.particle.ParticleRegistry.SMOKE != null && com.idark.valoria.client.particle.ParticleRegistry.SMOKE.get() != null) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 1.8;
            double z = (double)pos.m_123343_() + 0.5;
            GenericParticleOptions smokeOptions = new GenericParticleOptions((ParticleType)com.idark.valoria.client.particle.ParticleRegistry.SMOKE.get());
            level.m_7106_((ParticleOptions)smokeOptions, x, y, z, 0.0, 0.2, 0.0);
        } else {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 2.0;
            double z = (double)pos.m_123343_() + 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 0.0, 0.1, 0.0);
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128359_(RITUAL_TYPE_TAG, this.ritualType);
        pTag.m_128379_(IS_PROCESSING_TAG, this.isProcessing);
        pTag.m_128405_(PROCESSING_TIMER_TAG, this.processingTimer);
        if (!this.itemToProcess.m_41619_()) {
            pTag.m_128365_(ITEM_STACK_TAG, (Tag)this.itemToProcess.m_41739_(new CompoundTag()));
        }
        pTag.m_128379_(IS_GRAND_RITUAL_LOCKED_TAG, this.isGrandRitualLocked);
        pTag.m_128379_(PRE_GRAND_RITUAL_SHAKE_TAG, this.preGrandRitualShake);
        pTag.m_128405_(PRE_GRAND_RITUAL_TIMER_TAG, this.preGrandRitualTimer);
        if (this.linkedPartnerPos != null) {
            pTag.m_128365_(LINKED_PARTNER_POS_TAG, (Tag)NbtUtils.m_129224_((BlockPos)this.linkedPartnerPos));
        }
        if (this.spawnedBossUUID != null) {
            pTag.m_128362_(SPAWNED_BOSS_UUID_TAG, this.spawnedBossUUID);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.ritualType = pTag.m_128425_(RITUAL_TYPE_TAG, 8) ? pTag.m_128461_(RITUAL_TYPE_TAG) : "default";
        this.isProcessing = pTag.m_128471_(IS_PROCESSING_TAG);
        this.processingTimer = pTag.m_128451_(PROCESSING_TIMER_TAG);
        this.itemToProcess = pTag.m_128441_(ITEM_STACK_TAG) ? ItemStack.m_41712_((CompoundTag)pTag.m_128469_(ITEM_STACK_TAG)) : ItemStack.f_41583_;
        this.isGrandRitualLocked = pTag.m_128471_(IS_GRAND_RITUAL_LOCKED_TAG);
        this.preGrandRitualShake = pTag.m_128471_(PRE_GRAND_RITUAL_SHAKE_TAG);
        this.preGrandRitualTimer = pTag.m_128451_(PRE_GRAND_RITUAL_TIMER_TAG);
        this.linkedPartnerPos = pTag.m_128441_(LINKED_PARTNER_POS_TAG) ? NbtUtils.m_129239_((CompoundTag)pTag.m_128469_(LINKED_PARTNER_POS_TAG)) : null;
        this.spawnedBossUUID = pTag.m_128403_(SPAWNED_BOSS_UUID_TAG) ? pTag.m_128342_(SPAWNED_BOSS_UUID_TAG) : null;
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void syncData() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.m_58900_();
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onAltarDeactivatedOrBroken() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.clearLinkAndUpdatePartner();
    }

    private void clearLinkAndUpdatePartner() {
        NexusAltarBlockEntity partnerAltar;
        BlockEntity partnerBE;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockPos oldPartnerPos = this.linkedPartnerPos;
        this.setLinkedPartner(null);
        if (oldPartnerPos != null && this.f_58857_.m_46749_(oldPartnerPos) && (partnerBE = this.f_58857_.m_7702_(oldPartnerPos)) instanceof NexusAltarBlockEntity && Objects.equals((partnerAltar = (NexusAltarBlockEntity)partnerBE).getLinkedPartnerPos(), this.f_58858_)) {
            partnerAltar.setLinkedPartner(null);
        }
    }

    public void checkAndTriggerGrandRitual() {
        ServerLevel serverLevel;
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.isGrandRitualLocked || this.preGrandRitualShake) {
            return;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46791_() == Difficulty.PEACEFUL) {
            for (ServerPlayer player : serverLevel.m_6907_()) {
                if (player.m_9236_().m_46472_() != DimensionRegistry.ELEMENTAL_NEXUS) continue;
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7cThe Nexus' puzzle cannot be completed in Peaceful difficulty!"), false);
                player.m_5661_((Component)Component.m_237113_((String)"\u00a77Please change the difficulty to continue."), false);
            }
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11738_, SoundSource.BLOCKS, 1.0f, 0.5f);
            return;
        }
        Map<String, NexusAltarBlockEntity> activePedestalTypes = this.findActivePedestals();
        for (Object altar : activePedestalTypes.values()) {
            if (!altar.isGrandRitualLocked() && !altar.isPreGrandRitualShake()) continue;
            return;
        }
        HashMap<NexusAltarBlockEntity, BlockPos> currentDesiredLinks = new HashMap<NexusAltarBlockEntity, BlockPos>();
        for (Map.Entry entry : PEDESTAL_LINKS.entrySet()) {
            String type2Str;
            String type1Str = (String)entry.getKey();
            if (type1Str.compareTo(type2Str = (String)entry.getValue()) >= 0) continue;
            NexusAltarBlockEntity altar1 = activePedestalTypes.get(type1Str);
            NexusAltarBlockEntity altar2 = activePedestalTypes.get(type2Str);
            if (altar1 == null || altar2 == null) continue;
            currentDesiredLinks.put(altar1, altar2.m_58899_());
            currentDesiredLinks.put(altar2, altar1.m_58899_());
        }
        for (Map.Entry entry : PEDESTAL_LOCATIONS.entrySet()) {
            NexusAltarBlockEntity oldPartnerAltar;
            BlockEntity oldPartnerBE;
            BlockPos newDesiredPartnerPos;
            NexusAltarBlockEntity currentAltarEntity;
            BlockPos currentPartnerPos;
            BlockEntity be;
            BlockPos currentAltarPos = (BlockPos)entry.getValue();
            if (!this.f_58857_.m_46749_(currentAltarPos) || !((be = this.f_58857_.m_7702_(currentAltarPos)) instanceof NexusAltarBlockEntity) || Objects.equals(currentPartnerPos = (currentAltarEntity = (NexusAltarBlockEntity)be).getLinkedPartnerPos(), newDesiredPartnerPos = (BlockPos)currentDesiredLinks.get((Object)currentAltarEntity))) continue;
            if (currentPartnerPos != null && (oldPartnerBE = this.f_58857_.m_7702_(currentPartnerPos)) instanceof NexusAltarBlockEntity && Objects.equals((oldPartnerAltar = (NexusAltarBlockEntity)oldPartnerBE).getLinkedPartnerPos(), currentAltarEntity.m_58899_())) {
                oldPartnerAltar.setLinkedPartner(null);
            }
            currentAltarEntity.setLinkedPartner(newDesiredPartnerPos);
        }
        boolean allSixActive = ALL_PEDESTAL_TYPES.stream().allMatch(activePedestalTypes::containsKey);
        if (allSixActive) {
            boolean bl;
            for (String pedestalType : ALL_PEDESTAL_TYPES) {
                NexusAltarBlockEntity altar = activePedestalTypes.get(pedestalType);
                if (altar != null && !altar.isPreGrandRitualShake() && !altar.isGrandRitualLocked()) continue;
                return;
            }
            boolean bl2 = false;
            for (String pedestalType : ALL_PEDESTAL_TYPES) {
                NexusAltarBlockEntity altar = activePedestalTypes.get(pedestalType);
                altar.preGrandRitualShake = true;
                altar.preGrandRitualTimer = 200;
                altar.m_6596_();
                altar.syncData();
                bl = true;
            }
            if (bl && this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.GRAND_CHANNEL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private void executeGrandRitualBoomSequence() {
        Level level;
        if (this.f_58857_ == null || !((level = this.f_58857_) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.m_46791_() == Difficulty.PEACEFUL) {
            Otherworld.LOGGER.warn("Grand ritual reached boom sequence in Peaceful mode - aborting!");
            this.preGrandRitualShake = false;
            this.preGrandRitualTimer = 0;
            this.m_6596_();
            this.syncData();
            return;
        }
        Map<String, NexusAltarBlockEntity> pedestalsForBoom = this.findActivePedestals();
        boolean allReadyForBoom = ALL_PEDESTAL_TYPES.stream().allMatch(type -> {
            NexusAltarBlockEntity altar = (NexusAltarBlockEntity)((Object)((Object)pedestalsForBoom.get(type)));
            return altar != null && !altar.isPreGrandRitualShake() && altar.getPreGrandRitualTimer() <= 0 && !altar.isGrandRitualLocked();
        });
        if (!allReadyForBoom) {
            this.preGrandRitualShake = false;
            this.preGrandRitualTimer = 0;
            this.m_6596_();
            this.syncData();
            return;
        }
        ArrayList<NexusAltarBlockEntity> successfullyProcessedAltars = new ArrayList<NexusAltarBlockEntity>();
        for (String pedestalType : ALL_PEDESTAL_TYPES) {
            NexusAltarBlockEntity altar = pedestalsForBoom.get(pedestalType);
            if (altar == null) continue;
            altar.isGrandRitualLocked = true;
            altar.itemToProcess = ItemStack.f_41583_;
            BlockState currentState = altar.m_58900_();
            serverLevel.m_7731_(altar.f_58858_, (BlockState)((BlockState)currentState.m_61124_((Property)NexusAltarBlock.ACTIVATED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NexusAltarBlock.HAS_ITEM, (Comparable)Boolean.valueOf(false)), 3);
            altar.preGrandRitualShake = false;
            altar.preGrandRitualTimer = 0;
            altar.m_6596_();
            altar.syncData();
            successfullyProcessedAltars.add(altar);
        }
        for (NexusAltarBlockEntity altar : successfullyProcessedAltars) {
            serverLevel.m_5594_(null, altar.m_58899_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, 0.6f);
            serverLevel.m_5594_(null, altar.m_58899_(), SoundEvents.f_11860_, SoundSource.BLOCKS, 4.0f, 0.7f);
            serverLevel.m_5594_(null, altar.m_58899_(), SoundEvents.f_11894_, SoundSource.HOSTILE, 4.0f, 0.8f);
        }
        BlockPos bossSpawnPos = new BlockPos(50, 66, 52);
        Optional entityTypeOptional = EntityType.m_20632_((String)"soulsweapons:moonknight");
        if (entityTypeOptional.isPresent()) {
            EntityType moonKnightType = (EntityType)entityTypeOptional.get();
            Entity entity = moonKnightType.m_20615_((Level)serverLevel);
            if (entity instanceof Mob) {
                Mob spawnedBoss = (Mob)entity;
                spawnedBoss.m_6034_((double)bossSpawnPos.m_123341_() + 0.5, (double)bossSpawnPos.m_123342_(), (double)bossSpawnPos.m_123343_() + 0.5);
                serverLevel.m_7967_((Entity)spawnedBoss);
                UUID bossUUID = spawnedBoss.m_20148_();
                ActiveRitualBossTracker tracker = ActiveRitualBossTracker.get(serverLevel);
                tracker.addTrackedBoss(bossUUID, bossSpawnPos);
                for (NexusAltarBlockEntity altar : successfullyProcessedAltars) {
                    altar.spawnedBossUUID = bossUUID;
                    altar.m_6596_();
                    altar.syncData();
                }
                Otherworld.LOGGER.info("Spawned Moon Knight ({}) for ritual, tracked with key pos {}. Altars remain locked.", (Object)bossUUID, (Object)bossSpawnPos);
                ResourceLocation elementalMasteryAdvId = new ResourceLocation("otherworld", "story/elemental_mastery");
                Advancement elementalMasteryAdv = serverLevel.m_7654_().m_129889_().m_136041_(elementalMasteryAdvId);
                if (elementalMasteryAdv != null) {
                    for (ServerPlayer playerInDimension : serverLevel.m_6907_()) {
                        if (playerInDimension.m_9236_().m_46472_() != DimensionRegistry.ELEMENTAL_NEXUS || playerInDimension.m_8960_().m_135996_(elementalMasteryAdv).m_8193_()) continue;
                        playerInDimension.m_8960_().m_135988_(elementalMasteryAdv, "unlocked");
                        Otherworld.LOGGER.debug("Granted advancement '{}' to player {}.", (Object)elementalMasteryAdvId, (Object)playerInDimension.m_7755_().getString());
                    }
                } else {
                    Otherworld.LOGGER.warn("Could not find advancement: {}", (Object)elementalMasteryAdvId);
                }
            } else {
                Otherworld.LOGGER.error("Failed to create soulsweapons:moonknight entity!");
                this.unlockFailedRitualAltars(successfullyProcessedAltars);
            }
        } else {
            Otherworld.LOGGER.error("EntityType 'soulsweapons:moonknight' not found!");
            this.unlockFailedRitualAltars(successfullyProcessedAltars);
        }
    }

    private void unlockFailedRitualAltars(List<NexusAltarBlockEntity> altars) {
        for (NexusAltarBlockEntity altar : altars) {
            altar.isGrandRitualLocked = false;
            altar.spawnedBossUUID = null;
            altar.m_6596_();
            altar.syncData();
        }
        Otherworld.LOGGER.warn("Ritual altars unlocked due to boss spawn failure.");
    }

    private Map<String, NexusAltarBlockEntity> findActivePedestals() {
        HashMap<String, NexusAltarBlockEntity> foundActivePedestals = new HashMap<String, NexusAltarBlockEntity>();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return foundActivePedestals;
        }
        for (Map.Entry<String, BlockPos> entry : PEDESTAL_LOCATIONS.entrySet()) {
            NexusAltarBlockEntity altar;
            BlockEntity be;
            String expectedType = entry.getKey();
            BlockPos pedestalPos = entry.getValue();
            if (!this.f_58857_.m_46749_(pedestalPos) || !((be = this.f_58857_.m_7702_(pedestalPos)) instanceof NexusAltarBlockEntity) || !(altar = (NexusAltarBlockEntity)be).getRitualType().equals(expectedType) || !((Boolean)altar.m_58900_().m_61143_((Property)NexusAltarBlock.ACTIVATED)).booleanValue() || altar.getItemToProcess().m_41619_()) continue;
            foundActivePedestals.put(expectedType, altar);
        }
        return foundActivePedestals;
    }

    public static int getPreRitualShakeDuration() {
        return 200;
    }

    public static int getTransformationDuration() {
        return 200;
    }

    public void setLinkedPartner(@Nullable BlockPos partnerPos) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (Objects.equals(this.linkedPartnerPos, partnerPos)) {
            return;
        }
        this.linkedPartnerPos = partnerPos;
        this.m_6596_();
        this.syncData();
    }

    @Nullable
    public UUID getSpawnedBossUUID() {
        return this.spawnedBossUUID;
    }

    public void setRitualBossDefeatedAndUnlock() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.spawnedBossUUID = null;
        this.isGrandRitualLocked = false;
        BlockState currentState = this.m_58900_();
        if (((Boolean)currentState.m_61143_((Property)NexusAltarBlock.ACTIVATED)).booleanValue()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)currentState.m_61124_((Property)NexusAltarBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)), 3);
        }
        this.m_6596_();
        this.syncData();
    }

    private static void unlockAllGrandRitualAltars(ServerLevel level, UUID bossUUID) {
        for (BlockPos altarPos : PEDESTAL_LOCATIONS.values()) {
            NexusAltarBlockEntity altarEntity;
            BlockEntity be;
            if (!level.m_46749_(altarPos) || !((be = level.m_7702_(altarPos)) instanceof NexusAltarBlockEntity) || !bossUUID.equals((altarEntity = (NexusAltarBlockEntity)be).getSpawnedBossUUID()) || !altarEntity.isGrandRitualLocked()) continue;
            altarEntity.setRitualBossDefeatedAndUnlock();
            Otherworld.LOGGER.debug("Unlocked grand ritual altar at {} due to missing boss", (Object)altarPos);
        }
        ActiveRitualBossTracker tracker = ActiveRitualBossTracker.get(level);
        if (tracker.isBossTracked(bossUUID)) {
            tracker.removeTrackedBoss(bossUUID);
            Otherworld.LOGGER.debug("Removed missing boss {} from ritual tracker", (Object)bossUUID);
        }
    }
}

