/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.block;

import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.block.entity.NexusReturnPortalBlockEntity;
import dev.muon.otherworld.dimension.DimensionRegistry;
import dev.muon.otherworld.dimension.EndPortalFinder;
import dev.muon.otherworld.world.saved_data.EndPortalLinks;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class NexusReturnPortalBlock
extends BaseEntityBlock {
    public NexusReturnPortalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public static BlockBehaviour.Properties properties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60910_().m_60953_(state -> 15).m_60913_(-1.0f, 3600000.0f).m_60918_(SoundType.f_56744_).m_222994_();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new NexusReturnPortalBlockEntity(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        for (int j = 0; j < 8; ++j) {
            double d0 = (double)pPos.m_123341_() + pRandom.m_188500_();
            double d1 = (double)pPos.m_123342_() + pRandom.m_188500_();
            double d2 = (double)pPos.m_123343_() + pRandom.m_188500_();
            double d3 = (pRandom.m_188500_() - 0.5) * 0.5;
            double d4 = (pRandom.m_188500_() - 0.5) * 0.5;
            double d5 = (pRandom.m_188500_() - 0.5) * 0.5;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pLevel.f_46443_ && pEntity.m_6072_() && pLevel.m_46472_() == DimensionRegistry.ELEMENTAL_NEXUS && pEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pEntity;
            ServerLevel overworldLevel = pLevel.m_7654_().m_129880_(Level.f_46428_);
            if (overworldLevel == null) {
                Otherworld.LOGGER.error("Could not find Overworld dimension to teleport player {}!", (Object)player.m_7755_().getString());
                return;
            }
            BlockPos targetPos = null;
            if (pLevel instanceof ServerLevel) {
                ServerLevel nexusLevel = (ServerLevel)pLevel;
                EndPortalLinks links = EndPortalLinks.get(nexusLevel);
                BlockPos entrancePortalPos = links.getPortalPosition(player.m_20148_());
                if (entrancePortalPos != null) {
                    Otherworld.LOGGER.debug("Player {} has stored portal entrance at {}, finding/creating portal nearby", (Object)player.m_7755_().getString(), (Object)entrancePortalPos);
                    Optional<BlockPos> portalPos = EndPortalFinder.findOrCreatePortal(overworldLevel, entrancePortalPos);
                    if (portalPos.isPresent()) {
                        Optional<BlockPos> safePos = EndPortalFinder.findSafeSpawnNearPortal(overworldLevel, portalPos.get());
                        if (safePos.isPresent()) {
                            targetPos = safePos.get();
                            Otherworld.LOGGER.debug("Teleporting player {} to safe position {} near End Portal at {} (linked to entrance at {})", (Object)player.m_7755_().getString(), (Object)targetPos, (Object)portalPos.get(), (Object)entrancePortalPos);
                        } else {
                            Otherworld.LOGGER.warn("Could not find safe spawn position near portal at {} for player {}, falling back to respawn/spawn", (Object)portalPos.get(), (Object)player.m_7755_().getString());
                            targetPos = null;
                        }
                    } else {
                        Otherworld.LOGGER.warn("Failed to find/create portal near {}, falling back to respawn/spawn", (Object)entrancePortalPos);
                    }
                } else {
                    Otherworld.LOGGER.debug("Player {} has no stored portal entrance position", (Object)player.m_7755_().getString());
                }
            }
            if (targetPos == null) {
                BlockPos respawnPos = player.m_8961_();
                if (respawnPos != null && player.m_8963_() == Level.f_46428_) {
                    Optional preciseRespawn = ServerPlayer.m_36130_((ServerLevel)overworldLevel, (BlockPos)respawnPos, (float)player.m_8962_(), (boolean)player.m_8964_(), (boolean)true);
                    if (preciseRespawn.isPresent()) {
                        targetPos = BlockPos.m_274446_((Position)((Position)preciseRespawn.get()));
                        Otherworld.LOGGER.debug("Found valid respawn point for {} at {}", (Object)player.m_7755_().getString(), (Object)targetPos);
                    } else {
                        Otherworld.LOGGER.debug("Respawn point for {} at {} is invalid, using world spawn.", (Object)player.m_7755_().getString(), (Object)respawnPos);
                        player.m_9158_(Level.f_46428_, null, 0.0f, false, false);
                    }
                } else {
                    Otherworld.LOGGER.debug("Player {} has no valid Overworld respawn point set.", (Object)player.m_7755_().getString());
                }
            }
            if (targetPos == null) {
                targetPos = overworldLevel.m_220360_();
                Otherworld.LOGGER.debug("Using Overworld spawn point {} for {}", (Object)targetPos, (Object)player.m_7755_().getString());
            }
            final BlockPos finalTargetPos = targetPos;
            player.changeDimension(overworldLevel, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    Entity repositioned = repositionEntity.apply(false);
                    repositioned.m_6021_((double)finalTargetPos.m_123341_() + 0.5, (double)finalTargetPos.m_123342_() + 1.0, (double)finalTargetPos.m_123343_() + 0.5);
                    return repositioned;
                }
            });
        }
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return ItemStack.f_41583_;
    }
}

