/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.block;

import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.block.entity.NexusExitPortalBlockEntity;
import dev.muon.otherworld.dimension.DimensionRegistry;
import dev.muon.otherworld.event.ForgeEventHandlers;
import dev.muon.otherworld.network.BossNarrationPacketHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class NexusExitPortalBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final ResourceLocation NEXUS_ESCAPE_ADVANCEMENT = Otherworld.loc("story/nexus_escape");

    public NexusExitPortalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public static BlockBehaviour.Properties properties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60910_().m_60953_(state -> 10).m_60978_(-1.0f).m_60918_(SoundType.f_56744_).m_222994_();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new NexusExitPortalBlockEntity(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        for (int j = 0; j < 8; ++j) {
            double d0 = (double)pPos.m_123341_() + pRandom.m_188500_();
            double d1 = (double)pPos.m_123342_() + pRandom.m_188500_();
            double d2 = (double)pPos.m_123343_() + pRandom.m_188500_();
            double d3 = (pRandom.m_188500_() - 0.5) * 0.5;
            double d4 = (pRandom.m_188500_() - 0.5) * 0.5;
            double d5 = (pRandom.m_188500_() - 0.5) * 0.5;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pLevel.f_46443_ && pEntity.m_6072_() && pLevel.m_46472_() == DimensionRegistry.ELEMENTAL_NEXUS) {
            if (pEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pEntity;
                MinecraftServer server = pLevel.m_7654_();
                if (server != null) {
                    Advancement advancement = server.m_129889_().m_136041_(NEXUS_ESCAPE_ADVANCEMENT);
                    if (advancement != null) {
                        AdvancementProgress progress = serverPlayer.m_8960_().m_135996_(advancement);
                        if (!progress.m_8193_()) {
                            ForgeEventHandlers.addPlayerToNarration(serverPlayer);
                            BossNarrationPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new BossNarrationPacketHandler.OpenBossNarrationScreenPacket());
                            for (String criterion : progress.m_8219_()) {
                                serverPlayer.m_8960_().m_135988_(advancement, criterion);
                            }
                            return;
                        }
                    } else {
                        Otherworld.LOGGER.warn("Could not find advancement: {}", (Object)NEXUS_ESCAPE_ADVANCEMENT);
                    }
                    ServerLevel endLevel = server.m_129880_(Level.f_46430_);
                    if (endLevel != null) {
                        serverPlayer.m_5489_(endLevel);
                    } else {
                        Otherworld.LOGGER.error("Could not find The End dimension to teleport entity {}!", (Object)pEntity);
                    }
                }
            } else {
                MinecraftServer server = pLevel.m_7654_();
                if (server != null) {
                    ServerLevel endLevel = server.m_129880_(Level.f_46430_);
                    if (endLevel != null) {
                        pEntity.m_5489_(endLevel);
                    } else {
                        Otherworld.LOGGER.error("Could not find The End dimension to teleport entity {}!", (Object)pEntity);
                    }
                } else {
                    Otherworld.LOGGER.error("Tried to teleport {} into the End but Server was null", (Object)pEntity);
                }
            }
        }
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return ItemStack.f_41583_;
    }
}

