/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.block;

import dev.muon.otherworld.Otherworld;
import dev.muon.otherworld.block.entity.BlockEntityRegistry;
import dev.muon.otherworld.block.entity.NexusAltarBlockEntity;
import dev.muon.otherworld.item.ItemRegistry;
import dev.shadowsoffire.apotheosis.Apoth;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NexusAltarBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final BooleanProperty ACTIVATED = BooleanProperty.m_61465_((String)"activated");
    public static final BooleanProperty HAS_ITEM = BooleanProperty.m_61465_((String)"has_item");
    private static final int DEATH_STONE_RITUAL_XP_COST = 30;

    public NexusAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ACTIVATED, HAS_ITEM});
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new NexusAltarBlockEntity(pPos, pState);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof NexusAltarBlockEntity)) {
            return InteractionResult.FAIL;
        }
        NexusAltarBlockEntity altarEntity = (NexusAltarBlockEntity)blockEntity;
        if (altarEntity.isGrandRitualLocked()) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"block.otherworld.nexus_altar.grand_ritual_locked").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        ItemStack handStack = pPlayer.m_21120_(pHand);
        ItemStack altarItem = altarEntity.getItemToProcess();
        String altarRitualType = altarEntity.getRitualType().toLowerCase();
        if (handStack.m_41619_() && !altarItem.m_41619_()) {
            if (altarEntity.isProcessing() || altarEntity.isPreGrandRitualShake()) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"block.otherworld.nexus_altar.processing_active").m_130940_(ChatFormatting.YELLOW), true);
                return InteractionResult.FAIL;
            }
            pPlayer.m_21008_(pHand, altarItem.m_41777_());
            altarEntity.setPedestalItem(ItemStack.f_41583_);
            pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false)), 3);
            pLevel.m_5594_(null, pPos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, 1.0f);
            altarEntity.onAltarDeactivatedOrBroken();
            altarEntity.checkAndTriggerGrandRitual();
            return InteractionResult.SUCCESS;
        }
        if (!handStack.m_41619_() && altarItem.m_41619_()) {
            if (altarEntity.isProcessing() || altarEntity.isPreGrandRitualShake()) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"block.otherworld.nexus_altar.processing_active").m_130940_(ChatFormatting.YELLOW), true);
                return InteractionResult.FAIL;
            }
            if (this.isItemAcceptedByAltar(handStack.m_41720_(), altarRitualType)) {
                pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HAS_ITEM, (Comparable)Boolean.valueOf(true)), 3);
                pLevel.m_5594_(null, pPos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ItemStack itemToPlace = handStack.m_41777_();
                itemToPlace.m_41764_(1);
                if (altarRitualType.equals("death_transformation") || altarRitualType.equals("life_transformation") || altarRitualType.equals("earth_transformation")) {
                    altarEntity.startTransformationRitual(itemToPlace);
                } else {
                    altarEntity.setPedestalItem(itemToPlace);
                    altarEntity.checkAndTriggerGrandRitual();
                }
                if (!pPlayer.m_150110_().f_35937_) {
                    handStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            pPlayer.m_5661_((Component)Component.m_237115_((String)"message.otherworld.altar.mismatch").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (!handStack.m_41619_() && !altarItem.m_41619_()) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"message.otherworld.altar.occupied").m_130940_(ChatFormatting.YELLOW), true);
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private boolean isItemAcceptedByAltar(Item item, String ritualType) {
        switch (ritualType.toLowerCase()) {
            case "death_transformation": {
                return item == ItemRegistry.NECKLACE_OF_SORROW.get();
            }
            case "life_transformation": {
                return item == ItemRegistry.ALTAR_OFFERING.get();
            }
            case "earth_transformation": {
                return item == ItemRegistry.SCORCHED_NETHER_CORE.get();
            }
            case "fire_pedestal": {
                return item == ItemRegistry.FIRE_STONE.get();
            }
            case "ice_pedestal": {
                return item == ItemRegistry.ICE_STONE.get();
            }
            case "lightning_pedestal": {
                return item == ItemRegistry.LIGHTNING_STONE.get();
            }
            case "earth_pedestal": {
                return item == ItemRegistry.EARTH_STONE.get();
            }
            case "life_pedestal": {
                return item == ItemRegistry.LIFE_STONE.get();
            }
            case "death_pedestal": {
                return item == ItemRegistry.DEATH_STONE.get();
            }
        }
        return false;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof NexusAltarBlockEntity) {
                NexusAltarBlockEntity altarEntity = (NexusAltarBlockEntity)blockEntity;
                ItemStack itemToDrop = altarEntity.getItemToProcess();
                if (!itemToDrop.m_41619_()) {
                    Block.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)itemToDrop.m_41777_());
                }
                altarEntity.onAltarDeactivatedOrBroken();
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        NexusAltarBlockEntity altarEntity;
        BlockPos partnerPos;
        BlockEntity be;
        super.m_214162_(pState, pLevel, pPos, pRandom);
        if (!pLevel.f_46443_) {
            return;
        }
        if (((Boolean)pState.m_61143_((Property)ACTIVATED)).booleanValue() && (be = pLevel.m_7702_(pPos)) instanceof NexusAltarBlockEntity && (partnerPos = (altarEntity = (NexusAltarBlockEntity)be).getLinkedPartnerPos()) != null) {
            NexusAltarBlockEntity partnerAltarEntity;
            BlockEntity partnerBE = pLevel.m_7702_(partnerPos);
            boolean partnerIsValid = false;
            if (partnerBE instanceof NexusAltarBlockEntity && ((Boolean)(partnerAltarEntity = (NexusAltarBlockEntity)partnerBE).m_58900_().m_61143_((Property)ACTIVATED)).booleanValue() && pPos.equals((Object)partnerAltarEntity.getLinkedPartnerPos())) {
                partnerIsValid = true;
            }
            if (!partnerIsValid) {
                return;
            }
            Vec3 currentAltarEffectSource = Vec3.m_82512_((Vec3i)pPos).m_82520_(0.0, 0.75, 0.0);
            Vec3 partnerAltarEffectTarget = Vec3.m_82512_((Vec3i)partnerPos).m_82520_(0.0, 0.75, 0.0);
            Vec3 overallDirectionVec = partnerAltarEffectTarget.m_82546_(currentAltarEffectSource);
            double distance = overallDirectionVec.m_82553_();
            if (distance < 0.1) {
                return;
            }
            Vec3 normalizedOverallDirection = overallDirectionVec.m_82541_();
            double particleSpawnInterval = 3.0;
            int numParticlesAlongLine = (int)(distance / particleSpawnInterval);
            if (numParticlesAlongLine <= 0) {
                numParticlesAlongLine = 1;
            }
            double particleSpeed = 6.0;
            if (pRandom.m_188503_(20) == 0) {
                Otherworld.LOGGER.debug("[Altar @ {}] Spawning particles along line to {} ({} points, interval {}). Speed: {}", (Object)pPos, (Object)partnerPos, (Object)numParticlesAlongLine, (Object)String.format("%.2f", distance), (Object)particleSpeed);
            }
            for (int i = 0; i <= numParticlesAlongLine; ++i) {
                double fractionAlong = (double)i / (double)numParticlesAlongLine;
                Vec3 spawnOriginPoint = currentAltarEffectSource.m_82549_(overallDirectionVec.m_82490_(fractionAlong));
                int particlesPerSpawnPoint = 2;
                for (int j = 0; j < particlesPerSpawnPoint; ++j) {
                    double offsetX = (pRandom.m_188500_() - 0.5) * 0.35;
                    double offsetY = (pRandom.m_188500_() - 0.5) * 0.35;
                    double offsetZ = (pRandom.m_188500_() - 0.5) * 0.35;
                    double spawnX = spawnOriginPoint.m_7096_() + offsetX;
                    double spawnY = spawnOriginPoint.m_7098_() + offsetY;
                    double spawnZ = spawnOriginPoint.m_7094_() + offsetZ;
                    double velX = normalizedOverallDirection.m_7096_() * particleSpeed;
                    double velY = normalizedOverallDirection.m_7098_() * particleSpeed;
                    double velZ = normalizedOverallDirection.m_7094_() * particleSpeed;
                    pLevel.m_7106_((ParticleOptions)Apoth.Particles.ENCHANT_END.get(), spawnX, spawnY, spawnZ, velX, velY, velZ);
                }
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return NexusAltarBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.NEXUS_ALTAR_BE.get()), NexusAltarBlockEntity::tick);
    }

    public static BlockBehaviour.Properties properties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60913_(-1.0f, 3600000.0f).m_60918_(SoundType.f_56742_).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)ACTIVATED) != false ? 13 : 0);
    }
}

