/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld.block;

import dev.muon.otherworld.block.NexusAltarBlock;
import dev.muon.otherworld.block.NexusExitPortalBlock;
import dev.muon.otherworld.block.NexusReturnPortalBlock;
import dev.muon.otherworld.block.PlacedIceHeartBlock;
import dev.muon.otherworld.item.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"otherworld");
    public static final RegistryObject<Block> PLACED_ICE_HEART = BlockRegistry.registerBlock("placed_ice_heart", () -> new PlacedIceHeartBlock(PlacedIceHeartBlock.properties()));
    public static final RegistryObject<Block> NEXUS_ALTAR = BlockRegistry.registerBlock("nexus_altar", () -> new NexusAltarBlock(NexusAltarBlock.properties()));
    public static final RegistryObject<Block> NEXUS_EXIT_PORTAL = BlockRegistry.registerBlockWithoutItem("nexus_exit_portal", () -> new NexusExitPortalBlock(NexusExitPortalBlock.properties()));
    public static final RegistryObject<Block> NEXUS_RETURN_PORTAL = BlockRegistry.registerBlockWithoutItem("nexus_return_portal", () -> new NexusReturnPortalBlock(NexusReturnPortalBlock.properties()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ItemRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithoutItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

