/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworld;

import dev.muon.otherworld.block.BlockRegistry;
import dev.muon.otherworld.block.entity.BlockEntityRegistry;
import dev.muon.otherworld.config.OtherworldConfig;
import dev.muon.otherworld.data.AetherVillagesReplacerSource;
import dev.muon.otherworld.data.BOMDReplacerSource;
import dev.muon.otherworld.data.CataclysmReplacerSource;
import dev.muon.otherworld.dimension.DimensionRegistry;
import dev.muon.otherworld.item.ItemRegistry;
import dev.muon.otherworld.leveling.EnhancedEntityLevelingSettingsReloader;
import dev.muon.otherworld.leveling.LevelSyncHandler;
import dev.muon.otherworld.loot.LootModifierRegistry;
import dev.muon.otherworld.network.BossNarrationPacketHandler;
import dev.muon.otherworld.network.HeartTransformPacketHandler;
import dev.muon.otherworld.sound.SoundPacketHandler;
import dev.muon.otherworld.sound.SoundRegistry;
import dev.muon.otherworld.world.feature.ConfiguredFeatureRegistry;
import dev.muon.otherworld.world.feature.PlacedFeatureRegistry;
import dev.muon.otherworld.world.structure.StructureRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="otherworld")
public class Otherworld {
    public static final String MODID = "otherworld";
    public static final Logger LOGGER = LogManager.getLogger();

    public Otherworld(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        LOGGER.info("Otherworld Tweaks loading");
        OtherworldConfig.register();
        ItemRegistry.register(modEventBus);
        BlockRegistry.register(modEventBus);
        BlockEntityRegistry.register(modEventBus);
        DimensionRegistry.register();
        StructureRegistry.register(modEventBus);
        ConfiguredFeatureRegistry.register(modEventBus);
        PlacedFeatureRegistry.register(modEventBus);
        LootModifierRegistry.register(modEventBus);
        SoundRegistry.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListeners);
        context.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addReplacerPack);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LevelSyncHandler.init(event);
        SoundPacketHandler.register();
        BossNarrationPacketHandler.register();
        HeartTransformPacketHandler.register();
    }

    public void onAddReloadListeners(AddReloadListenerEvent event) {
        if (ModList.get().isLoaded("autoleveling")) {
            event.addListener((PreparableReloadListener)new EnhancedEntityLevelingSettingsReloader());
        }
    }

    private void addReplacerPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            event.addRepositorySource((RepositorySource)new AetherVillagesReplacerSource(PackType.SERVER_DATA));
            event.addRepositorySource((RepositorySource)new BOMDReplacerSource(PackType.SERVER_DATA));
            event.addRepositorySource((RepositorySource)new CataclysmReplacerSource(PackType.SERVER_DATA));
        }
    }

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }
}

