/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.client;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;

public class ClientUtils {
    public static final int ENTITY_CREATION_INTERVAL = 3000;
    private static final Map<String, LivingEntity> ENTITY_CACHE = new HashMap<String, LivingEntity>();
    private static final Map<String, Long> CREATION_TIMES = new HashMap<String, Long>();

    public static LivingEntity doRendering(EntityType<?> entityType, CompoundTag nbt, boolean input) {
        boolean refreshAllowed;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        Object key = CommonUtils.makeKey(entityType, input);
        if (nbt != null) {
            key = (String)key + "|" + nbt;
        }
        long currentTime = System.currentTimeMillis();
        LivingEntity entity = ENTITY_CACHE.get(key);
        long lastTime = CREATION_TIMES.getOrDefault(key, 0L);
        boolean bl = refreshAllowed = JustEnoughBreeding.isModLoaded("entity_model_features") == false && JustEnoughBreeding.isModLoaded("optifine") == false;
        if (entity == null) {
            entity = ClientUtils.createEntity(entityType, (Level)level);
            ENTITY_CACHE.put((String)key, entity);
            CREATION_TIMES.put((String)key, currentTime);
        } else if (refreshAllowed && currentTime - lastTime >= 3000L) {
            entity = ClientUtils.createEntity(entityType, (Level)level);
            ENTITY_CACHE.put((String)key, entity);
            CREATION_TIMES.put((String)key, currentTime);
        }
        return entity;
    }

    private static LivingEntity createEntity(EntityType<?> entityType, Level level) {
        LivingEntity entity = (LivingEntity)entityType.m_20615_(level);
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            tamable.m_7105_(true);
        }
        return entity;
    }

    public static LivingEntity doRendering(EntityType<?> entityType) {
        return ClientUtils.doRendering(entityType, null, false);
    }
}

