/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mes.world.structures;

import com.finndog.mes.modinit.MESStructures;
import com.finndog.mes.utils.GeneralUtils;
import com.finndog.mes.world.structures.GenericJigsawStructure;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class GenericNetherJigsawStructure
extends GenericJigsawStructure {
    public static final Codec<GenericNetherJigsawStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GenericNetherJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_y_range_from_start").forGetter(structure -> structure.allowedYRangeFromStart), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)ResourceLocation.f_135803_.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)0, (int)100).optionalFieldOf("ledge_offset_y").forGetter(structure -> structure.ledgeOffsetY), (App)StringRepresentable.m_216439_(LAND_SEARCH_DIRECTION::values).fieldOf("land_search_direction").forGetter(structure -> structure.searchDirection), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack)).apply((Applicative)instance, GenericNetherJigsawStructure::new));
    public final Optional<Integer> ledgeOffsetY;
    public final LAND_SEARCH_DIRECTION searchDirection;

    public GenericNetherJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, Optional<Integer> allowedYRangeFromStart, HeightProvider startHeight, boolean cannotSpawnInLiquid, Optional<Integer> biomeRadius, HashSet<ResourceLocation> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<Integer> ledgeOffsetY, LAND_SEARCH_DIRECTION searchDirection, boolean useBoundingBoxHack) {
        super(config, startPool, size, minYAllowed, maxYAllowed, allowedYRangeFromStart, startHeight, Optional.empty(), cannotSpawnInLiquid, Optional.empty(), Optional.empty(), biomeRadius, poolsThatIgnoreBoundaries, maxDistanceFromCenter, Optional.empty(), useBoundingBoxHack);
        this.ledgeOffsetY = ledgeOffsetY;
        this.searchDirection = searchDirection;
    }

    @Override
    protected void postLayoutAdjustments(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context, int offsetY, BlockPos blockpos, int topClipOff, int bottomClipOff, List<PoolElementStructurePiece> pieces) {
        GeneralUtils.centerAllPieces(blockpos, pieces);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        BlockPos placementPos = this.searchDirection == LAND_SEARCH_DIRECTION.HIGHEST_LAND ? GeneralUtils.getHighestLand(context.f_226622_(), context.f_226624_(), structurePiecesBuilder.m_192798_(), context.f_226629_(), !this.cannotSpawnInLiquid) : GeneralUtils.getLowestLand(context.f_226622_(), context.f_226624_(), structurePiecesBuilder.m_192798_(), context.f_226629_(), !this.cannotSpawnInLiquid);
        if (placementPos.m_123342_() >= GeneralUtils.getMaxTerrainLimit(context.f_226622_()) || placementPos.m_123342_() <= context.f_226622_().m_6337_() + 1) {
            int yDiff = context.f_226622_().m_6337_() + this.ledgeOffsetY.orElse(0) - pieces.get(0).m_73547_().m_162396_();
            pieces.forEach(piece -> piece.m_6324_(0, yDiff, 0));
        } else {
            int yDiff = placementPos.m_123342_() + this.ledgeOffsetY.orElse(0) - pieces.get(0).m_73547_().m_162396_();
            pieces.forEach(piece -> piece.m_6324_(0, yDiff, 0));
        }
        pieces.forEach(piece -> piece.m_6324_(0, offsetY, 0));
    }

    @Override
    public StructureType<?> m_213658_() {
        return MESStructures.GENERIC_NETHER_JIGSAW_STRUCTURE.get();
    }

    public static enum LAND_SEARCH_DIRECTION implements StringRepresentable
    {
        HIGHEST_LAND("HIGHEST_LAND"),
        LOWEST_LAND("LOWEST_LAND");

        private final String name;
        private static final Map<String, LAND_SEARCH_DIRECTION> BY_NAME;

        private LAND_SEARCH_DIRECTION(String name) {
            this.name = name;
        }

        public static LAND_SEARCH_DIRECTION byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            BY_NAME = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
                LAND_SEARCH_DIRECTION[] var1;
                for (LAND_SEARCH_DIRECTION type : var1 = LAND_SEARCH_DIRECTION.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

