/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7923;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BCLBiomeSource;
import org.betterx.bclib.api.v2.generator.BiomeDecider;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.generator.TheEndBiomesHelper;
import org.betterx.bclib.api.v2.generator.config.BCLEndBiomeSourceConfig;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.interfaces.BiomeMap;
import org.betterx.worlds.together.biomesource.BiomeSourceWithConfig;
import org.jetbrains.annotations.NotNull;

public class BCLibEndBiomeSource
extends BCLBiomeSource
implements BiomeSourceWithConfig<BCLibEndBiomeSource, BCLEndBiomeSourceConfig> {
    public static Codec<BCLibEndBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(source -> source.currentSeed), (App)BCLEndBiomeSourceConfig.CODEC.fieldOf("config").orElse((Object)BCLEndBiomeSourceConfig.DEFAULT).forGetter(o -> o.config)).apply((Applicative)instance, instance.stable(BCLibEndBiomeSource::new)));
    private final Point pos;
    private BiomeMap mapLand;
    private BiomeMap mapVoid;
    private BiomeMap mapCenter;
    private BiomeMap mapBarrens;
    private BiomePicker endLandBiomePicker;
    private BiomePicker endVoidBiomePicker;
    private BiomePicker endCenterBiomePicker;
    private BiomePicker endBarrensBiomePicker;
    private List<BiomeDecider> deciders;
    private BCLEndBiomeSourceConfig config;

    private BCLibEndBiomeSource(long seed, BCLEndBiomeSourceConfig config) {
        this(seed, config, true);
    }

    public BCLibEndBiomeSource(BCLEndBiomeSourceConfig config) {
        this(0L, config, false);
    }

    private BCLibEndBiomeSource(long seed, BCLEndBiomeSourceConfig config, boolean initMaps) {
        super(seed);
        this.config = config;
        this.rebuildBiomes(false);
        this.pos = new Point();
        if (initMaps) {
            this.initMap(seed);
        }
    }

    @Override
    protected BiomeAPI.BiomeType defaultBiomeType() {
        return BiomeAPI.BiomeType.END_LAND;
    }

    @Override
    protected Map<BiomeAPI.BiomeType, BiomePicker> createFreshPickerMap() {
        this.deciders = BiomeDecider.DECIDERS.stream().filter(d -> d.canProvideFor(this)).map(d -> d.createInstance(this)).toList();
        this.endLandBiomePicker = new BiomePicker();
        this.endVoidBiomePicker = new BiomePicker();
        this.endCenterBiomePicker = new BiomePicker();
        this.endBarrensBiomePicker = new BiomePicker();
        return Map.of(BiomeAPI.BiomeType.END_LAND, this.endLandBiomePicker, BiomeAPI.BiomeType.END_VOID, this.endVoidBiomePicker, BiomeAPI.BiomeType.END_CENTER, this.endCenterBiomePicker, BiomeAPI.BiomeType.END_BARRENS, this.endBarrensBiomePicker);
    }

    @Override
    protected boolean addToPicker(BCLBiome bclBiome, BiomeAPI.BiomeType type, BiomePicker picker) {
        if (!this.config.withVoidBiomes && bclBiome.getID().equals((Object)class_1972.field_9457.method_29177())) {
            return false;
        }
        for (BiomeDecider decider : this.deciders) {
            if (!decider.addToPicker(bclBiome)) continue;
            return true;
        }
        return super.addToPicker(bclBiome, type, picker);
    }

    @Override
    protected BiomeAPI.BiomeType typeForUnknownBiome(class_5321<class_1959> biomeKey, BiomeAPI.BiomeType defaultType) {
        if (TheEndBiomesHelper.canGenerateAsMainIslandBiome(biomeKey)) {
            return BiomeAPI.BiomeType.END_CENTER;
        }
        if (TheEndBiomesHelper.canGenerateAsHighlandsBiome(biomeKey)) {
            if (!this.config.withVoidBiomes) {
                return BiomeAPI.BiomeType.END_VOID;
            }
            return BiomeAPI.BiomeType.END_LAND;
        }
        if (TheEndBiomesHelper.canGenerateAsEndBarrens(biomeKey)) {
            return BiomeAPI.BiomeType.END_BARRENS;
        }
        if (TheEndBiomesHelper.canGenerateAsSmallIslandsBiome(biomeKey)) {
            return BiomeAPI.BiomeType.END_VOID;
        }
        if (TheEndBiomesHelper.canGenerateAsEndMidlands(biomeKey)) {
            return BiomeAPI.BiomeType.END_LAND;
        }
        return super.typeForUnknownBiome(biomeKey, defaultType);
    }

    @Override
    protected void onFinishBiomeRebuild(Map<BiomeAPI.BiomeType, BiomePicker> pickerMap) {
        super.onFinishBiomeRebuild(pickerMap);
        for (BiomeDecider decider : this.deciders) {
            decider.rebuild();
        }
        if (this.endVoidBiomePicker.isEmpty()) {
            if (Configs.MAIN_CONFIG.verboseLogging() && !BCLib.isDatagen()) {
                BCLib.LOGGER.info("No Void Biomes found. Disabling by using barrens");
            }
            this.endVoidBiomePicker = this.endBarrensBiomePicker;
        }
        if (this.endBarrensBiomePicker.isEmpty()) {
            if (Configs.MAIN_CONFIG.verboseLogging() && !BCLib.isDatagen()) {
                BCLib.LOGGER.info("No Barrens Biomes found. Disabling by using land Biomes");
            }
            this.endBarrensBiomePicker = this.endLandBiomePicker;
            this.endVoidBiomePicker = this.endLandBiomePicker;
        }
        if (this.endCenterBiomePicker.isEmpty()) {
            if (Configs.MAIN_CONFIG.verboseLogging() && !BCLib.isDatagen()) {
                BCLib.LOGGER.warning("No Center Island Biomes found. Forcing use of vanilla center.", new Object[0]);
            }
            this.endCenterBiomePicker.addBiome(BiomeAPI.THE_END);
            this.endCenterBiomePicker.rebuild();
            if (this.endCenterBiomePicker.isEmpty()) {
                if (Configs.MAIN_CONFIG.verboseLogging() && !BCLib.isDatagen()) {
                    BCLib.LOGGER.error("Unable to force vanilla central Island. Falling back to land Biomes...");
                }
                this.endCenterBiomePicker = this.endLandBiomePicker;
            }
        }
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_7923.field_41156, (class_2960)BCLib.makeID("end_biome_source"), CODEC);
    }

    @Override
    protected void onInitMap(long seed) {
        for (BiomeDecider decider : this.deciders) {
            decider.createMap((picker, size) -> this.config.mapVersion.mapBuilder.create(seed, size <= 0 ? this.config.landBiomesSize : size, picker));
        }
        this.mapLand = this.config.mapVersion.mapBuilder.create(seed, this.config.landBiomesSize, this.endLandBiomePicker);
        this.mapVoid = this.config.mapVersion.mapBuilder.create(seed, this.config.voidBiomesSize, this.endVoidBiomePicker);
        this.mapCenter = this.config.mapVersion.mapBuilder.create(seed, this.config.centerBiomesSize, this.endCenterBiomePicker);
        this.mapBarrens = this.config.mapVersion.mapBuilder.create(seed, this.config.barrensBiomesSize, this.endBarrensBiomePicker);
    }

    @Override
    protected void onHeightChange(int newHeight) {
    }

    public class_6880<class_1959> method_38109(int biomeX, int biomeY, int biomeZ, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_6552 sampler) {
        long dist;
        if (!this.wasBound()) {
            this.reloadBiomes(false);
        }
        if (this.mapLand == null || this.mapVoid == null || this.mapCenter == null || this.mapBarrens == null) {
            return (class_6880)this.method_28443().stream().findFirst().orElseThrow();
        }
        int posX = class_5742.method_33101((int)biomeX);
        int posY = class_5742.method_33101((int)biomeY);
        int posZ = class_5742.method_33101((int)biomeZ);
        long l = dist = (long)(Math.abs(posX) + Math.abs(posZ)) > (long)this.config.innerVoidRadiusSquared ? (long)this.config.innerVoidRadiusSquared + 1L : (long)posX * (long)posX + (long)posZ * (long)posZ;
        if ((biomeX & 0x3F) == 0 || (biomeZ & 0x3F) == 0) {
            this.mapLand.clearCache();
            this.mapVoid.clearCache();
            this.mapCenter.clearCache();
            this.mapVoid.clearCache();
            for (BiomeDecider decider : this.deciders) {
                decider.clearMapCache();
            }
        }
        int x = (class_4076.method_18675((int)posX) * 2 + 1) * 8;
        int z = (class_4076.method_18675((int)posZ) * 2 + 1) * 8;
        double d = sampler.comp_367().method_40464((class_6910.class_6912)new class_6910.class_6914(x, posY, z));
        BiomeAPI.BiomeType suggestedType = dist <= (long)this.config.innerVoidRadiusSquared ? BiomeAPI.BiomeType.END_CENTER : (d > 0.25 ? BiomeAPI.BiomeType.END_LAND : (d >= -0.0625 ? BiomeAPI.BiomeType.END_LAND : (d < -0.21875 ? BiomeAPI.BiomeType.END_VOID : (this.config.withVoidBiomes ? BiomeAPI.BiomeType.END_BARRENS : BiomeAPI.BiomeType.END_LAND))));
        BiomeAPI.BiomeType originalType = suggestedType;
        for (BiomeDecider decider : this.deciders) {
            suggestedType = decider.suggestType(originalType, suggestedType, d, this.maxHeight, posX, posY, posZ, biomeX, biomeY, biomeZ);
        }
        for (BiomeDecider decider : this.deciders) {
            BiomePicker.ActualBiome result;
            if (!decider.canProvideBiome(suggestedType) || (result = decider.provideBiome(suggestedType, posX, posY, posZ)) == null) continue;
            return result.biome;
        }
        if (suggestedType.is(BiomeAPI.BiomeType.END_CENTER)) {
            return this.mapCenter.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
        }
        if (suggestedType.is(BiomeAPI.BiomeType.END_VOID)) {
            return this.mapVoid.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
        }
        if (suggestedType.is(BiomeAPI.BiomeType.END_BARRENS)) {
            return this.mapBarrens.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
        }
        return this.mapLand.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    @Override
    public String toShortString() {
        return "BCLib - The End  BiomeSource (" + Integer.toHexString(this.hashCode()) + ")";
    }

    public String toString() {
        return "\n" + this.toShortString() + "\n    biomes     = " + this.method_28443().size() + "\n    namespaces = " + this.getNamespaces() + "\n    seed       = " + this.currentSeed + "\n    height     = " + this.maxHeight + "\n    deciders   = " + this.deciders.size() + "\n    config     = " + this.config;
    }

    @Override
    public BCLEndBiomeSourceConfig getTogetherConfig() {
        return this.config;
    }

    @Override
    public void setTogetherConfig(BCLEndBiomeSourceConfig newConfig) {
        this.config = newConfig;
        this.rebuildBiomes(true);
        this.initMap(this.currentSeed);
    }
}

