/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivearmorhud;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import toni.immersivearmorhud.foundation.config.AllConfigs;
import toni.lib.utils.ColorUtils;
import toni.lib.utils.VersionUtils;

public class ArmorBarRenderer {
    public static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static Map<String, String> configuredPrefixes = Map.ofEntries(Map.entry("minecraft:diamond", "diamond"), Map.entry("betterend:thallasium", "diamond"), Map.entry("betterend:terminite", "diamond"), Map.entry("deeperdarker:resonarium", "diamond"), Map.entry("minecraft:netherite", "netherite"), Map.entry("minecraft:iron", "iron"), Map.entry("minecraft:chainmail", "iron"), Map.entry("minecraft:gold", "gold"), Map.entry("minecraft:leather", "leather"), Map.entry("minecraft:elytra", "elytra"), Map.entry("aether:zanite", "zanite"), Map.entry("aether:gravitite", "gravitite"), Map.entry("aether:phoenix", "phoenix"), Map.entry("aether:neptune", "neptune"), Map.entry("aether:valkyrie", "valkyrie"), Map.entry("aether:obsidian", "obsidian"));

    private static ResourceLocation getTextureForItem(Item item) {
        String itemID = BuiltInRegistries.f_257033_.m_7981_((Object)item).toString();
        String path = "iron";
        for (Map.Entry<String, String> prefix : configuredPrefixes.entrySet()) {
            if (!itemID.contains(prefix.getKey())) continue;
            path = prefix.getValue();
            break;
        }
        return VersionUtils.resource((String)"immersivearmorhud", (String)("textures/gui/sprites/" + path + ".png"));
    }

    private static float getDurabilityPercentage(ItemStack stack) {
        int maxDurability = ArmorBarRenderer.getMaxDamage(stack.m_41720_(), stack);
        int currentDurability = stack.m_41773_();
        return 1.0f - (float)currentDurability / (float)maxDurability;
    }

    private static int getMaxDamage(Item item, ItemStack stack) {
        return item.m_41462_();
    }

    private static int getDurabilityColor(float durability) {
        if ((double)durability > 0.51) {
            return ColorUtils.color((int)0, (int)255, (int)0);
        }
        if ((double)durability > 0.25) {
            return ColorUtils.color((int)255, (int)165, (int)0);
        }
        return ColorUtils.color((int)255, (int)0, (int)0);
    }

    public static boolean render(GuiGraphics graphics, int vanillaHeight) {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        ClientLevel level = client.f_91073_;
        if (player == null || level == null) {
            return false;
        }
        boolean rightAligned = (Boolean)AllConfigs.client().rightAligned.get();
        int yOffset = (Integer)AllConfigs.client().yOffset.get();
        int xOffset = (Integer)AllConfigs.client().xOffset.get();
        int screenWidth = graphics.m_280182_();
        int slotOffset = 0;
        boolean flag = false;
        for (int i = 0; i < ARMOR_SLOTS.length; ++i) {
            EquipmentSlot slot = ARMOR_SLOTS[i];
            ItemStack stack = player.m_6844_(slot);
            if (stack.m_41619_()) continue;
            flag = true;
            int u = i * 8;
            int x = (rightAligned ? 149 : 0) + xOffset + screenWidth / 2 - 91 + slotOffset * 8;
            int y = yOffset + vanillaHeight;
            graphics.m_280411_(ArmorBarRenderer.getTextureForItem(stack.m_41720_()), x, y, 8, 8, (float)u, 0.0f, 8, 8, 33, 9);
            float durability = ArmorBarRenderer.getDurabilityPercentage(stack);
            if (durability < 0.5f) {
                int barWidth = (int)(6.0f * durability);
                int color = ArmorBarRenderer.getDurabilityColor(durability);
                graphics.m_280509_(x + 1, y + 7, x + 8, y + 8, ColorUtils.color((int)0, (int)0, (int)0));
                graphics.m_280509_(x + 1, y + 7, x + 2 + barWidth, y + 8, color);
            }
            ++slotOffset;
        }
        return flag;
    }
}

