/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.widget.textbox;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.FormattedStringDisplayCache;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.FormattingToolbar;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.HorizontalAlignment;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.Line;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedStringEditor;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Formatting;
import io.github.mortuusars.scholar.client.util.Pos2i;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class TextBox
extends AbstractWidget {
    protected final Font font;
    protected FormattedStringEditor editor = new FormattedStringEditor(() -> FormattedStringEditor.Validator.fitInDimensions(this.getFont(), this.m_5711_(), this.m_93694_()));
    protected FormattedStringDisplayCache displayCache = new FormattedStringDisplayCache(this.editor);
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected int fontColor = -16777216;
    protected int fontUnfocusedColor = -16777216;
    protected int selectionColor = -16776961;
    protected int selectionUnfocusedColor = -2013265665;
    protected Consumer<FormattedString> onTextChanged = text -> {};
    protected FormattingToolbar formattingToolbar = new FormattingToolbar(this);
    protected Pos2i lastClickPos = new Pos2i(0, 0);
    protected long lastActionTime;
    protected boolean canDrag;

    public TextBox(int x, int y, int width, int height) {
        this(Minecraft.m_91087_().f_91062_, x, y, width, height);
    }

    public TextBox(Font font, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public FormattedStringEditor getEditor() {
        return this.editor;
    }

    public FormattedStringDisplayCache getDisplayCache() {
        if (this.displayCache.shouldUpdate()) {
            this.displayCache.update(this.getFont(), this.m_5711_(), this.m_93694_(), this.getHorizontalAlignment());
        }
        return this.displayCache;
    }

    public FormattingToolbar getFormattingToolbar() {
        if (this.formattingToolbar.shouldUpdate()) {
            this.formattingToolbar.update();
        }
        return this.formattingToolbar;
    }

    public TextBox setFormattingToolbar(FormattingToolbar formattingToolbar) {
        this.formattingToolbar = formattingToolbar;
        this.formattingToolbar.scheduleUpdate();
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public TextBox setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.refreshDisplayCache();
        return this;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public TextBox setFontColor(int fontColor) {
        this.fontColor = fontColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getFontUnfocusedColor() {
        return this.fontUnfocusedColor;
    }

    public TextBox setFontUnfocusedColor(int fontUnfocusedColor) {
        this.fontUnfocusedColor = fontUnfocusedColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getSelectionColor() {
        return this.selectionColor;
    }

    public TextBox setSelectionColor(int selectionColor) {
        this.selectionColor = selectionColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getSelectionUnfocusedColor() {
        return this.selectionUnfocusedColor;
    }

    public TextBox setSelectionUnfocusedColor(int selectionUnfocusedColor) {
        this.selectionUnfocusedColor = selectionUnfocusedColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getCurrentFontColor() {
        return this.m_93696_() ? this.fontColor : this.fontUnfocusedColor;
    }

    public int getCurrentSelectionColor() {
        return this.m_93696_() ? this.selectionColor : this.selectionUnfocusedColor;
    }

    public TextBox setTextValidator(Predicate<String> validator) {
        this.getEditor().setValidator(validator);
        return this;
    }

    public Consumer<FormattedString> onTextChanged() {
        return this.onTextChanged;
    }

    public TextBox setOnTextChanged(Consumer<FormattedString> onTextChanged) {
        this.onTextChanged = onTextChanged;
        return this;
    }

    public TextBox setText(FormattedString text) {
        this.getEditor().setString(text);
        return this;
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        FormattedStringDisplayCache displayCache = this.getDisplayCache();
        this.renderLines(guiGraphics, mouseX, mouseY, partialTick, displayCache.getLines(), this.getCurrentFontColor());
        int cursorColor = this.getCurrentFontColor();
        Formatting currentFormatting = this.getEditor().getFormattingAtCursor();
        if (currentFormatting.color() != null) {
            cursorColor = currentFormatting.color().asChatFormatting().m_126665_() | 0xFF000000;
        }
        this.renderCursor(guiGraphics, mouseX, mouseY, partialTick, this.getEditor(), displayCache.getCursor(), cursorColor);
        this.renderSelection(guiGraphics, mouseX, mouseY, partialTick, displayCache.getSelection(), this.getCurrentSelectionColor());
        this.getFormattingToolbar().render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderLines(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, List<Line> lines, int color) {
        for (Line line : lines) {
            guiGraphics.m_280056_(this.font, line.renderedString(), this.m_252754_() + line.x(), this.m_252907_() + line.y(), color, false);
        }
    }

    public void renderSelection(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, List<Rect2i> selection, int color) {
        for (Rect2i rect : selection) {
            int x0 = this.m_252754_() + rect.m_110085_();
            int y0 = this.m_252907_() + rect.m_110086_();
            int x1 = x0 + rect.m_110090_();
            int y1 = y0 + rect.m_110091_();
            guiGraphics.m_285944_(RenderType.m_285783_(), x0, y0, x1, y1, color);
        }
    }

    public void renderCursor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, FormattedStringEditor editor, Pos2i cursor, int color) {
        if (!this.m_93696_()) {
            return;
        }
        if (editor.isSelecting()) {
            return;
        }
        if (System.currentTimeMillis() - this.lastActionTime > 200L && (System.currentTimeMillis() - this.lastActionTime) % 600L > 300L) {
            return;
        }
        if (editor.isCursorAtEnd()) {
            Line line = this.getDisplayCache().getLine(this.getDisplayCache().getLines().size() - 1);
            int n = cursor.y;
            Objects.requireNonNull(this.font);
            if (n + 9 > this.m_93694_()) {
                int x = line.x() + line.width();
                int y = line.y();
                guiGraphics.m_280056_(this.getFont(), "<", this.m_252754_() + x, this.m_252907_() + y, color, false);
            } else {
                guiGraphics.m_280056_(this.getFont(), "_", this.m_252754_() + cursor.x, this.m_252907_() + cursor.y, color, false);
            }
        } else {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 50.0f);
            RenderSystem.disableBlend();
            int n = this.m_252754_() + cursor.x;
            int n2 = this.m_252907_() + cursor.y - 1;
            int n3 = this.m_252754_() + cursor.x + 1;
            int n4 = this.m_252907_() + cursor.y;
            Objects.requireNonNull(this.font);
            guiGraphics.m_280509_(n, n2, n3, n4 + 9, color);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    protected void refreshDisplayCache() {
        this.displayCache.scheduleUpdate();
        this.formattingToolbar.scheduleUpdate();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!(this.m_93696_() && this.m_142518_() && this.f_93624_)) {
            return false;
        }
        if (this.handleKeyPressed(keyCode, scanCode, modifiers)) {
            this.lastActionTime = System.currentTimeMillis();
            this.onTextChanged().accept(this.getEditor().getString());
            this.refreshDisplayCache();
            return true;
        }
        return false;
    }

    protected boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.getFormattingToolbar().keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 265) {
            this.changeLine(-1);
            return true;
        }
        if (keyCode == 264) {
            this.changeLine(1);
            return true;
        }
        if (keyCode == 268) {
            this.keyHome();
            return true;
        }
        if (keyCode == 269) {
            this.keyEnd();
            return true;
        }
        return this.getEditor().keyPressed(keyCode);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.m_93696_() && this.getEditor().charTyped(codePoint)) {
            this.lastActionTime = System.currentTimeMillis();
            this.onTextChanged().accept(this.getEditor().getString());
            this.refreshDisplayCache();
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_142518_() || !this.f_93624_) {
            return false;
        }
        if (this.getFormattingToolbar().mouseClicked(mouseX, mouseY, button)) {
            this.refreshDisplayCache();
            this.onTextChanged().accept(this.getEditor().getString());
            this.canDrag = false;
            return true;
        }
        if (this.f_93622_ && button == 0) {
            long currentTime = System.currentTimeMillis();
            FormattedStringDisplayCache display = this.getDisplayCache();
            int indexAtMousePos = display.getCharIndexAtPosition(this.font, (int)(mouseX - (double)this.m_252754_()), (int)(mouseY - (double)this.m_252907_()));
            if (Math.abs(this.lastClickPos.x - (int)mouseX) < 4 && Math.abs(this.lastClickPos.y - (int)mouseY) < 4 && currentTime - this.lastActionTime < 250L) {
                if (!this.getEditor().isSelecting()) {
                    this.getEditor().selectWord(indexAtMousePos);
                } else {
                    this.getEditor().selectAll();
                }
            } else {
                this.getEditor().setCursorPos(indexAtMousePos, Screen.m_96638_());
            }
            this.refreshDisplayCache();
            this.lastClickPos = new Pos2i((int)mouseX, (int)mouseY);
            this.lastActionTime = currentTime;
            this.canDrag = true;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.canDrag) {
            FormattedStringDisplayCache display = this.getDisplayCache();
            int indexAtMousePos = display.getCharIndexAtPosition(this.font, (int)(mouseX - (double)this.m_252754_()), (int)(mouseY - (double)this.m_252907_()));
            this.getEditor().setCursorPos(indexAtMousePos, true);
            this.refreshDisplayCache();
            return true;
        }
        return false;
    }

    public void changeLine(int yChange) {
        Pos2i cursor = this.getDisplayCache().getCursor();
        int x = cursor.x;
        int n = cursor.y;
        Objects.requireNonNull(this.font);
        int y = n + 9 * yChange;
        int index = this.getDisplayCache().getCharIndexAtPosition(this.font, x, y);
        this.getEditor().setCursorPos(index, Screen.m_96638_());
    }

    public void keyHome() {
        if (Screen.m_96637_()) {
            this.getEditor().setCursorToStart(Screen.m_96638_());
        } else {
            int cursorPos = this.getEditor().getCursorPos();
            int lineIndex = this.getDisplayCache().findLineIndexByCharIndex(cursorPos);
            Line line = this.getDisplayCache().getLine(lineIndex);
            this.getEditor().setCursorPos(line.firstCharIndex(), Screen.m_96638_());
        }
    }

    public void keyEnd() {
        if (Screen.m_96637_()) {
            this.getEditor().setCursorToEnd(Screen.m_96638_());
        } else {
            int cursorPos = this.getEditor().getCursorPos();
            int lineIndex = this.getDisplayCache().findLineIndexByCharIndex(cursorPos);
            Line line = this.getDisplayCache().getLine(lineIndex);
            this.getEditor().setCursorPos(line.lastCharIndex() + 1, Screen.m_96638_());
        }
    }

    @NotNull
    public Component m_6035_() {
        return Component.m_237113_((String)this.getEditor().getString().toStringWithoutFormatting());
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }
}

