/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.network;

import java.util.List;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class RescueMessage {
    private final boolean active;

    public RescueMessage(boolean active) {
        this.active = active;
    }

    public static void encode(RescueMessage message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.active);
    }

    public static RescueMessage decode(FriendlyByteBuf buf) {
        boolean active = buf.readBoolean();
        return new RescueMessage(active);
    }

    private static boolean isLookingTowards(Player player, Entity candidate) {
        double dz;
        double dy;
        double dx = candidate.m_20185_() - player.m_20185_();
        double dotProduct = player.m_20154_().f_82479_ * dx + player.m_20154_().f_82480_ * (dy = candidate.m_20186_() - 1.0 - player.m_20186_()) + player.m_20154_().f_82481_ * (dz = candidate.m_20189_() - player.m_20189_());
        return dotProduct > 0.0 && Math.abs(Math.acos(dotProduct / Math.sqrt(dx * dx + dy * dy + dz * dz))) < 1.0471975511965976;
    }

    public static void handle(ServerPlayer player, RescueMessage message) {
        if (player == null || !player.m_6084_() || player.m_5833_() || HardcoreRevival.getRevivalData((Entity)player).isKnockedOut()) {
            return;
        }
        if (message.active) {
            double range = HardcoreRevivalConfig.getActive().rescueDistance;
            List candidates = player.m_9236_().m_6443_(Player.class, player.m_20191_().m_82400_(range), p -> {
                if (p == null || !HardcoreRevival.getRevivalData((Entity)p).isKnockedOut()) {
                    return false;
                }
                if (!player.m_142582_((Entity)p)) {
                    return false;
                }
                return RescueMessage.isLookingTowards((Player)player, (Entity)p);
            });
            float minDist = Float.MAX_VALUE;
            Player target = null;
            for (Player candidate : candidates) {
                float dist = candidate.m_20270_((Entity)player);
                if (!(dist < minDist)) continue;
                target = candidate;
                minDist = dist;
            }
            if (target != null) {
                HardcoreRevival.getManager().startRescue((Player)player, target);
            }
        } else {
            HardcoreRevival.getManager().abortRescue((Player)player);
        }
    }
}

