/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.registry.passive;

import com.seniors.justlevelingfork.client.core.Utils;
import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.handler.HandlerConfigClient;
import com.seniors.justlevelingfork.handler.HandlerResources;
import com.seniors.justlevelingfork.registry.RegistryAptitudes;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;

public class Passive {
    public final ResourceLocation key;
    public final Aptitude aptitude;
    public final ResourceLocation texture;
    public final Attribute attribute;
    public final String attributeUuid;
    public final Object attributeValue;
    public final int[] levelsRequired;

    public Passive(ResourceLocation passiveKey, Aptitude aptitude, ResourceLocation passiveTexture, Attribute attribute, String attributeUuid, Object attributeValue, int ... levelsRequired) {
        this.key = passiveKey;
        this.aptitude = aptitude;
        this.texture = passiveTexture;
        this.attribute = attribute;
        this.attributeUuid = attributeUuid;
        this.attributeValue = attributeValue;
        this.levelsRequired = levelsRequired;
    }

    public static Passive add(String passiveName, String aptitudeName, String texture, Attribute attribute, String attributeUUID, Object attributeValue, int ... levelsRequired) {
        Aptitude aptitude = RegistryAptitudes.getAptitude(aptitudeName);
        if (aptitude == null) {
            throw new IllegalArgumentException("Aptitude name doesn't exist: " + aptitudeName);
        }
        ResourceLocation key = new ResourceLocation("justlevelingfork", passiveName);
        return new Passive(key, aptitude, HandlerResources.create(texture), attribute, attributeUUID, attributeValue, levelsRequired);
    }

    public Passive get() {
        return this;
    }

    public String getMod() {
        return this.key.m_135827_();
    }

    public String getName() {
        return this.key.m_135815_();
    }

    public String getKey() {
        return "passive." + this.key.m_214298_();
    }

    public String getDescription() {
        return this.getKey() + ".description";
    }

    public double getValue() {
        double newValue = 0.0;
        if (this.attributeValue != null) {
            Object value;
            Object object = this.attributeValue;
            if (object instanceof ForgeConfigSpec.DoubleValue) {
                value = (ForgeConfigSpec.DoubleValue)object;
                newValue = (Double)value.get();
            }
            if (object instanceof ForgeConfigSpec.IntValue) {
                value = (ForgeConfigSpec.IntValue)object;
                newValue = ((Integer)value.get()).intValue();
            }
            if (object instanceof Number) {
                value = (Number)object;
                newValue = ((Number)value).doubleValue();
            }
        }
        return newValue;
    }

    public int getNextLevelUp() {
        int[] requirement = new int[this.levelsRequired.length + 2];
        requirement[0] = 0;
        System.arraycopy(this.levelsRequired, 0, requirement, 1, this.levelsRequired.length);
        return requirement[this.getLevel() + 1];
    }

    public List<Component> tooltip() {
        DecimalFormat df = new DecimalFormat("0.##");
        String valuePerLevel = df.format(this.getValue() / (double)this.levelsRequired.length);
        String valueActualLevel = df.format(this.getValue() / (double)this.levelsRequired.length * (double)this.getLevel());
        String valueMaxLevel = df.format(this.getValue());
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tooltip.passive.title").m_7220_((Component)Component.m_237115_((String)this.getKey())).m_130940_(ChatFormatting.GREEN));
        list.add((Component)Component.m_237110_((String)"tooltip.passive.description.passive_level", (Object[])new Object[]{this.getLevel(), this.levelsRequired.length}).m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237119_());
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237119_().m_7220_((Component)Component.m_237115_((String)this.getKey()).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.UNDERLINE)).m_7220_((Component)Component.m_237113_((String)": ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237115_((String)this.getDescription()).m_130940_(ChatFormatting.GRAY)));
            list.add((Component)Component.m_237119_());
            list.add((Component)Component.m_237115_((String)"tooltip.passive.description.other_info").m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"tooltip.passive.description.level", (Object[])new Object[]{valuePerLevel})).m_130940_(ChatFormatting.DARK_GREEN));
            list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"tooltip.passive.description.actual_level", (Object[])new Object[]{valueActualLevel})).m_130940_(ChatFormatting.DARK_GREEN));
            list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"tooltip.passive.description.max_level", (Object[])new Object[]{valueMaxLevel})).m_130940_(ChatFormatting.DARK_GREEN));
            list.add((Component)Component.m_237119_());
            list.add((Component)Component.m_237115_((String)"tooltip.passive.description.level_requirement").m_130940_(ChatFormatting.DARK_PURPLE));
            if (this.getLevel() < this.levelsRequired.length) {
                list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"tooltip.passive.description.passive_required", (Object[])new Object[]{Component.m_237115_((String)this.aptitude.getKey()).m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)String.valueOf(this.getNextLevelUp())).m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)String.valueOf(this.getLevel() + 1)).m_130940_(ChatFormatting.GREEN)})).m_130940_(ChatFormatting.DARK_AQUA));
            } else {
                list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"tooltip.passive.description.passive_max_level")).m_130940_(ChatFormatting.DARK_AQUA));
            }
        } else {
            list.add((Component)Component.m_237115_((String)"tooltip.general.description.more_information").m_130940_(ChatFormatting.YELLOW));
        }
        if (((Boolean)HandlerConfigClient.showSkillModName.get()).booleanValue()) {
            list.add((Component)Component.m_237113_((String)Utils.getModName(this.getMod())).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC));
        }
        return list;
    }

    public int getLevel() {
        return AptitudeCapability.get().getPassiveLevel(this);
    }

    public int getLevel(Player player) {
        return AptitudeCapability.get(player).getPassiveLevel(this);
    }

    public int getMaxLevel() {
        return this.levelsRequired.length;
    }

    public ResourceLocation getTexture() {
        return Objects.requireNonNullElse(this.texture, HandlerResources.NULL_SKILL);
    }
}

