/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.registry;

import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.config.models.TitleModel;
import com.seniors.justlevelingfork.handler.HandlerConditions;
import com.seniors.justlevelingfork.handler.HandlerTitlesConfig;
import com.seniors.justlevelingfork.registry.RegistryCapabilities;
import com.seniors.justlevelingfork.registry.title.Title;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class RegistryTitles {
    public static final ResourceKey<Registry<Title>> TITLES_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("justlevelingfork", "titles"));
    public static final DeferredRegister<Title> TITLES = DeferredRegister.create(TITLES_KEY, (String)"justlevelingfork");
    public static final Supplier<IForgeRegistry<Title>> TITLES_REGISTRY = TITLES.makeRegistry(() -> new RegistryBuilder().disableSaving());
    public static final RegistryObject<Title> TITLELESS = TITLES.register("titleless", () -> RegistryTitles.register("titleless", true));
    public static final RegistryObject<Title> ADMIN = TITLES.register("administrator", () -> RegistryTitles.register("administrator", false));

    public static void load(IEventBus eventBus) {
        ((HandlerTitlesConfig)HandlerTitlesConfig.HANDLER.instance()).titleList.forEach(title -> title.registry(TITLES));
        TITLES.register(eventBus);
        HandlerConditions.registerDefaults();
    }

    private static Title register(String name, boolean requirement) {
        ResourceLocation key = new ResourceLocation("justlevelingfork", name);
        return new Title(key, requirement, true);
    }

    public static Title getTitle(String titleName) {
        return TITLES_REGISTRY.get().getValues().stream().collect(Collectors.toMap(Title::getName, Title::get)).get(titleName);
    }

    public static void syncTitles(ServerPlayer serverPlayer) {
        RegistryTitles.serverPlayerTitles(serverPlayer);
        serverPlayer.getCapability(RegistryCapabilities.APTITUDE).ifPresent(aptitudeCapability -> {
            Title title = RegistryTitles.getTitle(AptitudeCapability.get((Player)serverPlayer).getPlayerTitle());
            if (title != null) {
                serverPlayer.m_6593_((Component)Component.m_237115_((String)title.getKey()));
            }
        });
    }

    public static void serverPlayerTitles(ServerPlayer serverPlayer) {
        if (!serverPlayer.m_21224_()) {
            serverPlayer.getCapability(RegistryCapabilities.APTITUDE).ifPresent(capability -> {
                for (TitleModel titleModel : ((HandlerTitlesConfig)HandlerTitlesConfig.HANDLER.instance()).titleList) {
                    titleModel.getTitle().setRequirement(serverPlayer, titleModel.CheckRequirements(serverPlayer));
                }
                ((Title)ADMIN.get()).setRequirement(serverPlayer, serverPlayer.m_20310_(2));
            });
        }
    }
}

