/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.registry;

import com.seniors.justlevelingfork.client.core.Value;
import com.seniors.justlevelingfork.client.core.ValueType;
import com.seniors.justlevelingfork.handler.HandlerCommonConfig;
import com.seniors.justlevelingfork.handler.HandlerResources;
import com.seniors.justlevelingfork.registry.RegistryAptitudes;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import com.seniors.justlevelingfork.registry.skills.Skill;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class RegistrySkills {
    public static final ResourceKey<Registry<Skill>> SKILLS_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("justlevelingfork", "skills"));
    public static final DeferredRegister<Skill> SKILLS = DeferredRegister.create(SKILLS_KEY, (String)"justlevelingfork");
    public static final Supplier<IForgeRegistry<Skill>> SKILLS_REGISTRY = SKILLS.makeRegistry(() -> new RegistryBuilder().disableSaving());
    public static final RegistryObject<Skill> ONE_HANDED = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).oneHandedRequiredLevel < 0 ? null : SKILLS.register("one_handed", () -> RegistrySkills.register("one_handed", (Aptitude)RegistryAptitudes.STRENGTH.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).oneHandedRequiredLevel, HandlerResources.ONE_HANDED_SKILL, new Value(ValueType.AMPLIFIER, Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).oneHandedAmplifier))));
    public static final RegistryObject<Skill> FIGHTING_SPIRIT = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).fightingSpiritRequiredLevel < 0 ? null : SKILLS.register("fighting_spirit", () -> RegistrySkills.register("fighting_spirit", (Aptitude)RegistryAptitudes.STRENGTH.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).fightingSpiritRequiredLevel, HandlerResources.FIGHTING_SPIRIT_SKILL, new Value(ValueType.BOOST, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).fightingSpiritBoost), new Value(ValueType.DURATION, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).fightingSpiritDuration)));
    public static final RegistryObject<Skill> BERSERKER = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).berserkerRequiredLevel < 0 ? null : SKILLS.register("berserker", () -> RegistrySkills.register("berserker", (Aptitude)RegistryAptitudes.STRENGTH.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).berserkerRequiredLevel, HandlerResources.BERSERKER_SKILL, new Value(ValueType.PERCENT, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).berserkerPercent)));
    public static final RegistryObject<Skill> ATHLETICS = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).athleticsRequiredLevel < 0 ? null : SKILLS.register("athletics", () -> RegistrySkills.register("athletics", (Aptitude)RegistryAptitudes.CONSTITUTION.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).athleticsRequiredLevel, HandlerResources.ATHLETICS_SKILL, new Value(ValueType.MODIFIER, Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).athleticsModifier))));
    public static final RegistryObject<Skill> TURTLE_SHIELD = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).turtleShieldRequiredLevel < 0 ? null : SKILLS.register("turtle_shield", () -> RegistrySkills.register("turtle_shield", (Aptitude)RegistryAptitudes.CONSTITUTION.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).turtleShieldRequiredLevel, HandlerResources.TURTLE_SHIELD_SKILL, new Value[0]));
    public static final RegistryObject<Skill> LION_HEART = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).lionHeartRequiredLevel < 0 ? null : SKILLS.register("lion_heart", () -> RegistrySkills.register("lion_heart", (Aptitude)RegistryAptitudes.CONSTITUTION.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).lionHeartRequiredLevel, HandlerResources.LION_HEART_SKILL, new Value(ValueType.PERCENT, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).lionHeartPercent)));
    public static final RegistryObject<Skill> QUICK_REPOSITION = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).quickRepositionRequiredLevel < 0 ? null : SKILLS.register("quick_reposition", () -> RegistrySkills.register("quick_reposition", (Aptitude)RegistryAptitudes.DEXTERITY.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).quickRepositionRequiredLevel, HandlerResources.QUICK_REPOSITION_SKILL, new Value(ValueType.BOOST, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).quickRepositionBoost), new Value(ValueType.DURATION, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).quickRepositionDuration)));
    public static final RegistryObject<Skill> STEALTH_MASTERY = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).stealthMasteryRequiredLevel < 0 ? null : SKILLS.register("stealth_mastery", () -> RegistrySkills.register("stealth_mastery", (Aptitude)RegistryAptitudes.DEXTERITY.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).stealthMasteryRequiredLevel, HandlerResources.STEALTH_MASTERY_SKILL, new Value(ValueType.PERCENT, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).stealthMasteryUnSneakPercent), new Value(ValueType.PERCENT, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).stealthMasterySneakPercent), new Value(ValueType.MODIFIER, Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).stealthMasteryModifier))));
    public static final RegistryObject<Skill> CAT_EYES = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).catEyesRequiredLevel < 0 ? null : SKILLS.register("cat_eyes", () -> RegistrySkills.register("cat_eyes", (Aptitude)RegistryAptitudes.DEXTERITY.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).catEyesRequiredLevel, HandlerResources.CAT_EYES_SKILL, new Value[0]));
    public static final RegistryObject<Skill> SNOW_WALKER = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).snowWalkerRequiredLevel < 0 ? null : SKILLS.register("snow_walker", () -> RegistrySkills.register("snow_walker", (Aptitude)RegistryAptitudes.DEFENSE.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).snowWalkerRequiredLevel, HandlerResources.SNOW_WALKER_SKILL, new Value[0]));
    public static final RegistryObject<Skill> COUNTER_ATTACK = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).counterattackRequiredLevel < 0 ? null : SKILLS.register("counter_attack", () -> RegistrySkills.register("counter_attack", (Aptitude)RegistryAptitudes.DEFENSE.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).counterattackRequiredLevel, HandlerResources.COUNTER_ATTACK_SKILL, new Value(ValueType.DURATION, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).counterAttackDuration), new Value(ValueType.PERCENT, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).counterAttackPercent)));
    public static final RegistryObject<Skill> DIAMOND_SKIN = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).diamondSkinRequiredLevel < 0 ? null : SKILLS.register("diamond_skin", () -> RegistrySkills.register("diamond_skin", (Aptitude)RegistryAptitudes.DEFENSE.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).diamondSkinRequiredLevel, HandlerResources.DIAMOND_SKIN_SKILL, new Value(ValueType.BOOST, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).diamondSkinBoost), new Value(ValueType.AMPLIFIER, Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).diamondSkinSneakAmplifier))));
    public static final RegistryObject<Skill> SCHOLAR = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).scholarRequiredLevel < 0 ? null : SKILLS.register("scholar", () -> RegistrySkills.register("scholar", (Aptitude)RegistryAptitudes.INTELLIGENCE.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).scholarRequiredLevel, HandlerResources.SCHOLAR_SKILL, new Value[0]));
    public static final RegistryObject<Skill> HAGGLER = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).hagglerRequiredLevel < 0 ? null : SKILLS.register("haggler", () -> RegistrySkills.register("haggler", (Aptitude)RegistryAptitudes.INTELLIGENCE.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).hagglerRequiredLevel, HandlerResources.HAGGLER_SKILL, new Value(ValueType.PERCENT, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).hagglerPercent)));
    public static final RegistryObject<Skill> ALCHEMY_MANIPULATION = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).alchemyManipulationRequiredLevel < 0 ? null : SKILLS.register("alchemy_manipulation", () -> RegistrySkills.register("alchemy_manipulation", (Aptitude)RegistryAptitudes.INTELLIGENCE.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).alchemyManipulationRequiredLevel, HandlerResources.ALCHEMY_MANIPULATION_SKILL, new Value(ValueType.AMPLIFIER, Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).alchemyManipulationAmplifier))));
    public static final RegistryObject<Skill> OBSIDIAN_SMASHER = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).obsidianSmasherRequiredLevel < 0 ? null : SKILLS.register("obsidian_smasher", () -> RegistrySkills.register("obsidian_smasher", (Aptitude)RegistryAptitudes.BUILDING.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).obsidianSmasherRequiredLevel, HandlerResources.OBSIDIAN_SMASHER_SKILL, new Value(ValueType.MODIFIER, Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).obsidianSmasherModifier))));
    public static final RegistryObject<Skill> TREASURE_HUNTER = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).treasureHunterRequiredLevel < 0 ? null : SKILLS.register("treasure_hunter", () -> RegistrySkills.register("treasure_hunter", (Aptitude)RegistryAptitudes.BUILDING.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).treasureHunterRequiredLevel, HandlerResources.TREASURE_HUNTER_SKILL, new Value(ValueType.PROBABILITY, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).treasureHunterProbability)));
    public static final RegistryObject<Skill> CONVERGENCE = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).convergenceRequiredLevel < 0 ? null : SKILLS.register("convergence", () -> RegistrySkills.register("convergence", (Aptitude)RegistryAptitudes.BUILDING.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).convergenceRequiredLevel, HandlerResources.CONVERGENCE_SKILL, new Value(ValueType.PROBABILITY, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).convergenceProbability)));
    public static final RegistryObject<Skill> SAFE_PORT = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).safePortRequiredLevel < 0 ? null : SKILLS.register("safe_port", () -> RegistrySkills.register("safe_port", (Aptitude)RegistryAptitudes.MAGIC.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).safePortRequiredLevel, HandlerResources.SAFE_PORT_SKILL, new Value[0]));
    public static final RegistryObject<Skill> LIFE_EATER = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).lifeEaterRequiredLevel < 0 ? null : SKILLS.register("life_eater", () -> RegistrySkills.register("life_eater", (Aptitude)RegistryAptitudes.MAGIC.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).lifeEaterRequiredLevel, HandlerResources.LIFE_EATER_SKILL, new Value(ValueType.AMPLIFIER, Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).lifeEaterModifier))));
    public static final RegistryObject<Skill> WORMHOLE_STORAGE = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).wornholeStorageRequiredLevel < 0 ? null : SKILLS.register("wormhole_storage", () -> RegistrySkills.register("wormhole_storage", (Aptitude)RegistryAptitudes.MAGIC.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).wornholeStorageRequiredLevel, HandlerResources.WORMHOLE_STORAGE_SKILL, new Value[0]));
    public static final RegistryObject<Skill> CRITICAL_ROLL = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).criticalRollRequiredLevel < 0 ? null : SKILLS.register("critical_roll", () -> RegistrySkills.register("critical_roll", (Aptitude)RegistryAptitudes.LUCK.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).criticalRollRequiredLevel, HandlerResources.CRITICAL_ROLL_SKILL, new Value(ValueType.MODIFIER, Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).criticalRoll6Modifier)), new Value(ValueType.PROBABILITY, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).criticalRoll1Probability)));
    public static final RegistryObject<Skill> LUCKY_DROP = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).luckyDropRequiredLevel < 0 ? null : SKILLS.register("lucky_drop", () -> RegistrySkills.register("lucky_drop", (Aptitude)RegistryAptitudes.LUCK.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).luckyDropRequiredLevel, HandlerResources.LUCKY_DROP_SKILL, new Value(ValueType.PROBABILITY, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).luckyDropProbability), new Value(ValueType.MODIFIER, Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).luckyDropModifier))));
    public static final RegistryObject<Skill> LIMIT_BREAKER = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).limitBreakerRequiredLevel < 0 ? null : SKILLS.register("limit_breaker", () -> RegistrySkills.register("limit_breaker", (Aptitude)RegistryAptitudes.LUCK.get(), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).limitBreakerRequiredLevel, HandlerResources.LIMIT_BREAKER_SKILL, new Value(ValueType.PROBABILITY, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).limitBreakerProbability), new Value(ValueType.AMPLIFIER, Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).limitBreakerAmplifier))));

    private static Skill register(String name, Aptitude aptitude, int requiredLvl, ResourceLocation texture, Value ... configValues) {
        ResourceLocation key = new ResourceLocation("justlevelingfork", name);
        return new Skill(key, aptitude, requiredLvl, texture, configValues);
    }

    public static void load(IEventBus eventBus) {
        SKILLS.register(eventBus);
    }

    public static Skill getSkill(String skillName) {
        return SKILLS_REGISTRY.get().getValues().stream().collect(Collectors.toMap(Skill::getName, Skill::get)).get(skillName);
    }
}

