/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.registry;

import com.seniors.justlevelingfork.handler.HandlerCommonConfig;
import com.seniors.justlevelingfork.handler.HandlerResources;
import com.seniors.justlevelingfork.registry.RegistryAptitudes;
import com.seniors.justlevelingfork.registry.RegistryAttributes;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import com.seniors.justlevelingfork.registry.passive.Passive;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class RegistryPassives {
    public static final ResourceKey<Registry<Passive>> PASSIVES_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("justlevelingfork", "passives"));
    public static final DeferredRegister<Passive> PASSIVES = DeferredRegister.create(PASSIVES_KEY, (String)"justlevelingfork");
    public static final Supplier<IForgeRegistry<Passive>> PASSIVES_REGISTRY = PASSIVES.makeRegistry(() -> new RegistryBuilder().disableSaving());
    public static final RegistryObject<Passive> ATTACK_DAMAGE = PASSIVES.register("attack_damage", () -> RegistryPassives.register("attack_damage", (Aptitude)RegistryAptitudes.STRENGTH.get(), HandlerResources.create("textures/skill/strength/passive_attack_damage.png"), Attributes.f_22281_, "96a891fe-5919-418d-8205-f50464391500", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).attackDamageValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).attackPassiveLevels));
    public static final RegistryObject<Passive> ATTACK_KNOCKBACK = PASSIVES.register("attack_knockback", () -> RegistryPassives.register("attack_knockback", (Aptitude)RegistryAptitudes.STRENGTH.get(), HandlerResources.create("textures/skill/strength/passive_attack_knockback.png"), Attributes.f_22282_, "96a891fe-5919-418d-8205-f50464391501", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).attackKnockbackValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).attackKnockbackPassiveLevels));
    public static final RegistryObject<Passive> MAX_HEALTH = PASSIVES.register("max_health", () -> RegistryPassives.register("max_health", (Aptitude)RegistryAptitudes.CONSTITUTION.get(), HandlerResources.create("textures/skill/constitution/passive_max_health.png"), Attributes.f_22276_, "96a891fe-5919-418d-8205-f50464391502", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).maxHealthValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).maxHealthPassiveLevels));
    public static final RegistryObject<Passive> KNOCKBACK_RESISTANCE = PASSIVES.register("knockback_resistance", () -> RegistryPassives.register("knockback_resistance", (Aptitude)RegistryAptitudes.CONSTITUTION.get(), HandlerResources.create("textures/skill/constitution/passive_knockback_resistance.png"), Attributes.f_22278_, "96a891fe-5919-418d-8205-f50464391503", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).knockbackResistanceValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).knockbackResistancePassiveLevels));
    public static final RegistryObject<Passive> MOVEMENT_SPEED = PASSIVES.register("movement_speed", () -> RegistryPassives.register("movement_speed", (Aptitude)RegistryAptitudes.DEXTERITY.get(), HandlerResources.create("textures/skill/dexterity/passive_movement_speed.png"), Attributes.f_22279_, "96a891fe-5919-418d-8205-f50464391504", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).movementSpeedValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).movementSpeedPassiveLevels));
    public static final RegistryObject<Passive> PROJECTILE_DAMAGE = PASSIVES.register("projectile_damage", () -> RegistryPassives.register("projectile_damage", (Aptitude)RegistryAptitudes.DEXTERITY.get(), HandlerResources.create("textures/skill/dexterity/passive_projectile_damage.png"), (Attribute)RegistryAttributes.PROJECTILE_DAMAGE.get(), "96a891fe-5919-418d-8205-f50464391505", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).projectileDamageValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).projectileDamagePassiveLevels));
    public static final RegistryObject<Passive> ARMOR = PASSIVES.register("armor", () -> RegistryPassives.register("armor", (Aptitude)RegistryAptitudes.DEFENSE.get(), HandlerResources.create("textures/skill/defense/passive_armor.png"), Attributes.f_22284_, "96a891fe-5919-418d-8205-f50464391506", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).armorValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).armorPassiveLevels));
    public static final RegistryObject<Passive> ARMOR_TOUGHNESS = PASSIVES.register("armor_toughness", () -> RegistryPassives.register("armor_toughness", (Aptitude)RegistryAptitudes.DEFENSE.get(), HandlerResources.create("textures/skill/defense/passive_armor_toughness.png"), Attributes.f_22285_, "96a891fe-5919-418d-8205-f50464391507", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).armorToughnessValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).armorToughnessPassiveLevels));
    public static final RegistryObject<Passive> ATTACK_SPEED = PASSIVES.register("attack_speed", () -> RegistryPassives.register("attack_speed", (Aptitude)RegistryAptitudes.INTELLIGENCE.get(), HandlerResources.create("textures/skill/intelligence/passive_attack_speed.png"), Attributes.f_22283_, "96a891fe-5919-418d-8205-f50464391508", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).attackSpeedValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).attackSpeedPassiveLevels));
    public static final RegistryObject<Passive> ENTITY_REACH = PASSIVES.register("entity_reach", () -> RegistryPassives.register("entity_reach", (Aptitude)RegistryAptitudes.INTELLIGENCE.get(), HandlerResources.create("textures/skill/intelligence/passive_entity_reach.png"), (Attribute)ForgeMod.ENTITY_REACH.get(), "96a891fe-5919-418d-8205-f50464391509", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).entityReachValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).entityReachPassiveLevels));
    public static final RegistryObject<Passive> BLOCK_REACH = PASSIVES.register("block_reach", () -> RegistryPassives.register("block_reach", (Aptitude)RegistryAptitudes.BUILDING.get(), HandlerResources.create("textures/skill/building/passive_block_reach.png"), (Attribute)ForgeMod.BLOCK_REACH.get(), "96a891fe-5919-418d-8205-f50464391510", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).blockReachValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).blockReachPassiveLevels));
    public static final RegistryObject<Passive> BREAK_SPEED = PASSIVES.register("break_speed", () -> RegistryPassives.register("break_speed", (Aptitude)RegistryAptitudes.BUILDING.get(), HandlerResources.create("textures/skill/building/passive_break_speed.png"), (Attribute)RegistryAttributes.BREAK_SPEED.get(), "96a891fe-5919-418d-8205-f50464391511", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).breakSpeedValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).breakSpeedPassiveLevels));
    public static final RegistryObject<Passive> BENEFICIAL_EFFECT = PASSIVES.register("beneficial_effect", () -> RegistryPassives.register("beneficial_effect", (Aptitude)RegistryAptitudes.MAGIC.get(), HandlerResources.create("textures/skill/magic/passive_beneficial_effect.png"), (Attribute)RegistryAttributes.BENEFICIAL_EFFECT.get(), "96a891fe-5919-418d-8205-f50464391512", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).beneficialEffectValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).beneficialEffectPassiveLevels));
    public static final RegistryObject<Passive> MAGIC_RESIST = PASSIVES.register("magic_resist", () -> RegistryPassives.register("magic_resist", (Aptitude)RegistryAptitudes.MAGIC.get(), HandlerResources.create("textures/skill/magic/passive_magic_resist.png"), (Attribute)RegistryAttributes.MAGIC_RESIST.get(), "96a891fe-5919-418d-8205-f50464391513", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).magicResistValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).magicResistPassiveLevels));
    public static final RegistryObject<Passive> CRITICAL_DAMAGE = PASSIVES.register("critical_damage", () -> RegistryPassives.register("critical_damage", (Aptitude)RegistryAptitudes.LUCK.get(), HandlerResources.create("textures/skill/luck/passive_critical_damage.png"), (Attribute)RegistryAttributes.CRITICAL_DAMAGE.get(), "96a891fe-5919-418d-8205-f50464391515", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).criticalDamageValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).criticalDamagePassiveLevels));
    public static final RegistryObject<Passive> LUCK = PASSIVES.register("luck", () -> RegistryPassives.register("luck", (Aptitude)RegistryAptitudes.LUCK.get(), HandlerResources.create("textures/skill/luck/passive_luck.png"), Attributes.f_22286_, "96a891fe-5919-418d-8205-f50464391514", Float.valueOf(((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).luckValue), ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).luckPassiveLevels));

    private static Passive register(String name, Aptitude aptitude, ResourceLocation texture, Attribute attribute, String attributeUuid, Object attributeValue, int ... levelsRequired) {
        ResourceLocation key = new ResourceLocation("justlevelingfork", name);
        return new Passive(key, aptitude, texture, attribute, attributeUuid, attributeValue, levelsRequired);
    }

    public static void load(IEventBus eventBus) {
        PASSIVES.register(eventBus);
    }

    public static Passive getPassive(String passiveName) {
        return PASSIVES_REGISTRY.get().getValues().stream().collect(Collectors.toMap(Passive::getName, Passive::get)).get(passiveName);
    }
}

