/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.registry;

import com.mojang.brigadier.CommandDispatcher;
import com.seniors.justlevelingfork.JustLevelingFork;
import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.common.capability.LazyAptitudeCapability;
import com.seniors.justlevelingfork.common.command.AptitudeLevelCommand;
import com.seniors.justlevelingfork.common.command.AptitudesReloadCommand;
import com.seniors.justlevelingfork.common.command.GlobalLimitCommand;
import com.seniors.justlevelingfork.common.command.RegisterItem;
import com.seniors.justlevelingfork.common.command.TitleCommand;
import com.seniors.justlevelingfork.common.command.UpdateAptitudeLevelCommand;
import com.seniors.justlevelingfork.handler.HandlerCommonConfig;
import com.seniors.justlevelingfork.integration.TetraIntegration;
import com.seniors.justlevelingfork.network.packet.client.CommonConfigSyncCP;
import com.seniors.justlevelingfork.network.packet.client.ConfigSyncCP;
import com.seniors.justlevelingfork.network.packet.client.DynamicConfigSyncCP;
import com.seniors.justlevelingfork.network.packet.client.PlayerMessagesCP;
import com.seniors.justlevelingfork.network.packet.client.SyncAptitudeCapabilityCP;
import com.seniors.justlevelingfork.network.packet.common.CounterAttackSP;
import com.seniors.justlevelingfork.registry.RegistryAttributes;
import com.seniors.justlevelingfork.registry.RegistryCapabilities;
import com.seniors.justlevelingfork.registry.RegistryEffects;
import com.seniors.justlevelingfork.registry.RegistrySkills;
import com.seniors.justlevelingfork.registry.RegistrySounds;
import com.seniors.justlevelingfork.registry.RegistryTags;
import com.seniors.justlevelingfork.registry.RegistryTitles;
import com.seniors.justlevelingfork.registry.skills.ConvergenceSkill;
import com.seniors.justlevelingfork.registry.skills.Skill;
import com.seniors.justlevelingfork.registry.skills.TreasureHunterSkill;
import com.seniors.justlevelingfork.registry.title.Title;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="justlevelingfork")
public class RegistryCommonEvents {
    @SubscribeEvent
    public void onPlayerNameFormat(PlayerEvent.NameFormat event) {
        if (JustLevelingFork.server != null && ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).displayTitlesAsPrefix) {
            ServerPlayer serverPlayer = JustLevelingFork.server.m_6846_().m_11259_(event.getEntity().m_20148_());
            if (serverPlayer == null) {
                return;
            }
            AptitudeCapability capability = AptitudeCapability.get((Player)serverPlayer);
            if (capability == null) {
                return;
            }
            Title titleKey = RegistryTitles.getTitle(capability.getPlayerTitle());
            String title = titleKey != null ? Component.m_237115_((String)RegistryTitles.getTitle(capability.getPlayerTitle()).getKey()).getString() : "";
            event.setDisplayname((Component)Component.m_237113_((String)String.format("[%s] %s", title.isEmpty() ? Component.m_237115_((String)((Title)RegistryTitles.TITLELESS.get()).getKey()).getString() : title, event.getDisplayname().getString())));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!(player instanceof FakePlayer)) {
                ConfigSyncCP.sendToPlayer((Player)serverPlayer);
                CommonConfigSyncCP.sendToPlayer((Player)serverPlayer);
                DynamicConfigSyncCP.sendToPlayer((Player)serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        JustLevelingFork.server = event.getServer();
        File oldConfigFile = FMLPaths.CONFIGDIR.get().resolve("just_leveling-common.toml").toFile();
        if (!((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).usingNewConfig && oldConfigFile.exists()) {
            JustLevelingFork.getLOGGER().info("Configuration not migrated yet, starting migration...");
            JustLevelingFork.migrateOldConfig();
        } else if (!((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).usingNewConfig && !oldConfigFile.exists()) {
            ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).usingNewConfig = true;
            HandlerCommonConfig.HANDLER.save();
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        AptitudeLevelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        TitleCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        AptitudesReloadCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        RegisterItem.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        GlobalLimitCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        UpdateAptitudeLevelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
            AptitudeCapability AptitudeCapability2 = new AptitudeCapability();
            LazyAptitudeCapability lazyAptitudeCapability = new LazyAptitudeCapability(AptitudeCapability2);
            event.addCapability(new ResourceLocation("justlevelingfork", "aptitudes"), (ICapabilityProvider)lazyAptitudeCapability);
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(AptitudeCapability.class);
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerNew = (ServerPlayer)player;
            player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerOld = (ServerPlayer)player;
                serverPlayerOld.reviveCaps();
                serverPlayerOld.getCapability(RegistryCapabilities.APTITUDE).ifPresent(oldAbilities -> serverPlayerNew.getCapability(RegistryCapabilities.APTITUDE).ifPresent(newAbilities -> newAbilities.copyFrom((AptitudeCapability)oldAbilities)));
                RegistryAttributes.modifierAttributes(serverPlayerNew);
                RegistryTitles.syncTitles(serverPlayerNew);
                if (!serverPlayerOld.m_21224_()) {
                    serverPlayerNew.m_21153_(serverPlayerOld.m_21223_());
                } else {
                    serverPlayerNew.m_21153_(serverPlayerOld.m_21233_());
                }
                RegistryAttributes.modifierAttributes(serverPlayerOld);
                RegistryTitles.syncTitles(serverPlayerOld);
                serverPlayerOld.invalidateCaps();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        if (!event.getLevel().m_5776_()) {
            Entity entity = event.getEntity();
            if (entity instanceof FakePlayer) {
                return;
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SyncAptitudeCapabilityCP.send((Player)serverPlayer);
                RegistryAttributes.modifierAttributes(serverPlayer);
                RegistryTitles.syncTitles(serverPlayer);
                if (((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).checkForUpdates && ((Boolean)JustLevelingFork.UpdatesAvailable.left).booleanValue() && serverPlayer.m_20310_(2)) {
                    MutableComponent component = Component.m_237113_((String)String.format("[JustLevelingFork] Version %s is available, it's recommended to update!", JustLevelingFork.UpdatesAvailable.right));
                    serverPlayer.m_213846_((Component)component);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        List<String> extractedTypes;
        Player player = event.getEntity();
        if (player.m_7500_() || player instanceof FakePlayer) {
            return;
        }
        ItemStack item = event.getItemStack();
        Block block = event.getLevel().m_8055_(event.getPos()).m_60734_();
        AptitudeCapability provider = AptitudeCapability.get(player);
        if (provider == null) {
            return;
        }
        ResourceLocation location = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
        if (ModList.get().isLoaded("tetra") && TetraIntegration.TetraItems.contains(location.toString()) && !(extractedTypes = TetraIntegration.GetItemTypes(item)).isEmpty()) {
            for (String tetraItem : extractedTypes) {
                if (provider.canUseSpecificID(player, tetraItem)) continue;
                event.setCanceled(true);
                return;
            }
        }
        if (!provider.canUseItem(player, location) || !provider.canUseBlock(player, block)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        List<String> extractedTypes;
        Player player = event.getEntity();
        if (player.m_7500_() || player instanceof FakePlayer) {
            return;
        }
        ItemStack item = event.getItemStack();
        Block block = event.getLevel().m_8055_(event.getPos()).m_60734_();
        AptitudeCapability provider = AptitudeCapability.get(player);
        if (provider == null) {
            return;
        }
        ResourceLocation location = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
        if (ModList.get().isLoaded("tetra") && TetraIntegration.TetraItems.contains(location.toString()) && !(extractedTypes = TetraIntegration.GetItemTypes(item)).isEmpty()) {
            for (String tetraItem : extractedTypes) {
                if (provider.canUseSpecificID(player, tetraItem)) continue;
                event.setCanceled(true);
                return;
            }
        }
        if (!provider.canUseItem(player, location) || !provider.canUseBlock(player, block)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        List<String> extractedTypes;
        Player player = event.getEntity();
        if (player.m_7500_() || player instanceof FakePlayer) {
            return;
        }
        ItemStack item = event.getItemStack();
        AptitudeCapability provider = AptitudeCapability.get(player);
        if (provider == null) {
            return;
        }
        ResourceLocation location = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
        if (ModList.get().isLoaded("tetra") && TetraIntegration.TetraItems.contains(location.toString()) && !(extractedTypes = TetraIntegration.GetItemTypes(item)).isEmpty()) {
            for (String tetraItem : extractedTypes) {
                if (provider.canUseSpecificID(player, tetraItem)) continue;
                event.setCanceled(true);
                return;
            }
        }
        if (!provider.canUseItem(player, location)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        List<String> extractedTypes;
        Player player = event.getEntity();
        if (player.m_7500_() || player instanceof FakePlayer) {
            return;
        }
        Entity entity = event.getTarget();
        ItemStack item = event.getItemStack();
        AptitudeCapability provider = AptitudeCapability.get(player);
        if (provider == null) {
            return;
        }
        ResourceLocation location = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
        if (ModList.get().isLoaded("tetra") && TetraIntegration.TetraItems.contains(location.toString()) && !(extractedTypes = TetraIntegration.GetItemTypes(item)).isEmpty()) {
            for (String tetraItem : extractedTypes) {
                if (provider.canUseSpecificID(player, tetraItem)) continue;
                event.setCanceled(true);
                return;
            }
        }
        if (!provider.canUseEntity(player, entity) || !provider.canUseItem(player, location)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChangeEquipment(LivingEquipmentChangeEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_7500_() && event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
            AptitudeCapability provider = AptitudeCapability.get(player);
            if (provider == null) {
                return;
            }
            ItemStack item = event.getTo();
            if (!provider.canUseItem(player, item)) {
                player.m_36176_(item.m_41777_(), false);
                item.m_41764_(0);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!player.m_7500_() && ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).dropLockedItems) {
            player.getCapability(RegistryCapabilities.APTITUDE).ifPresent(aptitudeCapability -> {
                AptitudeCapability provider = AptitudeCapability.get(player);
                if (provider == null) {
                    return;
                }
                ItemStack hand = player.m_21205_();
                ItemStack offHand = player.m_21206_();
                if (!provider.canUseItem(player, hand)) {
                    player.m_36176_(hand.m_41777_(), false);
                    hand.m_41764_(0);
                }
                if (!provider.canUseItem(player, offHand)) {
                    player.m_36176_(offHand.m_41777_(), false);
                    offHand.m_41764_(0);
                }
            });
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(RegistryCapabilities.APTITUDE).ifPresent(aptitudeCapability -> {
                AptitudeCapability provider = AptitudeCapability.get((Player)serverPlayer);
                if (provider == null) {
                    return;
                }
                if (provider.getCounterAttack()) {
                    provider.setCounterAttackTimer(provider.getCounterAttackTimer() + 1);
                    if (RegistrySkills.COUNTER_ATTACK != null && (double)provider.getCounterAttackTimer() >= ((Skill)RegistrySkills.COUNTER_ATTACK.get()).getValue()[0] * 40.0) {
                        CounterAttackSP.send(false, 0.0f);
                    }
                }
            });
            if (RegistrySkills.ONE_HANDED != null) {
                new RegistryAttributes.registerAttribute((Player)serverPlayer, Attributes.f_22281_, (float)((Skill)RegistrySkills.ONE_HANDED.get()).getValue()[0], UUID.fromString("55550aa2-eff2-4a81-b92b-a1cb95f15555")).amplifyAttribute(serverPlayer.m_21206_().m_41613_() == 0 && ((Skill)RegistrySkills.ONE_HANDED.get()).isEnabled((Player)serverPlayer));
            }
            if (RegistrySkills.DIAMOND_SKIN != null) {
                new RegistryAttributes.registerAttribute((Player)serverPlayer, Attributes.f_22284_, (float)((Skill)RegistrySkills.DIAMOND_SKIN.get()).getValue()[1], UUID.fromString("55550aa2-eff2-4a81-b92b-a1cb95f15556")).amplifyAttribute(serverPlayer.m_6144_() && ((Skill)RegistrySkills.DIAMOND_SKIN.get()).isEnabled((Player)serverPlayer));
            }
            RegistryAttributes.modifierAttributes(serverPlayer);
            if (serverPlayer.m_21223_() > serverPlayer.m_21233_()) {
                serverPlayer.m_21153_(serverPlayer.m_21233_());
            }
            new RegistryEffects.addEffect(serverPlayer, RegistrySkills.CAT_EYES != null && ((Skill)RegistrySkills.CAT_EYES.get()).isEnabled(player), MobEffects.f_19611_).add(210);
            new RegistryEffects.addEffect(serverPlayer, RegistrySkills.DIAMOND_SKIN != null && ((Skill)RegistrySkills.DIAMOND_SKIN.get()).isEnabled(player), MobEffects.f_19606_).add(210, (int)(((Skill)RegistrySkills.DIAMOND_SKIN.get()).getValue()[0] - 1.0));
        }
    }

    @SubscribeEvent
    public void onPlayerTickLow(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side == LogicalSide.SERVER && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RegistryTitles.syncTitles(serverPlayer);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerAttackEntity(AttackEntityEvent event) {
        Entity target = event.getTarget();
        Player player = event.getEntity();
        if (player instanceof FakePlayer) {
            return;
        }
        if (player != null) {
            AptitudeCapability provider = AptitudeCapability.get(player);
            if (!player.m_7500_() && provider != null) {
                ItemStack item = player.m_21205_();
                ResourceLocation location = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
                if (ModList.get().isLoaded("tetra") && TetraIntegration.TetraItems.contains(location.toString())) {
                    List<String> extractedTypes = TetraIntegration.GetItemTypes(item);
                    if (!extractedTypes.isEmpty()) {
                        for (String tetraItem : extractedTypes) {
                            if (provider.canUseSpecificID(player, tetraItem)) continue;
                            event.setCanceled(true);
                        }
                    }
                } else if (!provider.canUseItem(player, item)) {
                    event.setCanceled(true);
                }
            }
            if (event.isCanceled()) {
                return;
            }
            if (RegistrySkills.LIMIT_BREAKER != null) {
                Level level;
                int random = (int)Math.floor(Math.random() * ((Skill)RegistrySkills.LIMIT_BREAKER.get()).getValue()[0]);
                if (((Skill)RegistrySkills.LIMIT_BREAKER.get()).isEnabled(player) && (level = event.getEntity().m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (random == 1) {
                        target.m_6469_(target.m_269291_().m_269075_(player), (float)((Skill)RegistrySkills.LIMIT_BREAKER.get()).getValue()[1]);
                        serverLevel.m_6269_(null, (Entity)player, (SoundEvent)RegistrySounds.LIMIT_BREAKER.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                    }
                }
            }
            if (provider != null && provider.getCounterAttack()) {
                CounterAttackSP.send(false, 0.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerMining(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player instanceof FakePlayer) {
            return;
        }
        float modifier = event.getOriginalSpeed() * (1.0f + (float)player.m_21133_((Attribute)RegistryAttributes.BREAK_SPEED.get()));
        if (player.m_21205_().m_220167_(itemHolder -> itemHolder.get() instanceof PickaxeItem)) {
            if (event.getState().m_204336_(RegistryTags.Blocks.OBSIDIAN)) {
                if (RegistrySkills.OBSIDIAN_SMASHER != null && ((Skill)RegistrySkills.OBSIDIAN_SMASHER.get()).isEnabled(player)) {
                    event.setNewSpeed((float)((double)event.getNewSpeed() * ((Skill)RegistrySkills.OBSIDIAN_SMASHER.get()).getValue()[0]) + modifier);
                } else {
                    event.setNewSpeed(event.getNewSpeed());
                }
            } else {
                event.setNewSpeed(event.getNewSpeed() + modifier);
            }
        }
        if (player.m_21205_().m_220167_(itemHolder -> itemHolder.get() instanceof ShovelItem)) {
            event.setNewSpeed(event.getNewSpeed() + modifier);
        }
        if (player.m_21205_().m_220167_(itemHolder -> itemHolder.get() instanceof AxeItem)) {
            event.setNewSpeed(event.getNewSpeed() + modifier);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerCriticalHit(CriticalHitEvent event) {
        Player player = event.getEntity();
        if (player != null) {
            if (player instanceof FakePlayer) {
                return;
            }
            float damage = event.getDamageModifier();
            float attribute = (float)event.getEntity().m_21133_((Attribute)RegistryAttributes.CRITICAL_DAMAGE.get());
            event.setDamageModifier(damage + attribute);
            if (RegistrySkills.BERSERKER != null && RegistrySkills.BERSERKER.isPresent() && ((Skill)RegistrySkills.BERSERKER.get()).isEnabled(player) && player.m_21223_() <= player.m_21233_() * (float)(((Skill)RegistrySkills.BERSERKER.get()).getValue()[0] / 100.0)) {
                float newDamage = event.getDamageModifier();
                if (player.m_20096_() || player.m_20069_()) {
                    event.setResult(Event.Result.ALLOW);
                    event.setDamageModifier(newDamage * 1.5f);
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (RegistrySkills.CRITICAL_ROLL != null && RegistrySkills.CRITICAL_ROLL.isPresent() && ((Skill)RegistrySkills.CRITICAL_ROLL.get()).isEnabled((Player)serverPlayer) && (event.isVanillaCritical() || RegistrySkills.BERSERKER != null && RegistrySkills.BERSERKER.isPresent() && ((Skill)RegistrySkills.BERSERKER.get()).isEnabled(player) && player.m_21223_() <= player.m_21233_() * (float)(((Skill)RegistrySkills.BERSERKER.get()).getValue()[0] / 100.0))) {
                    float newDamage = event.getDamageModifier();
                    int dice = (int)Math.floor(Math.random() * 7.0);
                    if (dice == 1) {
                        PlayerMessagesCP.send((Player)serverPlayer, "overlay.skill.justlevelingfork.critical_roll_1", 0);
                        event.setDamageModifier(newDamage / (1.0f + 1.0f / (float)((Skill)RegistrySkills.CRITICAL_ROLL.get()).getValue()[1]));
                    }
                    if (dice == 6) {
                        PlayerMessagesCP.send((Player)serverPlayer, "overlay.skill.justlevelingfork.critical_roll_6", 0);
                        event.setDamageModifier(newDamage * (float)((Skill)RegistrySkills.CRITICAL_ROLL.get()).getValue()[0]);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackEntity(LivingHurtEvent event) {
        LivingEntity livingEntity;
        Entity source;
        if (event.getSource() != null && (source = event.getSource().m_7639_()) instanceof LivingEntity && (livingEntity = (LivingEntity)source).m_21051_(Attributes.f_22281_) != null) {
            ServerPlayer player;
            AptitudeCapability provider;
            float sourceDamage = (float)livingEntity.m_21133_(Attributes.f_22281_);
            LivingEntity livingEntity1 = event.getEntity();
            if (livingEntity1 instanceof FakePlayer) {
                return;
            }
            if (livingEntity1 instanceof ServerPlayer && (provider = AptitudeCapability.get((Player)(player = (ServerPlayer)livingEntity1))) != null && !event.isCanceled() && RegistrySkills.COUNTER_ATTACK != null && ((Skill)RegistrySkills.COUNTER_ATTACK.get()).isEnabled((Player)player)) {
                player.getCapability(RegistryCapabilities.APTITUDE).ifPresent(aptitudeCapability -> CounterAttackSP.sendToPlayer(true, (float)((double)sourceDamage * ((Skill)RegistrySkills.COUNTER_ATTACK.get()).getValue()[1] / 100.0), player));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerShootArrow(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof Arrow) {
            Arrow arrow = (Arrow)projectile;
            Entity entity = projectile.m_19749_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                double baseDamage = arrow.m_36789_();
                double arrowDamage = baseDamage + player.m_21133_((Attribute)RegistryAttributes.PROJECTILE_DAMAGE.get()) / 5.0;
                arrow.m_36781_(arrowDamage);
                if (RegistrySkills.STEALTH_MASTERY != null && ((Skill)RegistrySkills.STEALTH_MASTERY.get()).isEnabled(player) && player.m_6144_()) {
                    arrow.m_36781_(arrowDamage + baseDamage * (((Skill)RegistrySkills.STEALTH_MASTERY.get()).getValue()[2] - 1.0));
                }
            }
            if ((entity = event.getProjectile().m_19749_()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY) {
                    new RegistryEffects.addEffect(serverPlayer, RegistrySkills.QUICK_REPOSITION != null && ((Skill)RegistrySkills.QUICK_REPOSITION.get()).isEnabled((Player)serverPlayer), MobEffects.f_19596_).add((int)(10.0 + 20.0 * ((Skill)RegistrySkills.QUICK_REPOSITION.get()).getValue()[1]), (int)(((Skill)RegistrySkills.QUICK_REPOSITION.get()).getValue()[0] - 1.0));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onArrowNockEvent(ArrowNockEvent event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        ItemStack projectile = player.m_6298_(event.getBow());
        AptitudeCapability provider = AptitudeCapability.get(player);
        if (provider != null && !provider.canUseItem(player, projectile)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(EntityTeleportEvent.EnderPearl event) {
        Entity entity;
        if (event.getEntity() != null && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (RegistrySkills.SAFE_PORT != null && ((Skill)RegistrySkills.SAFE_PORT.get()).isEnabled(player)) {
                event.setAttackDamage(0.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof FakePlayer) {
            return;
        }
        if (RegistrySkills.TREASURE_HUNTER != null && player != null && event.getState().m_204336_(RegistryTags.Blocks.DIRT) && ((Skill)RegistrySkills.TREASURE_HUNTER.get()).isEnabled(player)) {
            Level level = player.m_9236_();
            BlockPos pos = event.getPos();
            ItemStack stack = TreasureHunterSkill.drop();
            if (stack != null) {
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
                RegistryCommonEvents.enqueueTask(level, () -> level.m_7967_((Entity)itemEntity), 0);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerCraft(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (player != null && RegistrySkills.CONVERGENCE != null) {
            ItemStack convergenceItem;
            if (player instanceof FakePlayer) {
                return;
            }
            int randomizer = (int)Math.floor(Math.random() * ((Skill)RegistrySkills.CONVERGENCE.get()).getValue()[0]);
            if (((Skill)RegistrySkills.CONVERGENCE.get()).isEnabled(player) && (((Skill)RegistrySkills.CONVERGENCE.get()).getValue()[0] >= 100.0 || randomizer == 1) && (convergenceItem = ConvergenceSkill.drop(event.getCrafting())) != null) {
                player.m_36176_(convergenceItem, false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDrops(LivingDropsEvent event) {
        if (event.getEntity() != null) {
            Entity entity;
            Player player;
            Entity entity1;
            if (!(event.getEntity() instanceof Player) && (entity1 = event.getSource().m_7639_()) instanceof Player) {
                player = (Player)entity1;
                if (RegistrySkills.FIGHTING_SPIRIT != null) {
                    new RegistryEffects.addEffect((ServerPlayer)player, ((Skill)RegistrySkills.FIGHTING_SPIRIT.get()).isEnabled(player), MobEffects.f_19600_).add((int)(10.0 + 20.0 * ((Skill)RegistrySkills.FIGHTING_SPIRIT.get()).getValue()[1]), (int)(((Skill)RegistrySkills.FIGHTING_SPIRIT.get()).getValue()[0] - 1.0));
                }
            }
            if ((entity = event.getSource().m_7639_()) instanceof Player) {
                player = (Player)entity;
                if (RegistrySkills.LIFE_EATER != null && ((Skill)RegistrySkills.LIFE_EATER.get()).isEnabled(player)) {
                    player.m_5634_((float)((Skill)RegistrySkills.LIFE_EATER.get()).getValue()[0]);
                }
            }
            if (!(event.getEntity() instanceof Player) && (entity = event.getSource().m_7639_()) instanceof Player) {
                int random;
                player = (Player)entity;
                if (RegistrySkills.LUCKY_DROP != null && ((Skill)RegistrySkills.LUCKY_DROP.get()).isEnabled(player) && (random = (int)Math.floor(Math.random() * ((Skill)RegistrySkills.LUCKY_DROP.get()).getValue()[0])) == 0) {
                    ArrayList<ItemStack> equipment = new ArrayList<ItemStack>();
                    for (ItemStack next : event.getEntity().m_20158_()) {
                        equipment.add(next);
                    }
                    BlockPos pos = event.getEntity().m_20183_();
                    RegistryCommonEvents.enqueueTask(event.getEntity().m_9236_(), () -> {
                        ArrayList<ItemEntity> dropEntities = new ArrayList<ItemEntity>();
                        for (Entity ea : event.getEntity().m_9236_().m_45933_(null, new AABB((double)(pos.m_123341_() - 1), (double)(pos.m_123342_() - 1), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)))) {
                            if (!(ea instanceof ItemEntity)) continue;
                            dropEntities.add((ItemEntity)ea);
                        }
                        for (ItemEntity dropEntity : dropEntities) {
                            ItemStack itemStack;
                            int tickCount = dropEntity.f_19797_;
                            if (tickCount > 1 || equipment.contains(itemStack = dropEntity.m_32055_())) continue;
                            if (itemStack.m_41741_() > 1) {
                                itemStack.m_41764_(itemStack.m_41613_() * (int)((Skill)RegistrySkills.LUCKY_DROP.get()).getValue()[1]);
                            }
                            PlayerMessagesCP.send(player, "overlay.skill.justlevelingfork.lucky_drop", (int)((Skill)RegistrySkills.LUCKY_DROP.get()).getValue()[1]);
                            dropEntity.m_32045_(itemStack);
                        }
                    }, 0);
                }
            }
        }
    }

    public static void enqueueTask(Level world, Runnable task, int delay) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        MinecraftServer server = ((ServerLevel)world).m_7654_();
        server.m_18707_((Runnable)new TickTask(server.m_129921_() + delay, task));
    }
}

