/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.registry;

import com.seniors.justlevelingfork.registry.RegistryCapabilities;
import com.seniors.justlevelingfork.registry.RegistryPassives;
import com.seniors.justlevelingfork.registry.passive.Passive;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class RegistryAttributes {
    private static final DeferredRegister<Attribute> REGISTER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ATTRIBUTES, (String)"justlevelingfork");
    public static final RegistryObject<Attribute> BREAK_SPEED = REGISTER.register("break_speed", () -> new RangedAttribute("break_speed", 0.0, 0.0, 1024.0).m_22084_(true));
    public static final RegistryObject<Attribute> CRITICAL_DAMAGE = REGISTER.register("critical_damage", () -> new RangedAttribute("critical_damage", 0.0, 0.0, 1024.0).m_22084_(true));
    public static final RegistryObject<Attribute> PROJECTILE_DAMAGE = REGISTER.register("projectile_damage", () -> new RangedAttribute("projectile_damage", 0.0, 0.0, 1024.0).m_22084_(true));
    public static final RegistryObject<Attribute> BENEFICIAL_EFFECT = REGISTER.register("beneficial_effect", () -> new RangedAttribute("beneficial_effect", 0.0, 0.0, 1024.0).m_22084_(true));
    public static final RegistryObject<Attribute> MAGIC_RESIST = REGISTER.register("magic_resist", () -> new RangedAttribute("magic_resist", 0.0, 0.0, 1024.0).m_22084_(true));

    public static void load(IEventBus eventBus) {
        REGISTER.register(eventBus);
    }

    public static void modifierAttributes(ServerPlayer serverPlayer) {
        serverPlayer.getCapability(RegistryCapabilities.APTITUDE).ifPresent(aptitudeCapability -> {
            for (int i = 0; i < RegistryPassives.PASSIVES_REGISTRY.get().getValues().stream().toList().size(); ++i) {
                Passive passive = (Passive)RegistryPassives.PASSIVES_REGISTRY.get().getValues().stream().toList().get(i);
                new registerAttribute((Player)serverPlayer, passive.attribute, passive.getValue() / (double)passive.levelsRequired.length * (double)passive.getLevel((Player)serverPlayer), UUID.fromString(passive.attributeUuid)).amplifyAttribute(true);
            }
        });
    }

    public static class registerAttribute {
        private final Player player;
        private final Attribute attribute;
        private final double modifier;
        private final UUID uuid;

        public registerAttribute(Player player, Attribute attribute, double modifier, UUID uuid) {
            this.player = player;
            this.attribute = attribute;
            this.modifier = modifier;
            this.uuid = uuid;
        }

        public void amplifyAttribute(boolean isEnabled) {
            AttributeInstance instance = this.player.m_21051_(this.attribute);
            if (instance == null) {
                return;
            }
            AttributeModifier oldModifier = instance.m_22111_(this.uuid);
            if (oldModifier != null) {
                instance.m_22130_(oldModifier);
            }
            AttributeModifier newModifier = new AttributeModifier(this.uuid, "justlevelingfork", this.modifier, AttributeModifier.Operation.ADDITION);
            if (isEnabled) {
                instance.m_22125_(newModifier);
            } else {
                instance.m_22130_(newModifier);
            }
        }
    }
}

