/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.network.packet.common;

import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.network.ServerNetworking;
import com.seniors.justlevelingfork.network.packet.client.SyncAptitudeCapabilityCP;
import com.seniors.justlevelingfork.registry.RegistryAttributes;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class CounterAttackSP {
    private final boolean isCounterAttack;
    private final float modifier;

    public CounterAttackSP(boolean isCounterAttack, float modifier) {
        this.isCounterAttack = isCounterAttack;
        this.modifier = modifier;
    }

    public CounterAttackSP(FriendlyByteBuf buffer) {
        this.isCounterAttack = buffer.readBoolean();
        this.modifier = buffer.readFloat();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isCounterAttack);
        buffer.writeFloat(this.modifier);
    }

    public static void handle(CounterAttackSP msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                AptitudeCapability aptitude = AptitudeCapability.get((Player)player);
                aptitude.setCounterAttack(msg.isCounterAttack);
                new RegistryAttributes.registerAttribute((Player)player, Attributes.f_22281_, msg.modifier, UUID.fromString("55550aa2-eff2-4a81-b92b-a1cb95f15590")).amplifyAttribute(true);
                if (!msg.isCounterAttack) {
                    aptitude.setCounterAttackTimer(0);
                }
                SyncAptitudeCapabilityCP.send((Player)player);
            }
        });
        context.setPacketHandled(true);
    }

    public static void send(boolean isCounterAttack, float modifier) {
        ServerNetworking.sendToServer(new CounterAttackSP(isCounterAttack, modifier));
    }

    public static void sendToPlayer(boolean isCounterAttack, float modifier, ServerPlayer serverPlayer) {
        ServerNetworking.sendToPlayer(new CounterAttackSP(isCounterAttack, modifier), serverPlayer);
    }
}

