/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.network.packet.common;

import com.seniors.justlevelingfork.JustLevelingFork;
import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.handler.HandlerCommonConfig;
import com.seniors.justlevelingfork.network.ServerNetworking;
import com.seniors.justlevelingfork.network.packet.client.SyncAptitudeCapabilityCP;
import com.seniors.justlevelingfork.registry.RegistryAptitudes;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class AptitudeLevelUpSP {
    private final String aptitude;

    public AptitudeLevelUpSP(Aptitude aptitude) {
        this.aptitude = aptitude.getName();
    }

    public AptitudeLevelUpSP(FriendlyByteBuf buffer) {
        this.aptitude = buffer.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.aptitude);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                boolean canLevelUpAptitude;
                AptitudeCapability capability = AptitudeCapability.get((Player)player);
                Aptitude aptitudePlayer = RegistryAptitudes.getAptitude(this.aptitude);
                int aptitudeLevel = capability.getAptitudeLevel(aptitudePlayer);
                boolean bl = canLevelUpAptitude = player.m_7500_() || AptitudeLevelUpSP.requiredPoints(aptitudeLevel) <= player.f_36079_ || AptitudeLevelUpSP.requiredExperienceLevels(aptitudeLevel) <= player.f_36078_;
                if (!canLevelUpAptitude) {
                    JustLevelingFork.getLOGGER().info("Received level up packet without the required EXP needed to level up, skipping packet...");
                    return;
                }
                int requiredPoints = AptitudeLevelUpSP.requiredPoints(aptitudeLevel);
                capability.addAptitudeLevel(aptitudePlayer, 1);
                SyncAptitudeCapabilityCP.send((Player)player);
                if (!player.m_7500_()) {
                    this.addPlayerXP((Player)player, requiredPoints * -1);
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static int getPlayerXP(Player player) {
        return (int)((float)AptitudeLevelUpSP.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public void addPlayerXP(Player player, int amount) {
        int experience;
        player.f_36079_ = experience = AptitudeLevelUpSP.getPlayerXP(player) + amount;
        player.f_36078_ = AptitudeLevelUpSP.getLevelForExperience(experience);
        int expForLevel = AptitudeLevelUpSP.getExperienceForLevel(player.f_36078_);
        player.f_36080_ = (float)(experience - expForLevel) / (float)player.m_36323_();
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = AptitudeLevelUpSP.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static int requiredPoints(int aptitudeLevel) {
        return AptitudeLevelUpSP.getExperienceForLevel(aptitudeLevel + ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).aptitudeFirstCostLevel - 1);
    }

    public static int requiredExperienceLevels(int aptitudeLevel) {
        return aptitudeLevel + ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).aptitudeFirstCostLevel - 1;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return AptitudeLevelUpSP.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + AptitudeLevelUpSP.sum(level - 15, 37, 5);
        }
        return 1395 + AptitudeLevelUpSP.sum(level - 30, 112, 9);
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static void send(Aptitude aptitude) {
        ServerNetworking.sendToServer(new AptitudeLevelUpSP(aptitude));
    }
}

