/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.mixin;

import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.client.AttackRangeExtensions;
import net.bettercombat.client.collision.OrientedBoundingBox;
import net.bettercombat.client.collision.TargetFinder;
import net.bettercombat.client.collision.WeaponHitBoxes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TargetFinder.class})
public abstract class MixTargetFinder {
    @Inject(method={"findAttackTargetResult"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void findAttackTargetResult(Player player, Entity cursorTarget, WeaponAttributes.Attack attack, double attackRange, CallbackInfoReturnable<TargetFinder.TargetResult> info) {
        AttributeInstance playerReach;
        if (player == null || cursorTarget == null || !ForgeMod.ENTITY_REACH.isPresent()) {
            return;
        }
        Vec3 origin = TargetFinder.getInitialTracingPoint((Player)player);
        List entities = TargetFinder.getInitialTargets((Player)player, (Entity)cursorTarget, (double)attackRange);
        if (!AttackRangeExtensions.sources().isEmpty()) {
            attackRange = MixTargetFinder.apply$AttackRangeModifiers(player, attackRange);
        }
        if ((playerReach = player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get())) == null) {
            return;
        }
        AttributeModifier modifier = playerReach.m_22111_(UUID.fromString("96a891fe-5919-418d-8205-f50464391509"));
        if (modifier == null) {
            return;
        }
        info.cancel();
        attackRange += modifier.m_22218_();
        if (ModList.get().isLoaded("quality_equipment")) {
            attackRange += 3.0;
        }
        boolean isSpinAttack = attack.angle() > 180.0;
        Vec3 size = WeaponHitBoxes.createHitbox((WeaponAttributes.HitBoxShape)attack.hitbox(), (double)attackRange, (boolean)isSpinAttack);
        OrientedBoundingBox obb = new OrientedBoundingBox(origin, size, player.m_146909_(), player.m_146908_());
        if (!isSpinAttack) {
            obb = obb.offsetAlongAxisZ(size.f_82481_ / 2.0);
        }
        obb.updateVertex();
        TargetFinder.CollisionFilter collisionFilter = new TargetFinder.CollisionFilter(obb);
        entities = collisionFilter.filter(entities);
        TargetFinder.RadialFilter radialFilter = new TargetFinder.RadialFilter(origin, obb.axisZ, attackRange, attack.angle());
        entities = radialFilter.filter(entities);
        info.setReturnValue((Object)new TargetFinder.TargetResult(entities, obb));
    }

    @Unique
    private static double apply$AttackRangeModifiers(Player player, double attackRange) {
        AttackRangeExtensions.Context context = new AttackRangeExtensions.Context(player, attackRange);
        List<AttackRangeExtensions.Modifier> modifiers = AttackRangeExtensions.sources().stream().map(function -> (AttackRangeExtensions.Modifier)function.apply(context)).sorted(Comparator.comparingInt(AttackRangeExtensions.Modifier::operationOrder)).toList();
        double result = attackRange;
        for (AttackRangeExtensions.Modifier modifier : modifiers) {
            switch (modifier.operation()) {
                case ADD: {
                    result += modifier.value();
                }
                case MULTIPLY: {
                    result *= modifier.value();
                }
            }
        }
        return result;
    }
}

