/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.mixin;

import com.seniors.justlevelingfork.registry.RegistryAttributes;
import com.seniors.justlevelingfork.registry.RegistrySkills;
import com.seniors.justlevelingfork.registry.skills.Skill;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.PotionItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixLivingEntity {
    @Shadow
    @Final
    private Map<MobEffect, MobEffectInstance> f_20945_;
    @Unique
    LivingEntity this$class = (LivingEntity)this;

    @Shadow
    protected abstract void m_142540_(MobEffectInstance var1, @Nullable Entity var2);

    @Shadow
    protected abstract void m_141973_(MobEffectInstance var1, boolean var2, @Nullable Entity var3);

    @Shadow
    public abstract boolean m_7301_(MobEffectInstance var1);

    @Shadow
    @Deprecated
    public abstract boolean m_6040_();

    @ModifyVariable(method={"getDamageAfterArmorAbsorb"}, at=@At(value="HEAD"), argsOnly=true)
    private float additionalEntityAttributes$reduceMagicDamage(float damage, DamageSource source) {
        AttributeInstance magicResist = this.this$class.m_21051_((Attribute)RegistryAttributes.MAGIC_RESIST.get());
        if (magicResist == null) {
            return damage;
        }
        if (source.m_269014_() && magicResist.m_22135_() > 0.0) {
            damage = (float)((double)damage - (double)damage * magicResist.m_22135_());
        }
        return damage;
    }

    @Inject(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z", opcode=181)}, cancellable=true)
    public final void onAddEffect(MobEffectInstance effect, CallbackInfoReturnable<Boolean> info) {
        LivingEntity var4 = this.this$class;
        if (var4 instanceof Player) {
            Player player = (Player)var4;
            info.cancel();
            info.setReturnValue((Object)this.this$onDrinkPotion(effect, player));
        }
    }

    @Inject(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;canBeAffected(Lnet/minecraft/world/effect/MobEffectInstance;)Z", opcode=181)}, cancellable=true)
    public final void onAddEffect(MobEffectInstance effect, Entity source, CallbackInfoReturnable<Boolean> info) {
        LivingEntity var5 = this.this$class;
        if (var5 instanceof Player) {
            Player player = (Player)var5;
            info.cancel();
            info.setReturnValue((Object)this.this$onAddEffect(effect, player));
        }
    }

    @Unique
    private boolean this$onAddEffect(MobEffectInstance effect, Player player) {
        int duration = effect.m_19557_();
        if (effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL && RegistrySkills.LION_HEART != null && ((Skill)RegistrySkills.LION_HEART.get()).isEnabled(player)) {
            duration -= (int)((double)effect.m_19557_() * ((Skill)RegistrySkills.LION_HEART.get()).getValue()[0] / 100.0);
        }
        MobEffectInstance newEffect = new MobEffectInstance(effect.m_19544_(), duration, effect.m_19564_());
        if (!this.m_7301_(effect)) {
            return false;
        }
        MobEffectInstance mobeffectinstance = this.f_20945_.get(effect.m_19544_());
        MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Added(this.this$class, mobeffectinstance, effect, (Entity)player));
        if (mobeffectinstance == null) {
            this.f_20945_.put(newEffect.m_19544_(), newEffect);
            this.m_142540_(newEffect, (Entity)player);
            return true;
        }
        if (mobeffectinstance.m_19558_(effect)) {
            this.m_141973_(newEffect, true, (Entity)player);
            return true;
        }
        return false;
    }

    @Unique
    private boolean this$onDrinkPotion(MobEffectInstance effect, Player player) {
        int duration = effect.m_19557_();
        int amplifier = effect.m_19564_();
        if (effect.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL && player.m_6117_() && (player.m_21205_().m_41720_() instanceof PotionItem || player.m_21206_().m_41720_() instanceof PotionItem)) {
            if (RegistrySkills.ALCHEMY_MANIPULATION != null && ((Skill)RegistrySkills.ALCHEMY_MANIPULATION.get()).isEnabled(player)) {
                amplifier += (int)((Skill)RegistrySkills.ALCHEMY_MANIPULATION.get()).getValue()[0];
            }
            float newDuration = (int)(player.m_21133_((Attribute)RegistryAttributes.BENEFICIAL_EFFECT.get()) * 20.0);
            duration = (int)((float)duration + newDuration);
        }
        MobEffectInstance newEffect = new MobEffectInstance(effect.m_19544_(), duration, amplifier);
        if (!this.m_7301_(effect)) {
            return false;
        }
        MobEffectInstance mobeffectinstance = this.f_20945_.get(effect.m_19544_());
        MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Added(this.this$class, mobeffectinstance, effect, (Entity)player));
        if (mobeffectinstance == null) {
            this.f_20945_.put(newEffect.m_19544_(), newEffect);
            this.m_142540_(newEffect, (Entity)player);
            return true;
        }
        if (mobeffectinstance.m_19558_(effect)) {
            this.m_141973_(newEffect, true, (Entity)player);
            return true;
        }
        return false;
    }

    @Inject(method={"getVisibilityPercent"}, at={@At(value="TAIL")}, cancellable=true)
    public void getVisibilityPercent(Entity source, CallbackInfoReturnable<Double> cir) {
        double visibilityPercent = (Double)cir.getReturnValue();
        LivingEntity var6 = this.this$class;
        if (var6 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)var6;
            if (RegistrySkills.STEALTH_MASTERY != null) {
                double isSneaking;
                double d = isSneaking = player.m_6144_() ? ((Skill)RegistrySkills.STEALTH_MASTERY.get()).getValue()[0] : ((Skill)RegistrySkills.STEALTH_MASTERY.get()).getValue()[1];
                if (((Skill)RegistrySkills.STEALTH_MASTERY.get()).isEnabled((Player)player)) {
                    cir.setReturnValue((Object)(visibilityPercent * isSneaking / 100.0));
                }
            }
        }
    }
}

