/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.integration;

import com.seniors.justlevelingfork.JustLevelingFork;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.module.data.VariantData;
import se.mickelus.tetra.util.TierHelper;

public class TetraIntegration {
    private static final String _prefix = "tetra*tier*";
    public static final List<String> TetraItems = List.of("tetra:modular_double", "tetra:modular_single", "tetra:modular_sword", "tetra:modular_shield", "tetra:modular_bow", "tetra:modular_crossbow");

    public static List<String> GetItemTypes(ItemStack item) {
        ArrayList<String> list = new ArrayList<String>();
        Item item2 = item.m_41720_();
        if (item2 instanceof ItemModularHandheld) {
            ItemModularHandheld modularHandheld = (ItemModularHandheld)item2;
            Set toolActions = modularHandheld.getToolActions(item);
            block17: for (int i = 0; i < toolActions.size(); ++i) {
                ToolAction action = (ToolAction)toolActions.stream().toList().get(i);
                String actionName = action.name();
                Tier tier = TierHelper.getTier((int)modularHandheld.getHarvestTier(item, action));
                if (tier == null) {
                    JustLevelingFork.getLOGGER().warn("Item {} with action {} have a null tier.", (Object)item.m_41611_().toString(), (Object)actionName);
                    continue;
                }
                switch (actionName) {
                    case "axe_wax_off": 
                    case "axe_scrape": 
                    case "axe_dig": 
                    case "axe_strip": {
                        list.add(String.format("%saxe:%s", _prefix, tier.toString().toLowerCase()));
                        continue block17;
                    }
                    case "pickaxe_dig": {
                        list.add(String.format("%spickaxe:%s", _prefix, tier.toString().toLowerCase()));
                        continue block17;
                    }
                    case "shovel_dig": {
                        list.add(String.format("%sshovel:%s", _prefix, tier.toString().toLowerCase()));
                        continue block17;
                    }
                    case "hoe_dig": {
                        list.add(String.format("%shoe:%s", _prefix, tier.toString().toLowerCase()));
                        continue block17;
                    }
                    case "cut": {
                        modularHandheld.getAllModules(item).stream().filter(c -> c.getKey().startsWith("sword/")).forEach(c -> {
                            VariantData variantData = c.getVariantData(item);
                            if (variantData != null && !Objects.equals(variantData.category, "misc")) {
                                String material = variantData.key.split("/")[1];
                                list.add(String.format("%ssword:%s", _prefix, material.toLowerCase()));
                            }
                        });
                    }
                }
            }
        }
        return list;
    }
}

