/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.config.conditions;

import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.config.conditions.ConditionImpl;
import com.seniors.justlevelingfork.config.models.EAptitude;
import com.seniors.justlevelingfork.config.models.TitleModel;
import com.seniors.justlevelingfork.registry.RegistryAptitudes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;

public class AptitudeCondition
extends ConditionImpl<Integer> {
    public AptitudeCondition() {
        super("Aptitude");
    }

    @Override
    public void ProcessVariable(String value, ServerPlayer serverPlayer) {
        EAptitude aptitude = EAptitude.valueOf(StringUtils.capitalize((String)value));
        int aptitudeLevel = AptitudeCapability.get((Player)serverPlayer).getAptitudeLevel(RegistryAptitudes.getAptitude(aptitude.toString()));
        this.setProcessedValue(aptitudeLevel);
    }

    @Override
    public boolean MeetCondition(String value, TitleModel.EComparator comparator) {
        int parsedValue = Integer.parseInt(value);
        return switch (comparator) {
            case TitleModel.EComparator.EQUALS -> ((Integer)this.getProcessedValue()).equals(parsedValue);
            case TitleModel.EComparator.GREATER -> {
                if ((Integer)this.getProcessedValue() > parsedValue) {
                    yield true;
                }
                yield false;
            }
            case TitleModel.EComparator.LESS -> {
                if ((Integer)this.getProcessedValue() < parsedValue) {
                    yield true;
                }
                yield false;
            }
            case TitleModel.EComparator.GREATER_OR_EQUAL -> {
                if ((Integer)this.getProcessedValue() >= parsedValue) {
                    yield true;
                }
                yield false;
            }
            case TitleModel.EComparator.LESS_OR_EQUAL -> {
                if ((Integer)this.getProcessedValue() <= parsedValue) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

