/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.common.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.seniors.justlevelingfork.registry.RegistryTitles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TitleArgument
implements ArgumentType<ResourceLocation> {
    public static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_TITLE = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"commands.argument.title.not_found", (Object[])new Object[]{object}));

    public static TitleArgument getArgument() {
        return new TitleArgument();
    }

    public static ResourceLocation getTitle(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return TitleArgument.getResource((ResourceLocation)context.getArgument(name, ResourceLocation.class));
    }

    public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
        return TitleArgument.getResource(ResourceLocation.m_135818_((StringReader)reader));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        RegistryTitles.TITLES_REGISTRY.get().getValues().forEach(conduit -> builder.suggest(Objects.requireNonNull(RegistryTitles.TITLES_REGISTRY.get().getKey(conduit)).toString()));
        return builder.buildFuture();
    }

    public static ResourceLocation getResource(ResourceLocation registryName) throws CommandSyntaxException {
        if (RegistryTitles.TITLES_REGISTRY.get().containsKey(registryName)) {
            return registryName;
        }
        throw ERROR_UNKNOWN_TITLE.create((Object)registryName);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

