/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.common.command.arguments.AptitudeArgument;
import com.seniors.justlevelingfork.handler.HandlerCommonConfig;
import com.seniors.justlevelingfork.network.packet.client.SyncAptitudeCapabilityCP;
import com.seniors.justlevelingfork.registry.RegistryAptitudes;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class AptitudeLevelCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"aptitudes").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"aptitude", (ArgumentType)AptitudeArgument.getArgument()).then(Commands.m_82127_((String)"get").executes(source -> AptitudeLevelCommand.getAptitude((CommandContext<CommandSourceStack>)source, EntityArgument.m_91474_((CommandContext)source, (String)"player"), (String)source.getArgument("aptitude", String.class))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).aptitudeMaxLevel)).executes(source -> AptitudeLevelCommand.setAptitude((CommandContext<CommandSourceStack>)source, EntityArgument.m_91474_((CommandContext)source, (String)"player"), (String)source.getArgument("aptitude", String.class), IntegerArgumentType.getInteger((CommandContext)source, (String)"level")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).aptitudeMaxLevel)).executes(source -> AptitudeLevelCommand.addAptitude((CommandContext<CommandSourceStack>)source, EntityArgument.m_91474_((CommandContext)source, (String)"player"), (String)source.getArgument("aptitude", String.class), IntegerArgumentType.getInteger((CommandContext)source, (String)"level")))))).then(Commands.m_82127_((String)"subtract").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).aptitudeMaxLevel)).executes(source -> AptitudeLevelCommand.subtractAptitude((CommandContext<CommandSourceStack>)source, EntityArgument.m_91474_((CommandContext)source, (String)"player"), (String)source.getArgument("aptitude", String.class), IntegerArgumentType.getInteger((CommandContext)source, (String)"level"))))))));
    }

    public static int getAptitude(CommandContext<CommandSourceStack> source, ServerPlayer player, String aptitudeKey) {
        Aptitude aptitude = RegistryAptitudes.getAptitude(aptitudeKey);
        if (player != null && aptitude != null) {
            AptitudeCapability capability = AptitudeCapability.get((Player)player);
            if (capability == null) {
                ((CommandSourceStack)source.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.message.capability.not_found"));
                return 0;
            }
            ((CommandSourceStack)source.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.message.aptitude.get", (Object[])new Object[]{player.m_7755_().m_6881_().m_130940_(ChatFormatting.BOLD), Component.m_237113_((String)String.valueOf(capability.getAptitudeLevel(aptitude))).m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)aptitude.getKey()).m_130940_(ChatFormatting.BOLD)}), false);
            return 1;
        }
        return 0;
    }

    public static int setAptitude(CommandContext<CommandSourceStack> source, ServerPlayer player, String aptitudeKey, int setLevel) {
        Aptitude aptitude = RegistryAptitudes.getAptitude(aptitudeKey);
        if (player != null && aptitude != null) {
            AptitudeCapability capability = AptitudeCapability.get((Player)player);
            if (capability == null) {
                ((CommandSourceStack)source.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.message.capability.not_found"));
                return 0;
            }
            capability.setAptitudeLevel(aptitude, setLevel);
            SyncAptitudeCapabilityCP.send((Player)player);
            ((CommandSourceStack)source.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.message.aptitude.set", (Object[])new Object[]{player.m_7755_().m_6881_().m_130940_(ChatFormatting.BOLD), Component.m_237113_((String)String.valueOf(capability.getAptitudeLevel(aptitude))).m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)aptitude.getKey()).m_130940_(ChatFormatting.BOLD)}), false);
            return 1;
        }
        return 0;
    }

    public static int addAptitude(CommandContext<CommandSourceStack> source, ServerPlayer player, String aptitudeKey, int addLevel) {
        Aptitude aptitude = RegistryAptitudes.getAptitude(aptitudeKey);
        if (player != null && aptitude != null) {
            AptitudeCapability capability = AptitudeCapability.get((Player)player);
            if (capability == null) {
                ((CommandSourceStack)source.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.message.capability.not_found"));
                return 0;
            }
            int actualLevel = capability.getAptitudeLevel(aptitude);
            capability.setAptitudeLevel(aptitude, actualLevel + addLevel > ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).aptitudeMaxLevel ? ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).aptitudeMaxLevel : actualLevel + addLevel);
            SyncAptitudeCapabilityCP.send((Player)player);
            ((CommandSourceStack)source.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.message.aptitude.set", (Object[])new Object[]{player.m_7755_().m_6881_().m_130940_(ChatFormatting.BOLD), Component.m_237113_((String)String.valueOf(capability.getAptitudeLevel(aptitude))).m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)aptitude.getKey()).m_130940_(ChatFormatting.BOLD)}), false);
            return 1;
        }
        return 0;
    }

    public static int subtractAptitude(CommandContext<CommandSourceStack> source, ServerPlayer player, String aptitudeKey, int subtractLevel) {
        Aptitude aptitude = RegistryAptitudes.getAptitude(aptitudeKey);
        if (player != null && aptitude != null) {
            AptitudeCapability capability = AptitudeCapability.get((Player)player);
            if (capability == null) {
                ((CommandSourceStack)source.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.message.capability.not_found"));
                return 0;
            }
            int actualLevel = capability.getAptitudeLevel(aptitude);
            capability.setAptitudeLevel(aptitude, Math.max(actualLevel - subtractLevel, 1));
            SyncAptitudeCapabilityCP.send((Player)player);
            ((CommandSourceStack)source.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.message.aptitude.set", (Object[])new Object[]{player.m_7755_().m_6881_().m_130940_(ChatFormatting.BOLD), Component.m_237113_((String)String.valueOf(capability.getAptitudeLevel(aptitude))).m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)aptitude.getKey()).m_130940_(ChatFormatting.BOLD)}), false);
            return 1;
        }
        return 0;
    }
}

