/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.content.caravan;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.caravans.content.IWeighted;
import dev.obscuria.caravans.content.caravan.CaravanVariation;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record CaravanPool(int weight, @Unmodifiable List<Entry> variations) implements IWeighted
{
    public static final Codec<CaravanPool> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("weight").forGetter(CaravanPool::weight), (App)Entry.CODEC.listOf().fieldOf("variations").forGetter(CaravanPool::variations)).apply((Applicative)codec, CaravanPool::new));

    @Nullable
    public Holder<CaravanVariation> getRandomVariation(RandomSource random) {
        Entry entry = IWeighted.pickRandom(this.variations, random);
        return entry == null ? null : entry.variation();
    }

    public record Entry(int weight, Holder<CaravanVariation> variation) implements IWeighted
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("weight").forGetter(Entry::weight), (App)CaravanVariation.CODEC.fieldOf("variation").forGetter(Entry::variation)).apply((Applicative)codec, Entry::new));
    }
}

