/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particle_effects.manager;

import com.leclowndu93150.particle_effects.ParticleEffects;
import com.leclowndu93150.particle_effects.config.ParticleEffectsConfig;
import com.leclowndu93150.particle_effects.network.NetworkHandler;
import com.leclowndu93150.particle_effects.utils.ArgbUtils;
import com.leclowndu93150.particle_effects.utils.PEStatusEffect;
import com.leclowndu93150.particle_effects.utils.StatusEffectUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ParticleEffectsManager {
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((ResourceKey)Registries.f_256890_, (String)"particle_effects");
    private static final Map<String, RegistryObject<SimpleParticleType>> REGISTERED_PARTICLES = new HashMap<String, RegistryObject<SimpleParticleType>>();
    private static final Map<MobEffect, RegistryObject<SimpleParticleType>> EFFECT_TO_PARTICLE = new HashMap<MobEffect, RegistryObject<SimpleParticleType>>();
    private static final Map<Integer, List<ParticleOptions>> COLOR_TO_PARTICLES_MAP = new HashMap<Integer, List<ParticleOptions>>();
    private static final HashMap<ParticleOptions, MobEffect> MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE = ParticleEffectsManager.getMinecraftEffectWidthTexturedParticles();

    @Nullable
    public static List<ParticleOptions> getParticleEffects(Integer i) {
        return COLOR_TO_PARTICLES_MAP.get(i);
    }

    private static RegistryObject<SimpleParticleType> registerParticleTypeForEffect(MobEffect statusEffect, ResourceLocation effectId) {
        ResourceLocation modEffectId = ParticleEffectsManager.getModEffectId(statusEffect, effectId);
        String registryName = modEffectId.m_135815_();
        RegistryObject holder = PARTICLES.register(registryName, () -> new SimpleParticleType(false));
        REGISTERED_PARTICLES.put(registryName, (RegistryObject<SimpleParticleType>)holder);
        return holder;
    }

    private static ResourceLocation getModEffectId(MobEffect statusEffect, ResourceLocation effectId) {
        boolean bl = MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE.containsValue(statusEffect);
        return ParticleEffects.id(effectId.m_135815_() + (bl ? "_new" : ""));
    }

    public static void onInitialize() {
        for (Holder.Reference reference : BuiltInRegistries.f_256974_.m_203611_().toList()) {
            MobEffect statusEffect = (MobEffect)reference.m_203334_();
            ResourceLocation id = reference.m_205785_().m_135782_();
            if (!id.m_135827_().equals("minecraft")) continue;
            RegistryObject<SimpleParticleType> holder = ParticleEffectsManager.registerParticleTypeForEffect(statusEffect, id);
            EFFECT_TO_PARTICLE.put(statusEffect, holder);
        }
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(NetworkHandler::init);
        event.enqueueWork(() -> {
            ResourceLocation id;
            for (Map.Entry<MobEffect, RegistryObject<SimpleParticleType>> entry : EFFECT_TO_PARTICLE.entrySet()) {
                StatusEffectUtils.swapParticle(entry.getKey(), (ParticleOptions)entry.getValue().get());
            }
            for (Holder.Reference reference : BuiltInRegistries.f_256980_.m_203611_().toList()) {
                Potion potion = (Potion)reference.m_203334_();
                id = reference.m_205785_().m_135782_();
                if (!id.m_135827_().equals("minecraft")) continue;
                List effects = potion.m_43488_();
                int color = ArgbUtils.getColorWithoutAlpha(StatusEffectUtils.getColor(effects));
                List particleEffects = effects.stream().map(MobEffectInstance::m_19544_).flatMap(effect -> {
                    ParticleOptions particleEffect = ((PEStatusEffect)effect).particleEffects$getParticleEffect();
                    if (particleEffect == null) {
                        ParticleEffects.LOGGER.error("[DEV/Potion Registration] Looks like {} effect with color {} doesn't have textured particle, this shouldn't happen! Skipping it registration.", (Object)color, (Object)effect.m_19482_().getString());
                        return Stream.empty();
                    }
                    return Stream.of(particleEffect);
                }).toList();
                COLOR_TO_PARTICLES_MAP.put(color, particleEffects);
            }
            for (Holder.Reference reference : BuiltInRegistries.f_256974_.m_203611_().toList()) {
                MobEffect statusEffect = (MobEffect)reference.m_203334_();
                id = reference.m_205785_().m_135782_();
                if (!id.m_135827_().equals("minecraft")) continue;
                int color = ArgbUtils.getColorWithoutAlpha(statusEffect.m_19484_());
                ParticleOptions particleEffect = ((PEStatusEffect)statusEffect).particleEffects$getParticleEffect();
                if (particleEffect == null) {
                    ParticleEffects.LOGGER.error("[DEV/Effect Registration] Looks like {} effect with color {} doesn't have textured particle, this shouldn't happen! Skipping it registration.", (Object)color, (Object)statusEffect.m_19482_().getString());
                    continue;
                }
                List<ParticleOptions> effects = COLOR_TO_PARTICLES_MAP.get(color);
                if (effects != null) {
                    if (!FMLEnvironment.dist.isClient() || !((Boolean)ParticleEffectsConfig.CLIENT.debugLogEnabled.get()).booleanValue()) continue;
                    ParticleEffects.LOGGER.warn("[DEV/Effect Registration] Found registered effects for color {} from {} effect, skipping it registration. If you just mod user, ignore it.", (Object)color, (Object)statusEffect.m_19482_().getString());
                    continue;
                }
                COLOR_TO_PARTICLES_MAP.put(color, List.of(particleEffect));
            }
        });
    }

    public static Map<String, RegistryObject<SimpleParticleType>> getRegisteredParticles() {
        return REGISTERED_PARTICLES;
    }

    private static HashMap<ParticleOptions, MobEffect> getMinecraftEffectWidthTexturedParticles() {
        return new HashMap<ParticleOptions, MobEffect>();
    }

    public static MobEffect getVanillaStatusEffectByStatusEffect(ParticleOptions parameters) {
        return MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE.get(parameters);
    }
}

