/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.villagers.json;

import com.glisco.numismaticoverhaul.NumismaticOverhaul;
import com.glisco.numismaticoverhaul.villagers.data.NumismaticVillagerTradesRegistry;
import com.glisco.numismaticoverhaul.villagers.exceptions.DeserializationContext;
import com.glisco.numismaticoverhaul.villagers.exceptions.DeserializationException;
import com.glisco.numismaticoverhaul.villagers.json.TradeJsonAdapter;
import com.glisco.numismaticoverhaul.villagers.json.adapters.BuyStackAdapter;
import com.glisco.numismaticoverhaul.villagers.json.adapters.DimensionAwareSellStackAdapter;
import com.glisco.numismaticoverhaul.villagers.json.adapters.EnchantItemAdapter;
import com.glisco.numismaticoverhaul.villagers.json.adapters.ProcessItemAdapter;
import com.glisco.numismaticoverhaul.villagers.json.adapters.SellDyedArmorAdapter;
import com.glisco.numismaticoverhaul.villagers.json.adapters.SellMapAdapter;
import com.glisco.numismaticoverhaul.villagers.json.adapters.SellPotionContainerItemAdapter;
import com.glisco.numismaticoverhaul.villagers.json.adapters.SellSingleEnchantmentAdapter;
import com.glisco.numismaticoverhaul.villagers.json.adapters.SellStackAdapter;
import com.glisco.numismaticoverhaul.villagers.json.adapters.SellSusStewAdapter;
import com.glisco.numismaticoverhaul.villagers.json.adapters.SellTagAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class VillagerTradesHandler {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Map<String, Integer> professionKeys = new HashMap<String, Integer>();
    public static final Map<class_2960, TradeJsonAdapter> tradeTypesRegistry = new HashMap<class_2960, TradeJsonAdapter>();
    private static final List<DeserializationException> EXCEPTIONS_DURING_LOADING = new ArrayList<DeserializationException>();

    public static void registerDefaultAdapters() {
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_stack"), new SellStackAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_sus_stew"), new SellSusStewAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_tag"), new SellTagAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("dimension_sell_stack"), new DimensionAwareSellStackAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_map"), new SellMapAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_single_enchantment"), new SellSingleEnchantmentAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("enchant_item"), new EnchantItemAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("process_item"), new ProcessItemAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_dyed_armor"), new SellDyedArmorAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_potion_container"), new SellPotionContainerItemAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("buy_item"), new BuyStackAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("buy_stack"), new BuyStackAdapter());
    }

    public static void loadProfession(class_2960 fileId, JsonObject jsonRoot) {
        DeserializationContext.clear();
        String fileName = "\u00a7a" + fileId.method_12836() + "\u00a7f:\u00a76" + fileId.method_12832();
        class_2960 professionId = class_2960.method_12829((String)jsonRoot.get("profession").getAsString());
        DeserializationContext.setFile(fileName);
        DeserializationContext.setProfession(professionId.method_12832());
        try {
            if (professionId.method_12832().equals("wandering_trader")) {
                VillagerTradesHandler.deserializeTrades(jsonRoot, NumismaticVillagerTradesRegistry::registerWanderingTraderTrade);
            } else {
                class_3852 profession = (class_3852)class_7923.field_41195.method_17966(professionId).orElseThrow(() -> new DeserializationException("Invalid profession"));
                VillagerTradesHandler.deserializeTrades(jsonRoot, (integer, factory) -> NumismaticVillagerTradesRegistry.registerVillagerTrade(profession, integer, factory));
            }
        }
        catch (DeserializationException e) {
            VillagerTradesHandler.addLoadingException(e);
        }
    }

    private static void deserializeTrades(@NotNull JsonObject jsonRoot, BiConsumer<Integer, class_3853.class_1652> tradeConsumer) {
        if (!jsonRoot.get("trades").isJsonObject()) {
            throw new DeserializationException(String.valueOf(jsonRoot.get("trades")) + " is not a JsonObject");
        }
        for (Map.Entry entry : jsonRoot.get("trades").getAsJsonObject().entrySet()) {
            int level = professionKeys.get(entry.getKey());
            if (!((JsonElement)entry.getValue()).isJsonArray()) {
                throw new DeserializationException(String.valueOf(entry.getValue()) + " is not a JsonArray");
            }
            JsonArray tradesArray = ((JsonElement)entry.getValue()).getAsJsonArray();
            for (JsonElement tradeElement : tradesArray) {
                if (!tradeElement.isJsonObject()) {
                    VillagerTradesHandler.addLoadingException(new DeserializationException(String.valueOf(tradeElement) + " is not a JsonObject"));
                    continue;
                }
                JsonObject trade = tradeElement.getAsJsonObject();
                DeserializationContext.setTrade(trade);
                DeserializationContext.setLevel(level);
                if (!trade.has("type")) {
                    throw new DeserializationException("Type missing");
                }
                TradeJsonAdapter adapter = tradeTypesRegistry.get(class_2960.method_12829((String)trade.get("type").getAsString()));
                if (adapter == null) {
                    throw new DeserializationException("Unknown trade type " + trade.get("type").getAsString());
                }
                try {
                    tradeConsumer.accept(level, adapter.deserialize(trade));
                }
                catch (DeserializationException e) {
                    VillagerTradesHandler.addLoadingException(e);
                }
            }
        }
    }

    public static void addLoadingException(DeserializationException e) {
        EXCEPTIONS_DURING_LOADING.add(e);
        NumismaticOverhaul.LOGGER.error("");
        NumismaticOverhaul.LOGGER.error(" -- Caught exception during loading trade definitions, full stacktrace commencing -- ");
        NumismaticOverhaul.LOGGER.error("");
        e.printStackTrace();
    }

    public static void broadcastErrors(MinecraftServer server) {
        VillagerTradesHandler.broadcastErrors(server.method_3760().method_14571());
    }

    public static void broadcastErrors(List<class_3222> players) {
        if (!EXCEPTIONS_DURING_LOADING.isEmpty()) {
            players.forEach(playerEntity -> {
                playerEntity.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cThe following errors have occurred during numismatic-overhaul reload:"), false);
                playerEntity.method_7353((class_2561)class_2561.method_43473(), false);
                EXCEPTIONS_DURING_LOADING.forEach(e -> {
                    class_5250 message = class_2561.method_43470((String)("\u00a77-> " + e.getMessage() + " \u00a78(hover for more info)"));
                    class_5250 hoverText = class_2561.method_43470((String)"");
                    hoverText.method_10852((class_2561)class_2561.method_43470((String)("File: \u00a77" + e.getContext().file + "\n\n")));
                    hoverText.method_10852((class_2561)class_2561.method_43470((String)("Profession: \u00a7a" + e.getContext().profession + "\n")));
                    hoverText.method_10852((class_2561)class_2561.method_43470((String)("Level: \u00a76" + e.getContext().level + "\n\n")));
                    hoverText.method_10852((class_2561)class_2561.method_43470((String)("Problematic trade: \n\u00a77" + GSON.toJson((JsonElement)e.getContext().trade))));
                    message.method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hoverText)));
                    playerEntity.method_7353((class_2561)message, false);
                });
            });
            EXCEPTIONS_DURING_LOADING.clear();
        }
    }

    static {
        professionKeys.put("novice", 1);
        professionKeys.put("apprentice", 2);
        professionKeys.put("journeyman", 3);
        professionKeys.put("expert", 4);
        professionKeys.put("master", 5);
    }
}

