/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.block;

import com.glisco.numismaticoverhaul.block.ShopBlockEntity;
import com.glisco.numismaticoverhaul.currency.CurrencyConverter;
import com.glisco.numismaticoverhaul.item.MoneyBagItem;
import com.glisco.numismaticoverhaul.villagers.data.NumismaticTradeOfferExtensions;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ShopOffer {
    private final class_1799 sell;
    private final long price;

    public ShopOffer(class_1799 sell, long price) {
        if (sell.method_7960()) {
            throw new IllegalArgumentException("Sell Stack must not be empty");
        }
        if (price == 0L) {
            throw new IllegalArgumentException("Price must not be null");
        }
        this.sell = sell;
        this.price = price;
    }

    public class_1914 toTradeOffer(ShopBlockEntity shop, boolean inexhaustible) {
        class_1799 buy = CurrencyConverter.getRequiredCurrencyTypes(this.price) == 1 ? CurrencyConverter.getAsItemStackList(this.price).get(0) : MoneyBagItem.create(this.price);
        int maxUses = inexhaustible ? Integer.MAX_VALUE : ShopOffer.count(shop.getItems(), this.sell) / this.sell.method_7947();
        class_1914 tradeOffer = new class_1914(buy, this.sell, maxUses, 0, 0.0f);
        ((NumismaticTradeOfferExtensions)tradeOffer).numismatic$setReputation(-69420);
        return tradeOffer;
    }

    public long getPrice() {
        return this.price;
    }

    public class_1799 getSellStack() {
        return this.sell.method_7972();
    }

    public static class_2487 writeAll(class_2487 tag, List<ShopOffer> offers) {
        class_2499 offerList = new class_2499();
        for (ShopOffer offer : offers) {
            offerList.add((Object)offer.toNbt());
        }
        tag.method_10566("Offers", (class_2520)offerList);
        return tag;
    }

    public static void readAll(class_2487 tag, List<ShopOffer> offers) {
        offers.clear();
        class_2499 offerList = tag.method_10554("Offers", 10);
        for (class_2520 offerTag : offerList) {
            offers.add(ShopOffer.fromNbt((class_2487)offerTag));
        }
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10544("Price", this.price);
        class_2487 itemNbt = new class_2487();
        this.sell.method_7953(itemNbt);
        nbt.method_10566("Item", (class_2520)itemNbt);
        return nbt;
    }

    public static ShopOffer fromNbt(class_2487 nbt) {
        class_1799 item = class_1799.method_7915((class_2487)nbt.method_10562("Item"));
        return new ShopOffer(item, nbt.method_10537("Price"));
    }

    public static int count(class_2371<class_1799> stacks, class_1799 testStack) {
        int count = 0;
        for (class_1799 stack : stacks) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)testStack)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public static int remove(class_2371<class_1799> stacks, class_1799 removeStack) {
        int toRemove = removeStack.method_7947();
        for (class_1799 stack : stacks) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)removeStack)) continue;
            int removed = stack.method_7947();
            stack.method_7934(toRemove);
            if ((toRemove -= removed) >= 1) continue;
            break;
        }
        return removeStack.method_7947() - toRemove;
    }

    public String toString() {
        return String.valueOf(this.sell) + "@" + this.price + "coins";
    }
}

